/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.imp.pdb.facts.IDateTime;
import org.eclipse.imp.pdb.facts.impl.Value;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeValue
extends Value
implements IDateTime {
    private final Calendar fDateTimeComplete;
    private final DateTimeEnum fDateTimeType;

    public DateTimeValue(int year, int month, int day) {
        super(TypeFactory.getInstance().dateTimeType());
        this.fDateTimeComplete = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        this.fDateTimeComplete.setLenient(false);
        this.fDateTimeComplete.set(year, month - 1, day, 0, 0, 0);
        this.fDateTimeComplete.set(14, 0);
        this.fDateTimeType = DateTimeEnum.DATE;
    }

    public DateTimeValue(int hour, int minute, int second, int millisecond) {
        super(TypeFactory.getInstance().dateTimeType());
        this.fDateTimeComplete = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        this.fDateTimeComplete.setLenient(false);
        this.fDateTimeComplete.set(1970, 0, 1, hour, minute, second);
        this.fDateTimeComplete.set(14, millisecond);
        this.fDateTimeType = DateTimeEnum.TIME;
    }

    public DateTimeValue(int hour, int minute, int second, int millisecond, int hourOffset, int minuteOffset) {
        super(TypeFactory.getInstance().dateTimeType());
        String tzString = this.getTZString(hourOffset, minuteOffset);
        this.fDateTimeComplete = Calendar.getInstance(TimeZone.getTimeZone(tzString), Locale.getDefault());
        this.fDateTimeComplete.setLenient(false);
        this.fDateTimeComplete.set(1970, 0, 1, hour, minute, second);
        this.fDateTimeComplete.set(14, millisecond);
        this.fDateTimeType = DateTimeEnum.TIME;
    }

    private String getTZString(int hourOffset, int minuteOffset) {
        String tzString = "GMT" + (hourOffset < 0 || hourOffset == 0 && minuteOffset < 0 ? "-" : "+") + String.format("%02d", hourOffset >= 0 ? hourOffset : hourOffset * -1) + String.format("%02d", minuteOffset >= 0 ? minuteOffset : minuteOffset * -1);
        return tzString;
    }

    public DateTimeValue(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        super(TypeFactory.getInstance().dateTimeType());
        this.fDateTimeComplete = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        this.fDateTimeComplete.setLenient(false);
        this.fDateTimeComplete.set(year, month - 1, day, hour, minute, second);
        this.fDateTimeComplete.set(14, millisecond);
        this.fDateTimeType = DateTimeEnum.DATETIME;
    }

    public DateTimeValue(int year, int month, int day, int hour, int minute, int second, int millisecond, int hourOffset, int minuteOffset) {
        super(TypeFactory.getInstance().dateTimeType());
        String tzString = this.getTZString(hourOffset, minuteOffset);
        this.fDateTimeComplete = Calendar.getInstance(TimeZone.getTimeZone(tzString), Locale.getDefault());
        this.fDateTimeComplete.setLenient(false);
        this.fDateTimeComplete.set(year, month - 1, day, hour, minute, second);
        this.fDateTimeComplete.set(14, millisecond);
        this.fDateTimeType = DateTimeEnum.DATETIME;
    }

    public DateTimeValue(long instant) {
        super(TypeFactory.getInstance().dateTimeType());
        this.fDateTimeComplete = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        this.fDateTimeComplete.setLenient(false);
        this.fDateTimeComplete.setTime(new Date(instant));
        this.fDateTimeType = DateTimeEnum.DATETIME;
    }

    @Override
    public int getCentury() {
        if (DateTimeEnum.DATE == this.fDateTimeType || DateTimeEnum.DATETIME == this.fDateTimeType) {
            return (this.fDateTimeComplete.get(1) - this.fDateTimeComplete.get(1) % 100) / 100;
        }
        return 0;
    }

    @Override
    public int getDayOfMonth() {
        if (DateTimeEnum.DATE == this.fDateTimeType || DateTimeEnum.DATETIME == this.fDateTimeType) {
            return this.fDateTimeComplete.get(5);
        }
        return 0;
    }

    @Override
    public int getHourOfDay() {
        if (DateTimeEnum.TIME == this.fDateTimeType || DateTimeEnum.DATETIME == this.fDateTimeType) {
            return this.fDateTimeComplete.get(11);
        }
        return 0;
    }

    @Override
    public long getInstant() {
        return this.fDateTimeComplete.getTimeInMillis();
    }

    @Override
    public int getMillisecondsOfSecond() {
        if (DateTimeEnum.TIME == this.fDateTimeType || DateTimeEnum.DATETIME == this.fDateTimeType) {
            return this.fDateTimeComplete.get(14);
        }
        return 0;
    }

    @Override
    public int getMinuteOfHour() {
        if (DateTimeEnum.TIME == this.fDateTimeType || DateTimeEnum.DATETIME == this.fDateTimeType) {
            return this.fDateTimeComplete.get(12);
        }
        return 0;
    }

    @Override
    public int getMonthOfYear() {
        if (DateTimeEnum.DATE == this.fDateTimeType || DateTimeEnum.DATETIME == this.fDateTimeType) {
            return this.fDateTimeComplete.get(2) + 1;
        }
        return 0;
    }

    @Override
    public int getSecondOfMinute() {
        if (DateTimeEnum.TIME == this.fDateTimeType || DateTimeEnum.DATETIME == this.fDateTimeType) {
            return this.fDateTimeComplete.get(13);
        }
        return 0;
    }

    @Override
    public int getTimezoneOffsetHours() {
        if (DateTimeEnum.TIME == this.fDateTimeType || DateTimeEnum.DATETIME == this.fDateTimeType) {
            int hourOffset = this.fDateTimeComplete.get(15) / 3600000;
            return hourOffset;
        }
        return 0;
    }

    @Override
    public int getTimezoneOffsetMinutes() {
        if (DateTimeEnum.TIME == this.fDateTimeType || DateTimeEnum.DATETIME == this.fDateTimeType) {
            int minuteOffset = this.fDateTimeComplete.get(15) / 60000 % 60;
            return minuteOffset;
        }
        return 0;
    }

    @Override
    public int getYear() {
        if (DateTimeEnum.DATE == this.fDateTimeType || DateTimeEnum.DATETIME == this.fDateTimeType) {
            return this.fDateTimeComplete.get(1);
        }
        return 0;
    }

    @Override
    public boolean isDate() {
        return DateTimeEnum.DATE == this.fDateTimeType;
    }

    @Override
    public boolean isDateTime() {
        return DateTimeEnum.DATETIME == this.fDateTimeType;
    }

    @Override
    public boolean isTime() {
        return DateTimeEnum.TIME == this.fDateTimeType;
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitDateTime(this);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fDateTimeComplete == null ? 0 : this.fDateTimeComplete.hashCode());
        result = 31 * result + (this.fDateTimeType == null ? 0 : this.fDateTimeType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTimeValue other = (DateTimeValue)obj;
        if (this.fDateTimeComplete == null ? other.fDateTimeComplete != null : this.fDateTimeComplete.compareTo(other.fDateTimeComplete) != 0) {
            return false;
        }
        return !(this.fDateTimeType == null ? other.fDateTimeType != null : !this.fDateTimeType.equals((Object)other.fDateTimeType));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DateTimeEnum {
        DATE,
        TIME,
        DATETIME;

    }
}

