/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.imp.pdb.facts.IDateTime;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.Value;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeValue
extends Value
implements IDateTime {
    private static final Type DATE_TIME_TYPE = TypeFactory.getInstance().dateTimeType();
    private final Calendar dateTimeComplete;
    private final DATE_TIME_ENUM dateTimeType;

    protected DateTimeValue(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        this.dateTimeComplete = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        this.dateTimeComplete.setLenient(false);
        this.dateTimeComplete.set(year, month - 1, day, hour, minute, second);
        this.dateTimeComplete.set(14, millisecond);
        this.dateTimeType = DATE_TIME_ENUM.DATETIME;
    }

    protected DateTimeValue(int year, int month, int day, int hour, int minute, int second, int millisecond, int hourOffset, int minuteOffset) {
        String tzString = DateTimeValue.getTZString(hourOffset, minuteOffset);
        this.dateTimeComplete = Calendar.getInstance(TimeZone.getTimeZone(tzString), Locale.getDefault());
        this.dateTimeComplete.setLenient(false);
        this.dateTimeComplete.set(year, month - 1, day, hour, minute, second);
        this.dateTimeComplete.set(14, millisecond);
        this.dateTimeType = DATE_TIME_ENUM.DATETIME;
    }

    protected DateTimeValue(int year, int month, int day) {
        this.dateTimeComplete = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        this.dateTimeComplete.setLenient(false);
        this.dateTimeComplete.set(year, month - 1, day, 0, 0, 0);
        this.dateTimeComplete.set(14, 0);
        this.dateTimeType = DATE_TIME_ENUM.DATE;
    }

    protected DateTimeValue(int hour, int minute, int second, int millisecond) {
        this.dateTimeComplete = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        this.dateTimeComplete.setLenient(false);
        this.dateTimeComplete.set(1970, 0, 1, hour, minute, second);
        this.dateTimeComplete.set(14, millisecond);
        this.dateTimeType = DATE_TIME_ENUM.TIME;
    }

    protected DateTimeValue(int hour, int minute, int second, int millisecond, int hourOffset, int minuteOffset) {
        String tzString = DateTimeValue.getTZString(hourOffset, minuteOffset);
        this.dateTimeComplete = Calendar.getInstance(TimeZone.getTimeZone(tzString), Locale.getDefault());
        this.dateTimeComplete.setLenient(false);
        this.dateTimeComplete.set(1970, 0, 1, hour, minute, second);
        this.dateTimeComplete.set(14, millisecond);
        this.dateTimeType = DATE_TIME_ENUM.TIME;
    }

    protected DateTimeValue(long instant) {
        this.dateTimeComplete = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        this.dateTimeComplete.setLenient(false);
        this.dateTimeComplete.setTime(new Date(instant));
        this.dateTimeType = DATE_TIME_ENUM.DATETIME;
    }

    private static String getTZString(int hourOffset, int minuteOffset) {
        String tzString = "GMT" + (hourOffset < 0 || hourOffset == 0 && minuteOffset < 0 ? "-" : "+") + String.format("%02d", hourOffset >= 0 ? hourOffset : hourOffset * -1) + String.format("%02d", minuteOffset >= 0 ? minuteOffset : minuteOffset * -1);
        return tzString;
    }

    @Override
    public Type getType() {
        return DATE_TIME_TYPE;
    }

    @Override
    public boolean isDateTime() {
        return this.dateTimeType == DATE_TIME_ENUM.DATETIME;
    }

    @Override
    public boolean isDate() {
        return this.dateTimeType == DATE_TIME_ENUM.DATE;
    }

    @Override
    public boolean isTime() {
        return this.dateTimeType == DATE_TIME_ENUM.TIME;
    }

    @Override
    public int getCentury() {
        if (this.dateTimeType == DATE_TIME_ENUM.TIME) {
            return 0;
        }
        return (this.dateTimeComplete.get(1) - this.dateTimeComplete.get(1) % 100) / 100;
    }

    @Override
    public int getYear() {
        if (this.dateTimeType == DATE_TIME_ENUM.TIME) {
            return 0;
        }
        return this.dateTimeComplete.get(1);
    }

    @Override
    public int getMonthOfYear() {
        if (this.dateTimeType == DATE_TIME_ENUM.TIME) {
            return 0;
        }
        return this.dateTimeComplete.get(2) + 1;
    }

    @Override
    public int getDayOfMonth() {
        if (this.dateTimeType == DATE_TIME_ENUM.TIME) {
            return 0;
        }
        return this.dateTimeComplete.get(5);
    }

    @Override
    public int getHourOfDay() {
        if (this.dateTimeType == DATE_TIME_ENUM.DATE) {
            return 0;
        }
        return this.dateTimeComplete.get(11);
    }

    @Override
    public int getMinuteOfHour() {
        if (this.dateTimeType == DATE_TIME_ENUM.DATE) {
            return 0;
        }
        return this.dateTimeComplete.get(12);
    }

    @Override
    public int getSecondOfMinute() {
        if (this.dateTimeType == DATE_TIME_ENUM.DATE) {
            return 0;
        }
        return this.dateTimeComplete.get(13);
    }

    @Override
    public int getMillisecondsOfSecond() {
        if (this.dateTimeType == DATE_TIME_ENUM.DATE) {
            return 0;
        }
        return this.dateTimeComplete.get(14);
    }

    @Override
    public int getTimezoneOffsetHours() {
        if (this.dateTimeType == DATE_TIME_ENUM.DATE) {
            return 0;
        }
        return this.dateTimeComplete.get(15) / 3600000;
    }

    @Override
    public int getTimezoneOffsetMinutes() {
        if (this.dateTimeType == DATE_TIME_ENUM.DATE) {
            return 0;
        }
        return this.dateTimeComplete.get(15) / 60000 % 60;
    }

    @Override
    public long getInstant() {
        return this.dateTimeComplete.getTimeInMillis();
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitDateTime(this);
    }

    public int hashCode() {
        return this.dateTimeComplete.hashCode();
    }

    @Override
    public boolean isEqual(IValue v) {
        return this.equals(v);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return this.dateTimeComplete.compareTo(((DateTimeValue)o).dateTimeComplete) == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DATE_TIME_ENUM {
        DATE,
        TIME,
        DATETIME;

    }
}

