/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.IRelationWriter;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.Relation;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesHashSet;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationWriter
implements IRelationWriter {
    protected Type tupleType;
    protected final ShareableValuesHashSet data;
    protected IRelation constructedRelation;
    protected final boolean inferred;

    protected RelationWriter(Type tupleType) {
        if (!tupleType.isTupleType()) {
            throw new IllegalArgumentException("should be a tuple type");
        }
        this.tupleType = tupleType;
        this.inferred = false;
        this.data = new ShareableValuesHashSet();
        this.constructedRelation = null;
    }

    protected RelationWriter() {
        this.tupleType = TypeFactory.getInstance().voidType();
        this.data = new ShareableValuesHashSet();
        this.constructedRelation = null;
        this.inferred = true;
    }

    protected RelationWriter(Type tupleType, ShareableValuesHashSet data) {
        this.tupleType = tupleType;
        this.data = new ShareableValuesHashSet(data);
        this.inferred = false;
        this.constructedRelation = null;
    }

    public void insert(IValue element) {
        this.checkMutation();
        this.updateType(element);
        this.data.add(element);
    }

    private void updateType(IValue element) {
        if (this.inferred) {
            this.tupleType = this.tupleType.lub(element.getType());
            if (!this.tupleType.isTupleType()) {
                throw new IllegalArgumentException("relations can only contain tuples of the same arity");
            }
        }
    }

    @Override
    public void insert(IValue ... elements) {
        this.checkMutation();
        int i = elements.length - 1;
        while (i >= 0) {
            this.updateType(elements[i]);
            this.data.add(elements[i]);
            --i;
        }
    }

    @Override
    public void insertAll(Iterable<IValue> collection) {
        this.checkMutation();
        for (IValue next : collection) {
            this.updateType(next);
            this.data.add(next);
        }
    }

    @Override
    public void delete(IValue element) {
        this.checkMutation();
        this.data.remove(element);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    protected void checkMutation() {
        if (this.constructedRelation != null) {
            throw new UnsupportedOperationException("Mutation of a finalized map is not supported.");
        }
    }

    @Override
    public IRelation done() {
        if (this.constructedRelation == null) {
            this.constructedRelation = new Relation(this.tupleType, this.data);
        }
        return this.constructedRelation;
    }
}

