/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.util.collections;

import java.util.Iterator;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.util.ShareableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareableValuesList
extends ShareableList<IValue> {
    public ShareableValuesList() {
    }

    public ShareableValuesList(ShareableValuesList shareableValuesList) {
        super(shareableValuesList);
    }

    public ShareableValuesList(ShareableValuesList shareableValuesList, int offset, int length) {
        super(shareableValuesList, offset, length);
    }

    public boolean isEqual(ShareableValuesList otherShareableValuesList) {
        if (otherShareableValuesList == null) {
            return false;
        }
        if (otherShareableValuesList.size() != this.size()) {
            return false;
        }
        if (otherShareableValuesList.isEmpty()) {
            return true;
        }
        Iterator thisListIterator = this.iterator();
        Iterator otherListIterator = otherShareableValuesList.iterator();
        while (thisListIterator.hasNext()) {
            IValue otherValue;
            IValue thisValue = (IValue)thisListIterator.next();
            if (thisValue.isEqual(otherValue = (IValue)otherListIterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean contains(IValue value) {
        for (IValue next : this) {
            if (!next.isEqual(value)) continue;
            return true;
        }
        return false;
    }

    public boolean remove(IValue value) {
        int index = 0;
        for (IValue next : this) {
            if (next.isEqual(value)) break;
            ++index;
        }
        if (index < this.size()) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public ShareableValuesList subList(int offset, int length) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Offset may not be smaller then 0.");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length may not be smaller then 0.");
        }
        if (offset + length > this.size()) {
            throw new IndexOutOfBoundsException("'offset + length' may not be larger then 'list.size()'");
        }
        return new ShareableValuesList(this, offset, length);
    }
}

