/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.io;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IDateTime;
import org.eclipse.imp.pdb.facts.IExternalValue;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ISourceLocation;
import org.eclipse.imp.pdb.facts.IString;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.io.IValueWriter;
import org.eclipse.imp.pdb.facts.type.TypeStore;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

public class StandardTextWriter
implements IValueWriter {
    public void write(IValue value, OutputStream stream) throws IOException {
        try {
            value.accept(new Writer(stream));
        }
        catch (VisitorException e) {
            throw (IOException)e.getCause();
        }
    }

    public void write(IValue value, OutputStream stream, TypeStore typeStore) throws IOException {
        this.write(value, stream);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Writer
    implements IValueVisitor<IValue> {
        private OutputStream stream;

        public Writer(OutputStream stream) {
            this.stream = stream;
        }

        private void append(String string) throws VisitorException {
            try {
                this.stream.write(string.getBytes());
            }
            catch (IOException e) {
                throw new VisitorException(e);
            }
        }

        private void append(char c) throws VisitorException {
            try {
                this.stream.write(c);
            }
            catch (IOException e) {
                throw new VisitorException(e);
            }
        }

        @Override
        public IValue visitBoolean(IBool boolValue) throws VisitorException {
            this.append(boolValue.getValue() ? "true" : "false");
            return boolValue;
        }

        @Override
        public IValue visitConstructor(IConstructor o) throws VisitorException {
            return this.visitNode(o);
        }

        @Override
        public IValue visitReal(IReal o) throws VisitorException {
            this.append(o.getStringRepresentation());
            return o;
        }

        @Override
        public IValue visitInteger(IInteger o) throws VisitorException {
            this.append(o.getStringRepresentation());
            return o;
        }

        @Override
        public IValue visitList(IList o) throws VisitorException {
            this.append('[');
            Iterator listIterator = o.iterator();
            if (listIterator.hasNext()) {
                ((IValue)listIterator.next()).accept(this);
                while (listIterator.hasNext()) {
                    this.append(',');
                    ((IValue)listIterator.next()).accept(this);
                }
            }
            this.append(']');
            return o;
        }

        @Override
        public IValue visitMap(IMap o) throws VisitorException {
            this.append('(');
            Iterator<IValue> mapIterator = o.iterator();
            if (mapIterator.hasNext()) {
                IValue key = mapIterator.next();
                key.accept(this);
                this.append(':');
                o.get(key).accept(this);
                while (mapIterator.hasNext()) {
                    this.append(',');
                    key = mapIterator.next();
                    key.accept(this);
                    this.append(':');
                    o.get(key).accept(this);
                }
            }
            this.append(')');
            return o;
        }

        @Override
        public IValue visitNode(INode o) throws VisitorException {
            String name = o.getName();
            if (name.indexOf(45) != -1) {
                this.append('\\');
            }
            this.append(name);
            this.append('(');
            Iterator<IValue> it = o.iterator();
            while (it.hasNext()) {
                it.next().accept(this);
                if (!it.hasNext()) continue;
                this.append(',');
            }
            this.append(')');
            if (o.hasAnnotations()) {
                this.append('[');
                int i = 0;
                Map<String, IValue> annotations = o.getAnnotations();
                for (String key : annotations.keySet()) {
                    this.append("@" + key + "=");
                    annotations.get(key).accept(this);
                    if (++i >= annotations.size()) continue;
                    this.append(",");
                }
                this.append(']');
            }
            return o;
        }

        @Override
        public IValue visitRelation(IRelation o) throws VisitorException {
            return this.visitSet(o);
        }

        @Override
        public IValue visitSet(ISet o) throws VisitorException {
            this.append('{');
            Iterator setIterator = o.iterator();
            if (setIterator.hasNext()) {
                ((IValue)setIterator.next()).accept(this);
                while (setIterator.hasNext()) {
                    this.append(",");
                    ((IValue)setIterator.next()).accept(this);
                }
            }
            this.append('}');
            return o;
        }

        @Override
        public IValue visitSourceLocation(ISourceLocation o) throws VisitorException {
            this.append('|');
            this.append(o.getURI().toString());
            this.append('|');
            if (o.getOffset() != -1) {
                this.append('(');
                this.append(Integer.toString(o.getOffset()));
                this.append(',');
                this.append(Integer.toString(o.getLength()));
                this.append(',');
                this.append('<');
                this.append(Integer.toString(o.getBeginLine()));
                this.append(',');
                this.append(Integer.toString(o.getBeginColumn()));
                this.append('>');
                this.append(',');
                this.append('<');
                this.append(Integer.toString(o.getEndLine()));
                this.append(',');
                this.append(Integer.toString(o.getEndColumn()));
                this.append('>');
                this.append(')');
            }
            return o;
        }

        @Override
        public IValue visitString(IString o) throws VisitorException {
            this.append('\"');
            byte[] byArray = o.getValue().getBytes();
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte ch = byArray[n2];
                switch (ch) {
                    case 34: {
                        this.append('\\');
                        this.append('\"');
                        break;
                    }
                    case 39: {
                        this.append('\\');
                        this.append('\'');
                    }
                    case 92: {
                        this.append('\\');
                        this.append('\\');
                        break;
                    }
                    case 10: {
                        this.append('\\');
                        this.append('n');
                        break;
                    }
                    case 13: {
                        this.append('\\');
                        this.append('r');
                        break;
                    }
                    case 9: {
                        this.append('\\');
                        this.append('t');
                        break;
                    }
                    default: {
                        this.append((char)ch);
                    }
                }
                ++n2;
            }
            this.append('\"');
            return o;
        }

        @Override
        public IValue visitTuple(ITuple o) throws VisitorException {
            this.append('<');
            Iterator it = o.iterator();
            if (it.hasNext()) {
                ((IValue)it.next()).accept(this);
            }
            while (it.hasNext()) {
                this.append(',');
                ((IValue)it.next()).accept(this);
            }
            this.append('>');
            return o;
        }

        @Override
        public IValue visitExternal(IExternalValue externalValue) throws VisitorException {
            this.append(externalValue.toString());
            return externalValue;
        }

        @Override
        public IValue visitDateTime(IDateTime o) throws VisitorException {
            this.append("$");
            if (o.isDate()) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                this.append(df.format(new Date(o.getInstant())));
            } else if (o.isTime()) {
                SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSSZZZ");
                this.append("T");
                this.append(df.format(new Date(o.getInstant())));
            } else {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZZ");
                this.append(df.format(new Date(o.getInstant())));
            }
            return o;
        }
    }
}

