/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.io.binary;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IDateTime;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ISourceLocation;
import org.eclipse.imp.pdb.facts.IString;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeStore;
import org.eclipse.imp.pdb.facts.util.IndexedSet;

public class BinaryWriter {
    private static final int BOOL_HEADER = 1;
    private static final int INTEGER_HEADER = 2;
    private static final int BIG_INTEGER_HEADER = 3;
    private static final int DOUBLE_HEADER = 4;
    private static final int STRING_HEADER = 5;
    private static final int SOURCE_LOCATION_HEADER = 6;
    private static final int DATE_TIME_HEADER = 16;
    private static final int TUPLE_HEADER = 7;
    private static final int NODE_HEADER = 8;
    private static final int ANNOTATED_NODE_HEADER = 9;
    private static final int CONSTRUCTOR_HEADER = 10;
    private static final int ANNOTATED_CONSTRUCTOR_HEADER = 11;
    private static final int LIST_HEADER = 12;
    private static final int SET_HEADER = 13;
    private static final int RELATION_HEADER = 14;
    private static final int MAP_HEADER = 15;
    private static final int VALUE_TYPE_HEADER = 1;
    private static final int VOID_TYPE_HEADER = 2;
    private static final int BOOL_TYPE_HEADER = 3;
    private static final int INTEGER_TYPE_HEADER = 4;
    private static final int DOUBLE_TYPE_HEADER = 5;
    private static final int STRING_TYPE_HEADER = 6;
    private static final int SOURCE_LOCATION_TYPE_HEADER = 7;
    private static final int DATE_TIME_TYPE_HEADER = 20;
    private static final int NODE_TYPE_HEADER = 8;
    private static final int TUPLE_TYPE_HEADER = 9;
    private static final int LIST_TYPE_HEADER = 10;
    private static final int SET_TYPE_HEADER = 11;
    private static final int RELATION_TYPE_HEADER = 12;
    private static final int MAP_TYPE_HEADER = 13;
    private static final int PARAMETER_TYPE_HEADER = 14;
    private static final int ADT_TYPE_HEADER = 15;
    private static final int CONSTRUCTOR_TYPE_HEADER = 16;
    private static final int ALIAS_TYPE_HEADER = 17;
    private static final int ANNOTATED_NODE_TYPE_HEADER = 18;
    private static final int ANNOTATED_CONSTRUCTOR_TYPE_HEADER = 19;
    private static final int SHARED_FLAG = 128;
    private static final int TYPE_SHARED_FLAG = 64;
    private static final int URL_SHARED_FLAG = 32;
    private static final int NAME_SHARED_FLAG = 32;
    private static final int HAS_FIELD_NAMES = 32;
    private static final int DATE_TIME_INDICATOR = 1;
    private static final int DATE_INDICATOR = 2;
    private static final int TIME_INDICATOR = 3;
    private final IndexedSet<IValue> sharedValues;
    private final IndexedSet<Type> sharedTypes;
    private final IndexedSet<String> sharedPaths;
    private final IndexedSet<String> sharedNames;
    private final IValue value;
    private final OutputStream out;
    private final TypeStore typeStore;
    private static final int SEVENBITS = 127;
    private static final int SIGNBIT = 128;

    public BinaryWriter(IValue value, OutputStream outputStream, TypeStore typeStore) {
        this.value = value;
        this.out = outputStream;
        this.typeStore = typeStore;
        this.sharedValues = new IndexedSet();
        this.sharedTypes = new IndexedSet();
        this.sharedPaths = new IndexedSet();
        this.sharedNames = new IndexedSet();
    }

    public void serialize() throws IOException {
        this.doSerialize(this.value);
    }

    private void doSerialize(IValue value) throws IOException {
        int valueId = this.sharedValues.get(value);
        if (valueId != -1) {
            this.out.write(128);
            this.printInteger(valueId);
            return;
        }
        if (value instanceof IBool) {
            this.writeBool((IBool)value);
        } else if (value instanceof IInteger) {
            this.writeInteger((IInteger)value);
        } else if (value instanceof IReal) {
            this.writeDouble((IReal)value);
        } else if (value instanceof IString) {
            this.writeString((IString)value);
        } else if (value instanceof ISourceLocation) {
            this.writeSourceLocation((ISourceLocation)value);
        } else if (value instanceof IDateTime) {
            this.writeDateTime((IDateTime)value);
        } else if (value instanceof ITuple) {
            this.writeTuple((ITuple)value);
        } else if (value instanceof IConstructor) {
            IConstructor constructor = (IConstructor)value;
            if (!constructor.hasAnnotations()) {
                this.writeConstructor(constructor);
            } else {
                this.writeAnnotatedConstructor(constructor);
            }
        } else if (value instanceof INode) {
            INode node = (INode)value;
            if (!node.hasAnnotations()) {
                this.writeNode(node);
            } else {
                this.writeAnnotatedNode(node);
            }
        } else if (value instanceof IList) {
            this.writeList((IList)value);
        } else if (value instanceof IRelation) {
            this.writeRelation((IRelation)value);
        } else if (value instanceof ISet) {
            this.writeSet((ISet)value);
        } else if (value instanceof IMap) {
            this.writeMap((IMap)value);
        }
        this.sharedValues.store(value);
    }

    private void doWriteType(Type type) throws IOException {
        if (type.isVoidType()) {
            this.writeVoidType();
        } else if (type.isAliasType()) {
            this.writeAliasType(type);
        } else if (type.isParameterType()) {
            this.writeParameterType(type);
        } else if (type.isValueType()) {
            this.writeValueType();
        } else if (type.isBoolType()) {
            this.writeBoolType();
        } else if (type.isIntegerType()) {
            this.writeIntegerType();
        } else if (type.isRealType()) {
            this.writeDoubleType();
        } else if (type.isStringType()) {
            this.writeStringType();
        } else if (type.isSourceLocationType()) {
            this.writeSourceLocationType();
        } else if (type.isDateTimeType()) {
            this.writeDateTimeType(type);
        } else if (type.isListType()) {
            this.writeListType(type);
        } else if (type.isSetType()) {
            this.writeSetType(type);
        } else if (type.isRelationType()) {
            this.writeRelationType(type);
        } else if (type.isMapType()) {
            this.writeMapType(type);
        } else if (type.isAbstractDataType()) {
            this.writeADTType(type);
        } else if (type.isConstructorType()) {
            this.writeConstructorType(type);
        } else if (type.isNodeType()) {
            this.writeNodeType(type);
        } else if (type.isTupleType()) {
            this.writeTupleType(type);
        }
    }

    private void writeType(Type type) throws IOException {
        int typeId = this.sharedTypes.get(type);
        if (typeId != -1) {
            this.out.write(128);
            this.printInteger(typeId);
            return;
        }
        this.doWriteType(type);
        this.sharedTypes.store(type);
    }

    private void writeBool(IBool bool) throws IOException {
        this.out.write(1);
        if (bool.getValue()) {
            this.out.write(1);
        } else {
            this.out.write(0);
        }
    }

    private void writeInteger(IInteger integer) throws IOException {
        byte[] valueData = integer.getTwosComplementRepresentation();
        int length = valueData.length;
        if (length <= 4) {
            this.out.write(2);
            int intValue = 0;
            int i = length - 1;
            int j = 0;
            while (i >= 0) {
                intValue |= (valueData[i] & 0xFF) << j * 8;
                --i;
                ++j;
            }
            this.printInteger(intValue);
        } else {
            this.out.write(3);
            this.printInteger(length);
            this.out.write(valueData, 0, length);
        }
    }

    private void writeDouble(IReal real) throws IOException {
        this.out.write(4);
        byte[] valueData = real.unscaled().getTwosComplementRepresentation();
        int length = valueData.length;
        this.printInteger(length);
        this.out.write(valueData, 0, length);
        this.printInteger(real.scale());
    }

    private void writeString(IString string) throws IOException {
        this.out.write(5);
        String theString = string.getValue();
        byte[] stringData = theString.getBytes();
        this.printInteger(stringData.length);
        this.out.write(stringData);
    }

    private void writeSourceLocation(ISourceLocation sourceLocation) throws IOException {
        URI uri = sourceLocation.getURI();
        String path = uri.toString();
        int id = this.sharedPaths.store(path);
        if (id == -1) {
            this.out.write(6);
            byte[] pathData = path.getBytes();
            this.printInteger(pathData.length);
            this.out.write(pathData);
        } else {
            this.out.write(38);
            this.printInteger(id);
        }
        this.printInteger(sourceLocation.getOffset());
        this.printInteger(sourceLocation.getLength());
        this.printInteger(sourceLocation.getBeginLine());
        this.printInteger(sourceLocation.getEndLine());
        this.printInteger(sourceLocation.getBeginColumn());
        this.printInteger(sourceLocation.getEndColumn());
    }

    private void writeDateTime(IDateTime dateTime) throws IOException {
        this.out.write(16);
        if (dateTime.isDateTime()) {
            this.out.write(1);
            this.printInteger(dateTime.getYear());
            this.printInteger(dateTime.getMonthOfYear());
            this.printInteger(dateTime.getDayOfMonth());
            this.printInteger(dateTime.getHourOfDay());
            this.printInteger(dateTime.getMinuteOfHour());
            this.printInteger(dateTime.getSecondOfMinute());
            this.printInteger(dateTime.getMillisecondsOfSecond());
            this.printInteger(dateTime.getTimezoneOffsetHours());
            this.printInteger(dateTime.getTimezoneOffsetMinutes());
        } else if (dateTime.isDate()) {
            this.out.write(2);
            this.printInteger(dateTime.getYear());
            this.printInteger(dateTime.getMonthOfYear());
            this.printInteger(dateTime.getDayOfMonth());
        } else {
            this.out.write(3);
            this.printInteger(dateTime.getHourOfDay());
            this.printInteger(dateTime.getMinuteOfHour());
            this.printInteger(dateTime.getSecondOfMinute());
            this.printInteger(dateTime.getMillisecondsOfSecond());
            this.printInteger(dateTime.getTimezoneOffsetHours());
            this.printInteger(dateTime.getTimezoneOffsetMinutes());
        }
    }

    private void writeTuple(ITuple tuple) throws IOException {
        this.out.write(7);
        int arity = tuple.arity();
        this.printInteger(arity);
        int i = 0;
        while (i < arity) {
            this.doSerialize(tuple.get(i));
            ++i;
        }
    }

    private void writeNode(INode node) throws IOException {
        String nodeName = node.getName();
        int nodeNameId = this.sharedNames.store(nodeName);
        if (nodeNameId == -1) {
            this.out.write(8);
            byte[] nodeData = nodeName.getBytes();
            this.printInteger(nodeData.length);
            this.out.write(nodeData);
        } else {
            this.out.write(40);
            this.printInteger(nodeNameId);
        }
        int arity = node.arity();
        this.printInteger(arity);
        int i = 0;
        while (i < arity) {
            this.doSerialize(node.get(i));
            ++i;
        }
    }

    private void writeAnnotatedNode(INode node) throws IOException {
        String nodeName = node.getName();
        int nodeNameId = this.sharedNames.store(nodeName);
        if (nodeNameId == -1) {
            this.out.write(9);
            byte[] nodeData = nodeName.getBytes();
            this.printInteger(nodeData.length);
            this.out.write(nodeData);
        } else {
            this.out.write(41);
            this.printInteger(nodeNameId);
        }
        int arity = node.arity();
        this.printInteger(arity);
        int i = 0;
        while (i < arity) {
            this.doSerialize(node.get(i));
            ++i;
        }
        Map<String, IValue> annotations = node.getAnnotations();
        this.printInteger(annotations.size());
        for (Map.Entry<String, IValue> annotation : annotations.entrySet()) {
            String label = annotation.getKey();
            byte[] labelData = label.getBytes();
            this.printInteger(labelData.length);
            this.out.write(labelData);
            IValue value = annotation.getValue();
            this.doSerialize(value);
        }
    }

    private void writeConstructor(IConstructor constructor) throws IOException {
        Type constructorType = constructor.getConstructorType();
        int constructorTypeId = this.sharedTypes.get(constructorType);
        if (constructorTypeId == -1) {
            this.out.write(10);
            this.doWriteType(constructorType);
            this.sharedTypes.store(constructorType);
        } else {
            this.out.write(74);
            this.printInteger(constructorTypeId);
        }
        int arity = constructor.arity();
        this.printInteger(arity);
        int i = 0;
        while (i < arity) {
            this.doSerialize(constructor.get(i));
            ++i;
        }
    }

    private void writeAnnotatedConstructor(IConstructor constructor) throws IOException {
        Type constructorType = constructor.getConstructorType();
        int constructorTypeId = this.sharedTypes.get(constructorType);
        if (constructorTypeId == -1) {
            this.out.write(11);
            this.doWriteType(constructorType);
            this.sharedTypes.store(constructorType);
        } else {
            this.out.write(75);
            this.printInteger(constructorTypeId);
        }
        int arity = constructor.arity();
        this.printInteger(arity);
        int i = 0;
        while (i < arity) {
            this.doSerialize(constructor.get(i));
            ++i;
        }
        Map<String, IValue> annotations = constructor.getAnnotations();
        this.printInteger(annotations.size());
        for (Map.Entry<String, IValue> annotation : annotations.entrySet()) {
            String label = annotation.getKey();
            byte[] labelData = label.getBytes();
            this.printInteger(labelData.length);
            this.out.write(labelData);
            IValue value = annotation.getValue();
            this.doSerialize(value);
        }
    }

    private void writeList(IList list) throws IOException {
        Type elementType = list.getElementType();
        int elementTypeId = this.sharedTypes.get(elementType);
        if (elementTypeId == -1) {
            this.out.write(12);
            this.doWriteType(elementType);
            this.sharedTypes.store(elementType);
        } else {
            this.out.write(76);
            this.printInteger(elementTypeId);
        }
        int length = list.length();
        this.printInteger(length);
        int i = 0;
        while (i < length) {
            this.doSerialize(list.get(i));
            ++i;
        }
    }

    private void writeSet(ISet set) throws IOException {
        Type elementType = set.getElementType();
        int elementTypeId = this.sharedTypes.get(elementType);
        if (elementTypeId == -1) {
            this.out.write(13);
            this.doWriteType(elementType);
            this.sharedTypes.store(elementType);
        } else {
            this.out.write(77);
            this.printInteger(elementTypeId);
        }
        this.printInteger(set.size());
        Iterator content = set.iterator();
        while (content.hasNext()) {
            this.doSerialize((IValue)content.next());
        }
    }

    private void writeRelation(IRelation relation) throws IOException {
        Type elementType = relation.getElementType();
        int elementTypeId = this.sharedTypes.get(elementType);
        if (elementTypeId == -1) {
            this.out.write(14);
            this.doWriteType(elementType);
            this.sharedTypes.store(elementType);
        } else {
            this.out.write(78);
            this.printInteger(elementTypeId);
        }
        this.printInteger(relation.size());
        Iterator content = relation.iterator();
        while (content.hasNext()) {
            this.doSerialize((IValue)content.next());
        }
    }

    private void writeMap(IMap map) throws IOException {
        Type mapType = map.getType();
        int mapTypeId = this.sharedTypes.get(mapType);
        if (mapTypeId == -1) {
            this.out.write(15);
            this.doWriteType(mapType);
            this.sharedTypes.store(mapType);
        } else {
            this.out.write(79);
            this.printInteger(mapTypeId);
        }
        this.printInteger(map.size());
        Iterator<Map.Entry<IValue, IValue>> content = map.entryIterator();
        while (content.hasNext()) {
            Map.Entry<IValue, IValue> entry = content.next();
            this.doSerialize(entry.getKey());
            this.doSerialize(entry.getValue());
        }
    }

    private void writeValueType() throws IOException {
        this.out.write(1);
    }

    private void writeVoidType() throws IOException {
        this.out.write(2);
    }

    private void writeBoolType() throws IOException {
        this.out.write(3);
    }

    private void writeIntegerType() throws IOException {
        this.out.write(4);
    }

    private void writeDoubleType() throws IOException {
        this.out.write(5);
    }

    private void writeStringType() throws IOException {
        this.out.write(6);
    }

    private void writeSourceLocationType() throws IOException {
        this.out.write(7);
    }

    private void writeDateTimeType(Type dateTimeType) throws IOException {
        this.out.write(20);
    }

    private void writeNodeType(Type nodeType) throws IOException {
        Map<String, Type> declaredAnnotations = this.typeStore.getAnnotations(nodeType);
        if (declaredAnnotations.isEmpty()) {
            this.out.write(8);
        } else {
            this.out.write(18);
            int nrOfAnnotations = declaredAnnotations.size();
            this.printInteger(nrOfAnnotations);
            for (Map.Entry<String, Type> declaredAnnotation : declaredAnnotations.entrySet()) {
                String label = declaredAnnotation.getKey();
                byte[] labelBytes = label.getBytes();
                this.printInteger(labelBytes.length);
                this.out.write(labelBytes);
                this.writeType(declaredAnnotation.getValue());
            }
        }
    }

    private void writeTupleType(Type tupleType) throws IOException {
        boolean hasFieldNames = tupleType.hasFieldNames();
        if (hasFieldNames) {
            this.out.write(41);
            int arity = tupleType.getArity();
            this.printInteger(arity);
            int i = 0;
            while (i < arity) {
                this.writeType(tupleType.getFieldType(i));
                String name = tupleType.getFieldName(i);
                byte[] nameData = name.getBytes();
                this.printInteger(nameData.length);
                this.out.write(nameData);
                ++i;
            }
        } else {
            this.out.write(9);
            int arity = tupleType.getArity();
            this.printInteger(arity);
            int i = 0;
            while (i < arity) {
                this.writeType(tupleType.getFieldType(i));
                ++i;
            }
        }
    }

    private void writeListType(Type listType) throws IOException {
        this.out.write(10);
        this.writeType(listType.getElementType());
    }

    private void writeSetType(Type setType) throws IOException {
        this.out.write(11);
        this.writeType(setType.getElementType());
    }

    private void writeRelationType(Type relationType) throws IOException {
        this.out.write(12);
        this.writeType(relationType.getElementType());
    }

    private void writeMapType(Type mapType) throws IOException {
        this.out.write(13);
        this.writeType(mapType.getKeyType());
        this.writeType(mapType.getValueType());
    }

    private void writeParameterType(Type parameterType) throws IOException {
        this.out.write(14);
        String name = parameterType.getName();
        byte[] nameData = name.getBytes();
        this.printInteger(nameData.length);
        this.out.write(nameData);
        this.writeType(parameterType.getBound());
    }

    private void writeADTType(Type adtType) throws IOException {
        this.out.write(15);
        String name = adtType.getName();
        byte[] nameData = name.getBytes();
        this.printInteger(nameData.length);
        this.out.write(nameData);
        this.writeType(adtType.getTypeParameters());
    }

    private void writeConstructorType(Type constructorType) throws IOException {
        Map<String, Type> declaredAnnotations = this.typeStore.getAnnotations(constructorType);
        if (declaredAnnotations.isEmpty()) {
            this.out.write(16);
            String name = constructorType.getName();
            byte[] nameData = name.getBytes();
            this.printInteger(nameData.length);
            this.out.write(nameData);
            this.writeType(constructorType.getFieldTypes());
            this.writeType(constructorType.getAbstractDataType());
        } else {
            this.out.write(19);
            String name = constructorType.getName();
            byte[] nameData = name.getBytes();
            this.printInteger(nameData.length);
            this.out.write(nameData);
            this.writeType(constructorType.getFieldTypes());
            this.writeType(constructorType.getAbstractDataType());
            int nrOfAnnotations = declaredAnnotations.size();
            this.printInteger(nrOfAnnotations);
            for (Map.Entry<String, Type> declaredAnnotation : declaredAnnotations.entrySet()) {
                String label = declaredAnnotation.getKey();
                byte[] labelBytes = label.getBytes();
                this.printInteger(labelBytes.length);
                this.out.write(labelBytes);
                this.writeType(declaredAnnotation.getValue());
            }
        }
    }

    private void writeAliasType(Type aliasType) throws IOException {
        this.out.write(17);
        String name = aliasType.getName();
        byte[] nameData = name.getBytes();
        this.printInteger(nameData.length);
        this.out.write(nameData);
        this.writeType(aliasType.getAliased());
        this.writeType(aliasType.getTypeParameters());
    }

    private void printInteger(int value) throws IOException {
        int intValue = value;
        if ((intValue & 0xFFFFFF80) == 0) {
            this.out.write((byte)(intValue & 0x7F));
            return;
        }
        this.out.write((byte)(intValue & 0x7F | 0x80));
        if ((intValue & 0xFFFFC000) == 0) {
            this.out.write((byte)(intValue >>> 7 & 0x7F));
            return;
        }
        this.out.write((byte)(intValue >>> 7 & 0x7F | 0x80));
        if ((intValue & 0xFFE00000) == 0) {
            this.out.write((byte)(intValue >>> 14 & 0x7F));
            return;
        }
        this.out.write((byte)(intValue >>> 14 & 0x7F | 0x80));
        if ((intValue & 0xF0000000) == 0) {
            this.out.write((byte)(intValue >>> 21 & 0x7F));
            return;
        }
        this.out.write((byte)(intValue >>> 21 & 0x7F | 0x80));
        this.out.write((byte)(intValue >>> 28 & 0x7F));
    }
}

