/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import java.net.URI;
import org.eclipse.imp.pdb.facts.IListWriter;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.type.ITypeVisitor;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ValueType
extends Type {
    public static ValueType getInstance() {
        return InstanceHolder.sInstance;
    }

    private ValueType() {
    }

    @Override
    public boolean isValueType() {
        return true;
    }

    @Override
    public boolean isSubtypeOf(Type other) {
        if (other == this) {
            return true;
        }
        if (other == TypeFactory.getInstance().voidType()) {
            return false;
        }
        if (other.isAliasType()) {
            return this.isSubtypeOf(other.getAliased());
        }
        if (other.isParameterType()) {
            return this.isSubtypeOf(other.getBound());
        }
        return false;
    }

    @Override
    public Type lub(Type other) {
        return this;
    }

    public String toString() {
        return "value";
    }

    public boolean equals(Object o) {
        return o instanceof ValueType;
    }

    public int hashCode() {
        return 2141;
    }

    @Override
    public <T> T accept(ITypeVisitor<T> visitor) {
        return visitor.visitValue(this);
    }

    @Override
    public IValue make(IValueFactory f) {
        return TypeFactory.getInstance().tupleEmpty().make(f);
    }

    @Override
    public IValue make(IValueFactory f, double arg) {
        return TypeFactory.getInstance().realType().make(f, arg);
    }

    @Override
    public IValue make(IValueFactory f, int arg) {
        return TypeFactory.getInstance().integerType().make(f, arg);
    }

    @Override
    public IValue make(IValueFactory f, TypeStore s, int arg) {
        return TypeFactory.getInstance().integerType().make(f, arg);
    }

    @Override
    public IValue make(IValueFactory f, URI uri, int startOffset, int length, int startLine, int endLine, int startCol, int endCol) {
        return TypeFactory.getInstance().sourceLocationType().make(f, uri, startOffset, length, startLine, endLine, startCol, endCol);
    }

    @Override
    public IValue make(IValueFactory f, String path, int startOffset, int length, int startLine, int endLine, int startCol, int endCol) {
        return TypeFactory.getInstance().sourceLocationType().make(f, path, startOffset, length, startLine, endLine, startCol, endCol);
    }

    @Override
    public IValue make(IValueFactory f, URI uri) {
        return f.sourceLocation(uri);
    }

    @Override
    public IValue make(IValueFactory f, IValue ... args) {
        return TypeFactory.getInstance().tupleType(args).make(f, args);
    }

    @Override
    public IValue make(IValueFactory f, String arg) {
        return TypeFactory.getInstance().stringType().make(f, arg);
    }

    @Override
    public IValue make(IValueFactory f, String name, IValue ... children) {
        return f.node(name, children);
    }

    @Override
    public IValue make(IValueFactory f, TypeStore store, String name, IValue ... children) {
        Type[] kids = new Type[children.length];
        int i = 0;
        while (i < kids.length) {
            kids[i] = children[i].getType();
            ++i;
        }
        Type cons = store.lookupFirstConstructor(name, TypeFactory.getInstance().tupleType(kids));
        if (cons == null) {
            return TypeFactory.getInstance().nodeType().make(f, name, children);
        }
        return cons.make(f, children);
    }

    @Override
    public IValue make(IValueFactory f, boolean arg) {
        return TypeFactory.getInstance().boolType().make(f, arg);
    }

    public IListWriter writer(IValueFactory f) {
        return f.listWriter(TypeFactory.getInstance().valueType());
    }

    /* synthetic */ ValueType(ValueType valueType) {
        this();
    }

    private static class InstanceHolder {
        public static final ValueType sInstance = new ValueType(null);

        private InstanceHolder() {
        }
    }
}

