/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexedSet<E> {
    private static final int INITIAL_LOG_SIZE = 4;
    private int modSize = 4;
    private int hashMask;
    private Entry<E>[] data;
    private int threshold;
    private int load;

    public IndexedSet() {
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = new Entry[tableSize];
        this.threshold = tableSize;
        this.load = 0;
    }

    private void rehash() {
        ++this.modSize;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        Entry[] newData = new Entry[tableSize];
        this.threshold = tableSize;
        Entry<E>[] oldData = this.data;
        int i = oldData.length - 1;
        while (i >= 0) {
            Entry<E> entry = oldData[i];
            if (entry != null) {
                Entry<E> lastUnchangedEntryChain = entry;
                int newLastUnchangedEntryChainIndex = entry.hash & this.hashMask;
                Entry e = entry.next;
                while (e != null) {
                    int newIndex = e.hash & this.hashMask;
                    if (newIndex != newLastUnchangedEntryChainIndex) {
                        lastUnchangedEntryChain = e;
                        newLastUnchangedEntryChainIndex = newIndex;
                    }
                    e = e.next;
                }
                newData[newLastUnchangedEntryChainIndex] = lastUnchangedEntryChain;
                while (entry != lastUnchangedEntryChain) {
                    int hash = entry.hash;
                    int position = hash & this.hashMask;
                    newData[position] = new Entry(hash, entry.key, entry.value, newData[position]);
                    entry = entry.next;
                }
            }
            --i;
        }
        this.data = newData;
    }

    private void ensureCapacity() {
        if (this.load > this.threshold) {
            this.rehash();
        }
    }

    public int store(E element) {
        int hash = element.hashCode();
        int position = hash & this.hashMask;
        Entry<E> entry = this.data[position];
        while (entry != null) {
            if (hash == entry.hash && element.equals(entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        this.ensureCapacity();
        position = hash & this.hashMask;
        this.data[position] = new Entry<E>(hash, element, this.load++, this.data[position]);
        return -1;
    }

    public int get(E element) {
        int hash = element.hashCode();
        int position = hash & this.hashMask;
        Entry<E> entry = this.data[position];
        while (entry != null) {
            if (hash == entry.hash && element.equals(entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<E> {
        public final int hash;
        public final E key;
        public final int value;
        public final Entry<E> next;

        public Entry(int hash, E key, int value, Entry<E> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

