/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareableList<E>
implements Iterable<E> {
    private static final int INITIAL_LOG_SIZE = 2;
    private int frontCapacity;
    private E[] frontData;
    private int frontIndex;
    private int backCapacity;
    private E[] backData;
    private int backIndex;

    public ShareableList() {
        this.frontCapacity = 4;
        this.frontData = new Object[this.frontCapacity];
        this.frontIndex = 0;
        this.backCapacity = 4;
        this.backData = new Object[this.backCapacity];
        this.backIndex = 0;
    }

    public ShareableList(ShareableList<E> shareableList) {
        this.frontCapacity = shareableList.frontCapacity;
        this.frontData = (Object[])shareableList.frontData.clone();
        this.frontIndex = shareableList.frontIndex;
        this.backCapacity = shareableList.backCapacity;
        this.backData = (Object[])shareableList.backData.clone();
        this.backIndex = shareableList.backIndex;
    }

    protected ShareableList(ShareableList<E> shareableList, int offset, int length) {
        int backStartIndex = shareableList.backIndex - offset;
        if (backStartIndex <= 0) {
            this.backIndex = 0;
            this.backCapacity = 2;
            this.backData = new Object[this.backCapacity];
            int frontStartIndex = -backStartIndex;
            this.frontIndex = length;
            this.frontCapacity = ShareableList.closestPowerOfTwo(length);
            this.frontData = new Object[this.frontCapacity];
            System.arraycopy(shareableList.frontData, frontStartIndex, this.frontData, 0, length);
        } else if (offset + length <= shareableList.backIndex) {
            this.backIndex = length;
            this.backCapacity = ShareableList.closestPowerOfTwo(length);
            this.backData = new Object[this.backCapacity];
            System.arraycopy(shareableList.backData, backStartIndex - length, this.backData, 0, length);
            this.frontIndex = 0;
            this.frontCapacity = 2;
            this.frontData = new Object[this.frontCapacity];
        } else {
            int frontLength;
            this.backIndex = backStartIndex;
            this.backCapacity = ShareableList.closestPowerOfTwo(backStartIndex);
            this.backData = new Object[this.backCapacity];
            System.arraycopy(shareableList.backData, 0, this.backData, 0, backStartIndex);
            this.frontIndex = frontLength = length - backStartIndex;
            this.frontCapacity = ShareableList.closestPowerOfTwo(frontLength);
            this.frontData = new Object[this.frontCapacity];
            System.arraycopy(shareableList.frontData, 0, this.frontData, 0, frontLength);
        }
    }

    private static int closestPowerOfTwo(int number) {
        int power = 0;
        while (1 << ++power < number) {
        }
        return 1 << power;
    }

    public void clear() {
        this.frontCapacity = 4;
        this.frontData = new Object[this.frontCapacity];
        this.frontIndex = 0;
        this.backCapacity = 4;
        this.backData = new Object[this.backCapacity];
        this.backIndex = 0;
    }

    private void ensureFrontCapacity() {
        if (this.frontCapacity == this.frontIndex) {
            this.frontCapacity <<= 1;
            Object[] newFrontData = new Object[this.frontCapacity];
            System.arraycopy(this.frontData, 0, newFrontData, 0, this.frontData.length);
            this.frontData = newFrontData;
        }
    }

    private void ensureBackCapacity() {
        if (this.backCapacity == this.backIndex) {
            this.backCapacity <<= 1;
            Object[] newBackData = new Object[this.backCapacity];
            System.arraycopy(this.backData, 0, newBackData, 0, this.backData.length);
            this.backData = newBackData;
        }
    }

    private void ensureFrontBulkCapacity(int nrOfElements) {
        int requiredCapacity = this.frontIndex + nrOfElements;
        if (this.frontCapacity <= requiredCapacity) {
            do {
                this.frontCapacity <<= 1;
            } while (this.frontCapacity <= requiredCapacity);
            Object[] newFrontData = new Object[this.frontCapacity];
            System.arraycopy(this.frontData, 0, newFrontData, 0, this.frontData.length);
            this.frontData = newFrontData;
        }
    }

    private void ensureBackBulkCapacity(int nrOfElements) {
        int requiredCapacity = this.backIndex + nrOfElements;
        if (this.backCapacity <= requiredCapacity) {
            do {
                this.backCapacity <<= 1;
            } while (this.backCapacity <= requiredCapacity);
            Object[] newBackData = new Object[this.backCapacity];
            System.arraycopy(this.backData, 0, newBackData, 0, this.backData.length);
            this.backData = newBackData;
        }
    }

    public void append(E element) {
        this.ensureFrontCapacity();
        this.frontData[this.frontIndex++] = element;
    }

    public void appendAll(E[] elements) {
        int nrOfElements = elements.length;
        this.ensureFrontBulkCapacity(nrOfElements);
        System.arraycopy(elements, 0, this.frontData, this.frontIndex, nrOfElements);
        this.frontIndex += nrOfElements;
    }

    public void appendAllAt(E[] elements, int offset, int length) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be > 0.");
        }
        if (offset + length > elements.length) {
            throw new IllegalArgumentException("(offset + length) must be <= elements.length.");
        }
        this.ensureFrontBulkCapacity(length);
        System.arraycopy(elements, offset, this.frontData, this.frontIndex, length);
        this.frontIndex += length;
    }

    public void insert(E element) {
        this.ensureBackCapacity();
        this.backData[this.backIndex++] = element;
    }

    public void insertAll(E[] elements) {
        int nrOfElements = elements.length;
        this.ensureBackBulkCapacity(nrOfElements);
        int i = nrOfElements - 1;
        while (i >= 0) {
            this.backData[this.backIndex++] = elements[i];
            --i;
        }
    }

    public void insertAt(int index, E element) {
        int realIndex = index - this.backIndex;
        if (realIndex >= 0) {
            this.ensureFrontCapacity();
            if (realIndex > this.frontIndex) {
                throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " > the the current size of the list (" + this.size() + ")");
            }
            int elementsToMove = this.frontIndex - realIndex;
            System.arraycopy(this.frontData, realIndex, this.frontData, realIndex + 1, elementsToMove);
            this.frontData[realIndex] = element;
            ++this.frontIndex;
        } else {
            this.ensureBackCapacity();
            realIndex = 0 - realIndex;
            if (realIndex > this.backIndex) {
                throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " < 0");
            }
            int elementsToMove = this.backIndex - realIndex;
            System.arraycopy(this.backData, realIndex, this.backData, realIndex + 1, elementsToMove);
            this.backData[realIndex] = element;
            ++this.backIndex;
        }
    }

    public E set(int index, E element) {
        int realIndex = index - this.backIndex;
        if (realIndex >= 0) {
            if (realIndex >= this.frontIndex) {
                throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= the the current size of the list (" + this.size() + ")");
            }
            E oldElement = this.frontData[realIndex];
            this.frontData[realIndex] = element;
            return oldElement;
        }
        if ((realIndex = -1 - realIndex) >= this.backIndex) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " < 0");
        }
        E oldElement = this.backData[realIndex];
        this.backData[realIndex] = element;
        return oldElement;
    }

    public E get(int index) {
        int realIndex = index - this.backIndex;
        if (realIndex >= 0) {
            if (realIndex >= this.frontIndex) {
                throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= the the current size of the list (" + this.size() + ")");
            }
            return this.frontData[realIndex];
        }
        if ((realIndex = -1 - realIndex) >= this.backIndex) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " < 0");
        }
        return this.backData[realIndex];
    }

    public E remove(int index) {
        int elementsToMove;
        int realIndex = index - this.backIndex;
        if (realIndex >= 0) {
            int elementsToMove2;
            if (realIndex >= this.frontIndex) {
                throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= the the current size of the list (" + this.size() + ")");
            }
            E oldElement = this.frontData[realIndex];
            if ((elementsToMove2 = --this.frontIndex - realIndex) > 0) {
                System.arraycopy(this.frontData, realIndex + 1, this.frontData, realIndex, elementsToMove2);
            }
            this.frontData[this.frontIndex] = null;
            return oldElement;
        }
        if ((realIndex = -1 - realIndex) >= this.backIndex) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " < 0");
        }
        E oldElement = this.backData[realIndex];
        if ((elementsToMove = --this.backIndex - realIndex) > 0) {
            System.arraycopy(this.backData, realIndex + 1, this.backData, realIndex, elementsToMove);
        }
        this.backData[this.backIndex] = null;
        return oldElement;
    }

    public ShareableList<E> subList(int offset, int length) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Offset may not be smaller then 0.");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length may not be smaller then 0.");
        }
        if (offset + length > this.size()) {
            throw new IndexOutOfBoundsException("'offset + length' may not be larger then 'list.size()'");
        }
        return new ShareableList<E>(this, offset, length);
    }

    public ShareableList<E> reverse() {
        int tempCapacity = this.frontCapacity;
        E[] tempData = this.frontData;
        int tempIndex = this.frontIndex;
        this.frontCapacity = this.backCapacity;
        this.frontData = this.backData;
        this.frontIndex = this.backIndex;
        this.backCapacity = tempCapacity;
        this.backData = tempData;
        this.backIndex = tempIndex;
        return this;
    }

    public int size() {
        return this.frontIndex + this.backIndex;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ListIterator(this);
    }

    public int hashCode() {
        int hash = 0;
        for (E element : this) {
            hash = hash << 1 ^ element.hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        ShareableList other;
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass() && (other = (ShareableList)o).size() == this.size()) {
            if (this.isEmpty()) {
                return true;
            }
            Iterator<E> thisIterator = this.iterator();
            Iterator<E> otherIterator = other.iterator();
            while (thisIterator.hasNext()) {
                if (thisIterator.next().equals(otherIterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        Iterator<E> iterator = this.iterator();
        if (iterator.hasNext()) {
            E element = iterator.next();
            buffer.append(element);
            while (iterator.hasNext()) {
                element = iterator.next();
                buffer.append(',');
                buffer.append(element);
            }
        }
        buffer.append(']');
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListIterator<E>
    implements Iterator<E> {
        private final ShareableList<E> shareableList;
        private int currentIndex;
        private boolean front;

        public ListIterator(ShareableList<E> shareableList) {
            this.shareableList = shareableList;
            this.currentIndex = ((ShareableList)shareableList).backIndex - 1;
            this.front = false;
            if (this.currentIndex < 0) {
                this.currentIndex = 0;
                this.front = true;
            }
        }

        @Override
        public boolean hasNext() {
            return this.front ? this.currentIndex < ((ShareableList)this.shareableList).frontIndex : this.currentIndex >= 0;
        }

        @Override
        public E next() {
            Object element;
            if (!this.hasNext()) {
                throw new NoSuchElementException("There are no more elements in this iteration.");
            }
            if (this.front) {
                element = ((ShareableList)this.shareableList).frontData[this.currentIndex++];
            } else {
                element = ((ShareableList)this.shareableList).backData[this.currentIndex--];
                if (this.currentIndex == -1) {
                    this.front = true;
                    this.currentIndex = 0;
                }
            }
            return (E)element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }
}

