/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl;

import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.impl.Value;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BoolValue
extends Value
implements IBool {
    private final boolean fValue;

    BoolValue(boolean b) {
        super(TypeFactory.getInstance().boolType());
        this.fValue = b;
    }

    @Override
    public boolean getValue() {
        return this.fValue;
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitBoolean(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getClass() == obj.getClass()) {
            return this.fValue == ((BoolValue)obj).fValue;
        }
        return false;
    }

    @Override
    public IBool and(IBool other) {
        return new BoolValue(this.fValue && other.getValue());
    }

    @Override
    public IBool or(IBool other) {
        return new BoolValue(this.fValue || other.getValue());
    }

    @Override
    public IBool not() {
        return new BoolValue(!this.fValue);
    }

    @Override
    public IBool implies(IBool other) {
        return new BoolValue(this.fValue ? other.getValue() : true);
    }

    @Override
    public IBool equivalent(IBool other) {
        return new BoolValue(this.fValue == other.getValue());
    }

    @Override
    public IBool xor(IBool other) {
        return new BoolValue(this.fValue ^ other.getValue());
    }

    public int hashCode() {
        return this.fValue ? 1231 : 1237;
    }

    @Override
    public String getStringRepresentation() {
        return this.fValue ? "true" : "false";
    }
}

