/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.Relation;
import org.eclipse.imp.pdb.facts.impl.fast.Set;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesHashSet;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetWriter
implements ISetWriter {
    protected Type elementType;
    protected final boolean inferred;
    protected final ShareableValuesHashSet data;
    protected ISet constructedSet;

    protected SetWriter(Type elementType) {
        this.elementType = elementType;
        this.inferred = false;
        this.data = new ShareableValuesHashSet();
        this.constructedSet = null;
    }

    protected SetWriter() {
        this.elementType = TypeFactory.getInstance().voidType();
        this.inferred = true;
        this.data = new ShareableValuesHashSet();
        this.constructedSet = null;
    }

    protected SetWriter(Type elementType, ShareableValuesHashSet data) {
        this.elementType = elementType;
        this.inferred = false;
        this.data = data;
        this.constructedSet = null;
    }

    public void insert(IValue value) {
        this.checkMutation();
        this.updateType(value);
        this.data.add(value);
    }

    private void updateType(IValue value) {
        if (this.inferred) {
            this.elementType = this.elementType.lub(value.getType());
        }
    }

    @Override
    public void insert(IValue ... elements) {
        this.checkMutation();
        for (int i = elements.length - 1; i >= 0; --i) {
            this.updateType(elements[i]);
            this.data.add(elements[i]);
        }
    }

    @Override
    public void insertAll(Iterable<IValue> collection) {
        this.checkMutation();
        for (IValue next : collection) {
            this.updateType(next);
            this.data.add(next);
        }
    }

    @Override
    public void delete(IValue element) {
        this.checkMutation();
        this.data.remove(element);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    protected void checkMutation() {
        if (this.constructedSet != null) {
            throw new UnsupportedOperationException("Mutation of a finalized map is not supported.");
        }
    }

    @Override
    public ISet done() {
        if (this.constructedSet == null) {
            this.constructedSet = this.inferred && this.elementType.isTupleType() ? new Relation(this.elementType, this.data) : new Set(this.elementType, this.data);
        }
        return this.constructedSet;
    }
}

