/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.Constructor;
import org.eclipse.imp.pdb.facts.type.Type;

public abstract class AnnotatedConstructorBase
extends Constructor {
    protected AnnotatedConstructorBase(Type constructorType, IValue[] children) {
        super(constructorType, children);
    }

    public boolean hasAnnotations() {
        return true;
    }

    public IConstructor removeAnnotations() {
        return new Constructor(this.constructorType, this.children);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            AnnotatedConstructorBase other = (AnnotatedConstructorBase)o;
            if (this.constructorType != other.constructorType) {
                return false;
            }
            IValue[] otherChildren = other.children;
            int nrOfChildren = this.children.length;
            if (otherChildren.length == nrOfChildren) {
                int i = nrOfChildren - 1;
                while (i >= 0) {
                    if (!otherChildren[i].equals(this.children[i])) {
                        return false;
                    }
                    --i;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("(");
        int size = this.children.length;
        if (size > 0) {
            int i = 0;
            sb.append(this.children[i]);
            i = 1;
            while (i < size) {
                sb.append(",");
                sb.append(this.children[i]);
                ++i;
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

