/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.reference;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IListWriter;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedElementTypeException;
import org.eclipse.imp.pdb.facts.impl.Value;
import org.eclipse.imp.pdb.facts.impl.Writer;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class List
extends Value
implements IList {
    private final Type eltType;
    private final LinkedList<IValue> content;
    private int fHash = 0;

    public List(Type eltType, LinkedList<IValue> listContent) {
        super(TypeFactory.getInstance().listType(eltType));
        this.eltType = eltType;
        this.content = listContent;
    }

    @Override
    public Type getElementType() {
        return this.eltType;
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.content.iterator();
    }

    @Override
    public int length() {
        return this.content.size();
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public IValue get(int i) {
        return this.content.get(i);
    }

    @Override
    public IList sublist(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.content.size()) {
            throw new IndexOutOfBoundsException();
        }
        ListWriter w = new ListWriter(this.getElementType());
        int i = offset;
        while (i < offset + length) {
            w.append(this.content.get(i));
            ++i;
        }
        return w.done();
    }

    @Override
    public IList put(int i, IValue elem) throws IndexOutOfBoundsException {
        ListWriter w = new ListWriter(elem.getType().lub(this.getElementType()));
        w.appendAll(this);
        w.replaceAt(i, elem);
        return w.done();
    }

    @Override
    public IList insert(IValue elem) {
        ListWriter w = new ListWriter(elem.getType().lub(this.getElementType()));
        w.appendAll(this);
        w.insert(elem);
        return w.done();
    }

    @Override
    public IList append(IValue elem) {
        ListWriter w = new ListWriter(elem.getType().lub(this.getElementType()));
        w.appendAll(this);
        w.append(elem);
        return w.done();
    }

    @Override
    public boolean contains(IValue e) {
        return this.content.contains(e);
    }

    @Override
    public IList delete(IValue e) {
        ListWriter w = new ListWriter(this.getElementType());
        w.appendAll(this);
        w.delete(e);
        return w.done();
    }

    @Override
    public IList delete(int i) {
        ListWriter w = new ListWriter(this.getElementType());
        w.appendAll(this);
        w.delete(i);
        return w.done();
    }

    @Override
    public IList reverse() {
        ListWriter w = new ListWriter(this.getElementType());
        for (IValue e : this) {
            w.insert(e);
        }
        return w.done();
    }

    @Override
    public IList concat(IList other) {
        ListWriter w = new ListWriter(this.getElementType().lub(other.getElementType()));
        w.appendAll(this);
        w.appendAll(other);
        return w.done();
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitList(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() == o.getClass()) {
            List other = (List)o;
            return this.fType.comparable(other.fType) && this.content.equals(other.content);
        }
        return false;
    }

    public int hashCode() {
        if (this.fHash == 0) {
            this.fHash = this.content.hashCode();
        }
        return this.fHash;
    }

    static ListWriter createListWriter(Type eltType) {
        return new ListWriter(eltType);
    }

    static ListWriter createListWriter() {
        return new ListWriter();
    }

    private static void checkInsert(IValue elem, Type eltType) throws FactTypeUseException {
        Type type = elem.getType();
        if (!type.isSubtypeOf(eltType)) {
            throw new UnexpectedElementTypeException(eltType, type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListWriter
    extends Writer
    implements IListWriter {
        private Type eltType;
        private final LinkedList<IValue> listContent;
        private List constructedList;
        private final boolean inferred;

        public ListWriter(Type eltType) {
            this.eltType = eltType;
            this.inferred = false;
            this.listContent = new LinkedList();
            this.constructedList = null;
        }

        public ListWriter() {
            this.eltType = TypeFactory.getInstance().voidType();
            this.inferred = true;
            this.listContent = new LinkedList();
            this.constructedList = null;
        }

        private void checkMutation() {
            if (this.constructedList != null) {
                throw new UnsupportedOperationException("Mutation of a finalized list is not supported.");
            }
        }

        private void put(int index, IValue elem) {
            if (this.inferred) {
                this.eltType = this.eltType.lub(elem.getType());
            } else {
                List.checkInsert(elem, this.eltType);
            }
            this.listContent.add(index, elem);
        }

        public void insert(IValue elem) throws FactTypeUseException {
            this.checkMutation();
            this.put(0, elem);
        }

        @Override
        public void insert(IValue[] elems, int start, int length) throws FactTypeUseException {
            this.checkMutation();
            this.checkBounds(elems, start, length);
            int i = start + length - 1;
            while (i >= start) {
                this.updateType(elems[i]);
                this.put(0, elems[i]);
                --i;
            }
        }

        @Override
        public void replaceAt(int index, IValue elem) throws FactTypeUseException, IndexOutOfBoundsException {
            this.checkMutation();
            this.updateType(elem);
            List.checkInsert(elem, this.eltType);
            this.listContent.set(index, elem);
        }

        @Override
        public void insert(IValue ... elems) throws FactTypeUseException {
            this.insert(elems, 0, elems.length);
        }

        @Override
        public void insertAt(int index, IValue[] elems, int start, int length) throws FactTypeUseException {
            this.checkMutation();
            this.checkBounds(elems, start, length);
            int i = start + length - 1;
            while (i >= start) {
                if (this.inferred) {
                    this.eltType = this.eltType.lub(elems[i].getType());
                }
                this.put(index, elems[i]);
                --i;
            }
        }

        @Override
        public void insertAt(int index, IValue ... elems) throws FactTypeUseException {
            this.insertAt(index, elems, 0, 0);
        }

        public void append(IValue elem) throws FactTypeUseException {
            this.checkMutation();
            this.updateType(elem);
            this.put(this.listContent.size(), elem);
        }

        @Override
        public void append(IValue ... elems) throws FactTypeUseException {
            this.checkMutation();
            IValue[] iValueArray = elems;
            int n = elems.length;
            int n2 = 0;
            while (n2 < n) {
                IValue elem = iValueArray[n2];
                this.updateType(elem);
                this.put(this.listContent.size(), elem);
                ++n2;
            }
        }

        @Override
        public void appendAll(Iterable<? extends IValue> collection) throws FactTypeUseException {
            this.checkMutation();
            for (IValue iValue : collection) {
                this.updateType(iValue);
                this.put(this.listContent.size(), iValue);
            }
        }

        private void updateType(IValue v) {
            if (this.inferred) {
                this.eltType = this.eltType.lub(v.getType());
            }
        }

        @Override
        public IList done() {
            if (this.constructedList == null) {
                this.constructedList = new List(this.eltType, this.listContent);
            }
            return this.constructedList;
        }

        private void checkBounds(IValue[] elems, int start, int length) {
            if (start < 0) {
                throw new ArrayIndexOutOfBoundsException("start < 0");
            }
            if (start + length > elems.length) {
                throw new ArrayIndexOutOfBoundsException("(start + length) > elems.length");
            }
        }

        @Override
        public void delete(IValue elem) {
            this.checkMutation();
            this.listContent.remove(elem);
        }

        @Override
        public void delete(int i) {
            this.checkMutation();
            this.listContent.remove(i);
        }
    }
}

