/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.util.sharing;

import java.lang.ref.WeakReference;
import org.eclipse.imp.pdb.facts.impl.util.sharing.IShareable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShareableValuesFactory<E extends IShareable> {
    private static final int DEFAULT_LOG_NR_OF_SEGMENTS = 5;
    private final int logNrOfSegments;
    private final Segment<E>[] segments;

    public ShareableValuesFactory() {
        this.logNrOfSegments = 5;
        this.segments = new Segment[1 << this.logNrOfSegments];
        int i = this.segments.length - 1;
        while (i >= 0) {
            this.segments[i] = new Segment(this.logNrOfSegments);
            --i;
        }
    }

    public ShareableValuesFactory(int logNrOfSegments) {
        if (32 - logNrOfSegments <= 5) {
            throw new IllegalArgumentException("logNrOfSegments can not be larger then (32 - 5).");
        }
        this.logNrOfSegments = logNrOfSegments;
        this.segments = new Segment[1 << logNrOfSegments];
        int i = this.segments.length - 1;
        while (i >= 0) {
            this.segments[i] = new Segment(logNrOfSegments);
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        int nrOfSegments = this.segments.length;
        int i = 0;
        while (i < nrOfSegments) {
            Segment<E> segment;
            Segment<E> segment2 = segment = this.segments[i];
            synchronized (segment2) {
                ((Segment)segment).cleanup();
            }
            ++i;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int nrOfSegments = this.segments.length;
        int i = 0;
        while (i < nrOfSegments) {
            Segment<E> segment = this.segments[i];
            int maxSegmentBitSize = ((Segment)segment).maxSegmentBitSize;
            int startHash = i << maxSegmentBitSize;
            int endHash = (i + 1 << maxSegmentBitSize) - 1;
            sb.append("Segment hash range: ");
            sb.append(startHash);
            sb.append(" till ");
            sb.append(endHash);
            sb.append(" | ");
            sb.append(segment.toString());
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public E build(E shareable) {
        int hash = shareable.hashCode();
        int segmentNr = hash >>> 27;
        return this.segments[segmentNr].get(shareable, hash);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Segment<E extends IShareable> {
        private static final int DEFAULT_LOG_SEGMENT_SIZE = 5;
        private static final float DEFAULT_LOAD_FACTOR = 2.0f;
        private final int maxSegmentBitSize;
        private volatile Entry<E>[] entries;
        private volatile int hashMask;
        private int bitSize;
        private int threshold;
        private int load;
        private volatile boolean flaggedForCleanup;
        private volatile WeakReference<GarbageCollectionDetector<E>> garbageCollectionDetector;
        private int cleanupScaler;
        private int cleanupThreshold;

        public Segment(int logNrOfSegments) {
            this.maxSegmentBitSize = 32 - logNrOfSegments;
            this.bitSize = 5;
            int nrOfEntries = 1 << this.bitSize;
            this.hashMask = nrOfEntries - 1;
            this.entries = new Entry[nrOfEntries];
            this.threshold = (int)((float)nrOfEntries * 2.0f);
            this.load = 0;
            this.flaggedForCleanup = false;
            this.garbageCollectionDetector = new WeakReference(new GarbageCollectionDetector(this));
            this.cleanupThreshold = this.cleanupScaler = 50;
        }

        private void cleanup() {
            Entry<E>[] table = this.entries;
            int newLoad = this.load;
            int i = this.hashMask;
            while (i >= 0) {
                Entry<E> e = table[i];
                if (e != null) {
                    Entry next;
                    Entry<E> previous = null;
                    do {
                        next = e.next;
                        if (e.get() == null) {
                            if (previous == null) {
                                table[i] = next;
                            } else {
                                previous.next = next;
                            }
                            --newLoad;
                            continue;
                        }
                        previous = e;
                    } while ((e = next) != null);
                }
                --i;
            }
            this.load = newLoad;
            this.entries = table;
        }

        private void rehash() {
            int nrOfEntries = 1 << ++this.bitSize;
            int newHashMask = nrOfEntries - 1;
            Entry<E>[] oldEntries = this.entries;
            Entry[] newEntries = new Entry[nrOfEntries];
            Entry<Object> currentEntryRoot = new Entry<Object>(null, 0);
            Entry<Object> shiftedEntryRoot = new Entry<Object>(null, 0);
            int newLoad = this.load;
            int oldSize = oldEntries.length;
            int i = oldSize - 1;
            while (i >= 0) {
                Entry<E> e = oldEntries[i];
                if (e != null) {
                    Entry<Object> lastCurrentEntry = currentEntryRoot;
                    Entry<Object> lastShiftedEntry = shiftedEntryRoot;
                    do {
                        if (e.get() != null) {
                            int position = e.hash & newHashMask;
                            if (position == i) {
                                lastCurrentEntry.next = e;
                                lastCurrentEntry = e;
                                continue;
                            }
                            lastShiftedEntry.next = e;
                            lastShiftedEntry = e;
                            continue;
                        }
                        --newLoad;
                    } while ((e = e.next) != null);
                    lastCurrentEntry.next = null;
                    lastShiftedEntry.next = null;
                    newEntries[i] = currentEntryRoot.next;
                    newEntries[i | oldSize] = shiftedEntryRoot.next;
                }
                --i;
            }
            this.load = newLoad;
            this.threshold <<= 1;
            this.entries = newEntries;
            this.hashMask = newHashMask;
        }

        private void ensureCapacity() {
            if (this.load > this.threshold && this.bitSize < this.maxSegmentBitSize) {
                this.rehash();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryCleanup() {
            if (this.flaggedForCleanup) {
                this.flaggedForCleanup = false;
                Segment segment = this;
                synchronized (segment) {
                    if (this.garbageCollectionDetector == null) {
                        if (this.cleanupThreshold > 8) {
                            int oldLoad = this.load;
                            this.cleanup();
                            int cleanupPercentate = oldLoad == 0 ? 50 : 100 - this.load * 100 / oldLoad;
                            this.cleanupScaler = this.cleanupScaler * 25 + cleanupPercentate * 7 >> 5;
                            this.cleanupThreshold = this.cleanupScaler > 0 ? this.cleanupScaler : 1;
                        } else {
                            this.cleanupThreshold <<= 1;
                        }
                        this.garbageCollectionDetector = new WeakReference(new GarbageCollectionDetector(this));
                    }
                }
            }
        }

        private void put(E shareable, int hash) {
            Entry<E> e = new Entry<E>(shareable, hash);
            Entry<E>[] table = this.entries;
            int position = hash & this.hashMask;
            e.next = table[position];
            table[position] = e;
            ++this.load;
            table = this.entries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final E get(E shareable, int hash) {
            this.tryCleanup();
            int position = hash & this.hashMask;
            Entry<E> e = this.entries[position];
            if (e != null) {
                do {
                    IShareable object;
                    if (hash != e.hash || (object = (IShareable)e.get()) == null || !shareable.equivalent(object)) continue;
                    return (E)object;
                } while ((e = e.next) != null);
            }
            Segment segment = this;
            synchronized (segment) {
                position = hash & this.hashMask;
                e = this.entries[position];
                if (e != null) {
                    do {
                        IShareable object;
                        if (hash != e.hash || (object = (IShareable)e.get()) == null || !shareable.equivalent(object)) continue;
                        return (E)object;
                    } while ((e = e.next) != null);
                }
                this.ensureCapacity();
                E result = shareable;
                this.put(result, hash);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Segment segment = this;
            synchronized (segment) {
                Entry<E>[] table = this.entries;
                int tableSize = table.length;
                sb.append("Table size: ");
                sb.append(tableSize);
                sb.append(", ");
                sb.append("Number of entries: ");
                sb.append(this.load);
                sb.append(", ");
                sb.append("Threshold: ");
                sb.append(this.threshold);
                sb.append(", ");
                int nrOfFilledBuckets = 0;
                int totalNrOfCollisions = 0;
                int maxBucketLength = 0;
                int i = 0;
                while (i < tableSize) {
                    Entry<E> e = table[i];
                    if (e != null) {
                        ++nrOfFilledBuckets;
                        int bucketLength = 1;
                        while ((e = e.next) != null) {
                            ++bucketLength;
                        }
                        if (bucketLength > maxBucketLength) {
                            maxBucketLength = bucketLength;
                        }
                        totalNrOfCollisions += bucketLength - 1;
                    }
                    ++i;
                }
                double averageBucketLength = 0.0;
                double distribution = 100.0;
                if (nrOfFilledBuckets != 0) {
                    averageBucketLength = (double)(totalNrOfCollisions * 1000 / nrOfFilledBuckets) / 1000.0 + 1.0;
                    distribution = 100.0 - (double)((float)(totalNrOfCollisions * 1000 / nrOfFilledBuckets) / 2.0f) / 10.0;
                }
                sb.append("Number of filled buckets: ");
                sb.append(nrOfFilledBuckets);
                sb.append(", ");
                sb.append("Load factor: ");
                sb.append(2.0f);
                sb.append(", ");
                sb.append("Distribution (collisions vs filled buckets): ");
                sb.append(distribution);
                sb.append("%, ");
                sb.append("Total number of collisions: ");
                sb.append(totalNrOfCollisions);
                sb.append(", ");
                sb.append("Average (filled) bucket length: ");
                sb.append(averageBucketLength);
                sb.append(", ");
                sb.append("Maximal bucket length: ");
                sb.append(maxBucketLength);
                sb.append(", ");
                sb.append("Cleanup scaler: ");
                sb.append(this.cleanupScaler);
                sb.append("%");
            }
            return sb.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Entry<E extends IShareable>
        extends WeakReference<E> {
            public final int hash;
            public Entry<E> next;

            public Entry(E shareable, int hash) {
                super(shareable);
                this.hash = hash;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class GarbageCollectionDetector<E extends IShareable> {
            private final Segment<E> segment;

            public GarbageCollectionDetector(Segment<E> segment) {
                this.segment = segment;
            }

            public void finalize() {
                ((Segment)this.segment).garbageCollectionDetector = null;
                ((Segment)this.segment).flaggedForCleanup = true;
            }
        }
    }
}

