/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.imp.pdb.facts.IListWriter;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactParseError;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.UnsupportedTypeException;
import org.eclipse.imp.pdb.facts.io.AbstractReader;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeStore;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLReader
extends AbstractReader {
    private DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
    private IValueFactory vf;
    private TypeStore ts;

    public IValue read(IValueFactory factory, TypeStore store, Type type, InputStream stream) throws FactTypeUseException, IOException {
        this.vf = factory;
        this.ts = store;
        try {
            Document doc = this.domFactory.newDocumentBuilder().parse(stream);
            return this.parse(doc.getDocumentElement(), type);
        }
        catch (SAXException se) {
            throw new IOException("Parsing of value failed because XML was invalid: " + se.getMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new IOException("Parsing of value failed because XML configuration is wrong: " + pce.getMessage());
        }
        catch (DOMException de) {
            throw new IOException("Parsing of value failed because of a XML document failure: " + de.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new FactParseError("Expected a number, got something different", nfe);
        }
    }

    private IValue parse(Node node, Type expected) {
        if (expected.isAbstractDataType()) {
            Type sort = expected;
            String name = node.getNodeName();
            if (this.isListWrapper(name, sort)) {
                return this.parseList(node, sort);
            }
            if (this.isSetWrapper(name, sort)) {
                return this.parseSet(node, sort);
            }
            if (this.isRelationWrapper(name, sort)) {
                return this.parseRelation(node, sort);
            }
            if (this.isMapWrapper(name, sort)) {
                return this.parseMap(node, sort);
            }
            return this.parseTreeSort(node, sort);
        }
        if (expected.isStringType()) {
            return this.parseString(node);
        }
        if (expected.isIntegerType()) {
            return this.parseInt(node);
        }
        if (expected.isRealType()) {
            return this.parseDouble(node);
        }
        if (expected.isExternalType()) {
            return this.parseString(node);
        }
        throw new UnsupportedTypeException("Outermost or nested tuples, lists, sets, relations or maps are not allowed.", expected);
    }

    private boolean isListWrapper(String name, Type expected) {
        Set<Type> nodeTypes = this.ts.lookupConstructor(expected, name);
        if (nodeTypes.size() > 0) {
            Type nodeType = nodeTypes.iterator().next();
            return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isListType();
        }
        return false;
    }

    private boolean isSetWrapper(String name, Type expected) {
        Set<Type> nodeTypes = this.ts.lookupConstructor(expected, name);
        if (nodeTypes.size() > 0) {
            Type nodeType = nodeTypes.iterator().next();
            return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isSetType();
        }
        return false;
    }

    private boolean isRelationWrapper(String name, Type expected) {
        Set<Type> nodeTypes = this.ts.lookupConstructor(expected, name);
        if (nodeTypes.size() > 0) {
            Type nodeType = nodeTypes.iterator().next();
            return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isRelationType();
        }
        return false;
    }

    private boolean isMapWrapper(String name, Type expected) {
        Set<Type> nodeTypes = this.ts.lookupConstructor(expected, name);
        if (nodeTypes.size() > 0) {
            Type nodeType = nodeTypes.iterator().next();
            return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isMapType();
        }
        return false;
    }

    private IValue parseDouble(Node node) {
        return this.vf.real(Double.parseDouble(node.getNodeValue().trim()));
    }

    private IValue parseInt(Node node) {
        return this.vf.integer(Integer.parseInt(node.getNodeValue().trim()));
    }

    private IValue parseString(Node node) {
        return this.vf.string(node.getNodeValue());
    }

    private IValue parseMap(Node node, Type expected) {
        Set<Type> nodeTypes = this.ts.lookupConstructor(expected, node.getNodeName());
        Type nodeType = nodeTypes.iterator().next();
        Type mapType = nodeType.getFieldType(0);
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        NodeList children = node.getChildNodes();
        IMapWriter writer = (IMapWriter)mapType.writer(this.vf);
        int i = 0;
        while (i + 1 < children.getLength()) {
            IValue value;
            IValue key;
            int j;
            IValue[] elements;
            Type tuple;
            if (keyType.isTupleType()) {
                tuple = keyType;
                elements = new IValue[tuple.getArity()];
                j = 0;
                while (j < tuple.getArity()) {
                    elements[i] = this.parse(children.item(i++), tuple.getFieldType(j));
                    ++j;
                }
                key = this.vf.tuple(elements);
            } else {
                key = this.parse(children.item(i++), keyType);
            }
            if (valueType.isTupleType()) {
                tuple = keyType;
                elements = new IValue[tuple.getArity()];
                j = 0;
                while (j < tuple.getArity()) {
                    elements[i] = this.parse(children.item(i++), tuple.getFieldType(j));
                    ++j;
                }
                value = this.vf.tuple(elements);
            } else {
                value = this.parse(children.item(i++), valueType);
            }
            writer.put(key, value);
        }
        return this.vf.constructor(nodeType, writer.done());
    }

    private IValue parseRelation(Node node, Type expected) {
        Set<Type> nodeTypes = this.ts.lookupConstructor(expected, node.getNodeName());
        Type nodeType = nodeTypes.iterator().next();
        Type relType = nodeType.getFieldType(0);
        Type fields = relType.getFieldTypes();
        NodeList children = node.getChildNodes();
        ISetWriter writer = (ISetWriter)relType.writer(this.vf);
        int i = 0;
        while (i < children.getLength()) {
            IValue[] elements = new IValue[fields.getArity()];
            int j = 0;
            while (i < children.getLength() && j < fields.getArity()) {
                elements[j] = this.parse(children.item(i++), fields.getFieldType(j));
                ++j;
            }
            writer.insert(this.vf.tuple(elements));
        }
        return this.vf.constructor(nodeType, writer.done());
    }

    private IValue parseSet(Node node, Type expected) {
        Set<Type> nodeTypes = this.ts.lookupConstructor(expected, node.getNodeName());
        Type nodeType = nodeTypes.iterator().next();
        Type setType = nodeType.getFieldType(0);
        Type elementType = setType.getElementType();
        NodeList children = node.getChildNodes();
        ISetWriter writer = (ISetWriter)setType.writer(this.vf);
        if (!elementType.isTupleType()) {
            int i = 0;
            while (i < children.getLength()) {
                writer.insert(this.parse(children.item(i), elementType));
                ++i;
            }
        } else {
            Type tuple = elementType;
            int i = 0;
            while (i < children.getLength()) {
                IValue[] elements = new IValue[tuple.getArity()];
                int j = 0;
                while (i < children.getLength() && j < tuple.getArity()) {
                    elements[j] = this.parse(children.item(i++), tuple.getFieldType(j));
                    ++j;
                }
                writer.insert(this.vf.tuple(elements));
            }
        }
        return this.vf.constructor(nodeType, writer.done());
    }

    private IValue parseList(Node node, Type expected) {
        Set<Type> nodeTypes = this.ts.lookupConstructor(expected, node.getNodeName());
        Type nodeType = nodeTypes.iterator().next();
        Type listType = nodeType.getFieldType(0);
        Type elementType = listType.getElementType();
        NodeList children = node.getChildNodes();
        IListWriter writer = (IListWriter)listType.writer(this.vf);
        if (!elementType.isTupleType()) {
            int i = 0;
            while (i < children.getLength()) {
                writer.append(this.parse(children.item(i), elementType));
                ++i;
            }
        } else {
            Type tuple = elementType;
            int i = 0;
            while (i < children.getLength()) {
                IValue[] elements = new IValue[tuple.getArity()];
                int j = 0;
                while (i < children.getLength() && j < tuple.getArity()) {
                    elements[j] = this.parse(children.item(i++), tuple.getFieldType(j));
                    ++j;
                }
                writer.append(this.vf.tuple(elements));
            }
        }
        return this.vf.constructor(nodeType, writer.done());
    }

    private IValue parseTreeSort(Node node, Type expected) {
        Type nodeType = this.ts.lookupConstructor(expected, node.getNodeName()).iterator().next();
        Type childrenTypes = nodeType.getFieldTypes();
        NodeList children = node.getChildNodes();
        IValue[] values = new IValue[nodeType.getArity()];
        int sourceIndex = 0;
        int targetIndex = 0;
        while (sourceIndex < children.getLength() && targetIndex < nodeType.getArity()) {
            Type childType = childrenTypes.getFieldType(targetIndex);
            if (childType.isTupleType()) {
                Type tuple = childType;
                IValue[] elements = new IValue[tuple.getArity()];
                int tupleIndex = 0;
                while (tupleIndex < tuple.getArity() && sourceIndex < children.getLength()) {
                    elements[tupleIndex] = this.parse(children.item(sourceIndex), tuple.getFieldType(tupleIndex));
                    ++tupleIndex;
                    ++sourceIndex;
                }
                values[targetIndex++] = this.vf.tuple(elements);
                continue;
            }
            values[targetIndex++] = this.parse(children.item(sourceIndex++), childType);
        }
        return this.vf.constructor(nodeType, values);
    }
}

