/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.IllegalOperationException;
import org.eclipse.imp.pdb.facts.exceptions.UndeclaredFieldException;
import org.eclipse.imp.pdb.facts.type.ITypeVisitor;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TupleType
extends Type {
    private final Type[] fFieldTypes;
    private final String[] fFieldNames;
    private int fHashcode = -1;

    TupleType(Type[] fieldTypes) {
        this.fFieldTypes = fieldTypes;
        this.fFieldNames = null;
    }

    TupleType(Type[] fieldTypes, String[] fieldNames) {
        this.fFieldTypes = fieldTypes;
        this.fFieldNames = fieldNames.length != 0 ? fieldNames : null;
    }

    @Override
    public boolean hasFieldNames() {
        return this.fFieldNames != null;
    }

    @Override
    public boolean isTupleType() {
        return true;
    }

    @Override
    public Type getFieldType(int i) {
        return this.fFieldTypes[i];
    }

    @Override
    public Type getFieldType(String fieldName) {
        return this.getFieldType(this.getFieldIndex(fieldName));
    }

    @Override
    public int getFieldIndex(String fieldName) throws FactTypeUseException {
        if (this.fFieldNames != null) {
            int i = this.fFieldNames.length - 1;
            while (i >= 0) {
                if (this.fFieldNames[i].equals(fieldName)) {
                    return i;
                }
                --i;
            }
        }
        throw new UndeclaredFieldException(this, fieldName);
    }

    @Override
    public boolean hasField(String fieldName) {
        try {
            return this.getFieldIndex(fieldName) != -1;
        }
        catch (FactTypeUseException factTypeUseException) {
            return false;
        }
    }

    @Override
    public int getArity() {
        return this.fFieldTypes.length;
    }

    @Override
    public Type compose(Type other) {
        String fieldNameRight;
        String fieldNameLeft;
        if (other.isVoidType()) {
            return other;
        }
        if (this.getArity() != 2 || other.getArity() != 2) {
            throw new IllegalOperationException("compose", this, other);
        }
        if (!this.getFieldType(1).comparable(other.getFieldType(0))) {
            throw new IllegalOperationException("compose", this, other);
        }
        TypeFactory tf = TypeFactory.getInstance();
        if (this.hasFieldNames() && other.hasFieldNames() && !(fieldNameLeft = this.getFieldName(0)).equals(fieldNameRight = other.getFieldName(1))) {
            return tf.tupleType(this.getFieldType(0), fieldNameLeft, other.getFieldType(1), fieldNameRight);
        }
        return tf.tupleType(this.getFieldType(0), other.getFieldType(1));
    }

    @Override
    public Type carrier() {
        Type lub = TypeFactory.getInstance().voidType();
        for (Type field : this) {
            lub = lub.lub(field);
        }
        return TypeFactory.getInstance().setType(lub);
    }

    @Override
    public boolean isSubtypeOf(Type o) {
        if (o == this) {
            return true;
        }
        if (o.isTupleType() && this.getArity() == o.getArity()) {
            int i = this.getArity() - 1;
            while (i >= 0) {
                if (!this.getFieldType(i).isSubtypeOf(o.getFieldType(i))) {
                    return false;
                }
                --i;
            }
            return true;
        }
        return super.isSubtypeOf(o);
    }

    private Type lubTupleTypes(Type t1, Type t2) {
        int N = t1.getArity();
        Type[] fieldTypes = new Type[N];
        String[] fieldNames = new String[N];
        int i = 0;
        while (i < N) {
            fieldTypes[i] = t1.getFieldType(i).lub(t2.getFieldType(i));
            if (t1.hasFieldNames()) {
                fieldNames[i] = t1.getFieldName(i);
            } else if (t1.hasFieldNames()) {
                fieldNames[i] = t2.getFieldName(i);
            }
            ++i;
        }
        return TypeFactory.getInstance().tupleType(fieldTypes);
    }

    private Type lubNamedTupleTypes(Type t1, Type t2) {
        int N = t1.getArity();
        Object[] fieldTypes = new Object[N * 2];
        Type[] types = new Type[N];
        boolean first = t1.hasFieldNames();
        boolean second = t2.hasFieldNames();
        boolean consistent = true;
        int i = 0;
        int j = 0;
        while (i < N) {
            Type lub;
            types[i] = lub = t1.getFieldType(i).lub(t2.getFieldType(i));
            fieldTypes[j++] = lub;
            if (first && second) {
                String fieldName2;
                String fieldName1 = t1.getFieldName(i);
                if (fieldName1.equals(fieldName2 = t2.getFieldName(i))) {
                    fieldTypes[j] = fieldName1;
                } else {
                    consistent = false;
                }
            } else if (first) {
                fieldTypes[j] = t1.getFieldName(i);
            } else if (second) {
                fieldTypes[i] = t2.getFieldName(i);
            }
            ++i;
            ++j;
        }
        if (consistent && first && second) {
            return TypeFactory.getInstance().tupleType(fieldTypes);
        }
        return TypeFactory.getInstance().tupleType(types);
    }

    @Override
    public Type lub(Type o) {
        if (o.isTupleType() && this.getArity() == o.getArity()) {
            if (this.hasFieldNames() || o.hasFieldNames()) {
                return this.lubNamedTupleTypes(this, o);
            }
            return this.lubTupleTypes(this, o);
        }
        return super.lub(o);
    }

    public int hashCode() {
        int h = this.fHashcode;
        if (h == -1) {
            h = 55501;
            Type[] typeArray = this.fFieldTypes;
            int n = this.fFieldTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Type elemType = typeArray[n2];
                h = h * 44927 + elemType.hashCode();
                ++n2;
            }
            this.fHashcode = h;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TupleType)) {
            return false;
        }
        TupleType other = (TupleType)obj;
        if (this.fFieldTypes.length != other.fFieldTypes.length) {
            return false;
        }
        int i = this.fFieldTypes.length - 1;
        while (i >= 0) {
            if (this.fFieldTypes[i] != other.fFieldTypes[i]) {
                return false;
            }
            --i;
        }
        if (this.fFieldNames != null) {
            if (other.fFieldNames == null) {
                return false;
            }
            i = this.fFieldNames.length - 1;
            while (i >= 0) {
                if (!this.fFieldNames[i].equals(other.fFieldNames[i])) {
                    return false;
                }
                --i;
            }
        } else if (other.fFieldNames != null) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("tuple[");
        int idx = 0;
        Type[] typeArray = this.fFieldTypes;
        int n = this.fFieldTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type elemType = typeArray[n2];
            if (idx++ > 0) {
                sb.append(",");
            }
            sb.append(elemType.toString());
            if (this.hasFieldNames()) {
                sb.append(" " + this.fFieldNames[idx - 1]);
            }
            ++n2;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Iterator<Type> iterator() {
        return new Iterator<Type>(){
            private int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < TupleType.this.fFieldTypes.length;
            }

            @Override
            public Type next() {
                return TupleType.this.fFieldTypes[this.cursor++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public <T> T accept(ITypeVisitor<T> visitor) {
        return visitor.visitTuple(this);
    }

    @Override
    public IValue make(IValueFactory f) {
        return f.tuple();
    }

    @Override
    public IValue make(IValueFactory f, IValue ... elems) {
        return f.tuple(elems);
    }

    @Override
    public String getFieldName(int i) {
        return this.fFieldNames != null ? this.fFieldNames[i] : null;
    }

    @Override
    public void match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        super.match(matched, bindings);
        int i = this.getArity() - 1;
        while (i >= 0) {
            this.getFieldType(i).match(matched.getFieldType(i), bindings);
            --i;
        }
    }

    @Override
    public Type instantiate(Map<Type, Type> bindings) {
        if (this.hasFieldNames()) {
            Type[] fTypes = new Type[this.getArity()];
            String[] fLabels = new String[this.getArity()];
            int i = fTypes.length - 1;
            while (i >= 0) {
                fTypes[i] = this.getFieldType(i).instantiate(bindings);
                fLabels[i] = this.getFieldName(i);
                --i;
            }
            return TypeFactory.getInstance().tupleType(fTypes, fLabels);
        }
        Type[] fChildren = new Type[this.getArity()];
        int i = fChildren.length - 1;
        while (i >= 0) {
            fChildren[i] = this.getFieldType(i).instantiate(bindings);
            --i;
        }
        return TypeFactory.getInstance().tupleType(fChildren);
    }

    @Override
    public Type select(int ... fields) {
        int width = fields.length;
        if (width == 0) {
            return TypeFactory.getInstance().voidType();
        }
        if (width == 1) {
            return this.getFieldType(fields[0]);
        }
        if (!this.hasFieldNames()) {
            Type[] fieldTypes = new Type[width];
            int i = width - 1;
            while (i >= 0) {
                fieldTypes[i] = this.getFieldType(fields[i]);
                --i;
            }
            return TypeFactory.getInstance().tupleType(fieldTypes);
        }
        Type[] fieldTypes = new Type[width];
        String[] fieldNames = new String[width];
        boolean seenDuplicate = false;
        int i = width - 1;
        while (i >= 0) {
            fieldTypes[i] = this.getFieldType(fields[i]);
            fieldNames[i] = this.getFieldName(fields[i]);
            int j = width - 1;
            while (j > i) {
                if (fieldNames[j].equals(fieldNames[i])) {
                    seenDuplicate = true;
                }
                --j;
            }
            --i;
        }
        if (!seenDuplicate) {
            return TypeFactory.getInstance().tupleType(fieldTypes, fieldNames);
        }
        return TypeFactory.getInstance().tupleType(fieldTypes);
    }

    @Override
    public Type select(String ... names) {
        int[] indexes = new int[names.length];
        int i = 0;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            indexes[i] = this.getFieldIndex(name);
            ++n2;
        }
        return this.select(indexes);
    }
}

