/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.visitors;

import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IExternalValue;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IListWriter;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.IRelationWriter;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorAdapter;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BottomUpVisitor<T>
extends VisitorAdapter<T> {
    protected IValueFactory fFactory;

    public BottomUpVisitor(IValueVisitor<T> visitor, IValueFactory factory) {
        super(visitor);
        this.fFactory = factory;
    }

    @Override
    public T visitNode(INode o) throws VisitorException {
        int i = 0;
        while (i < o.arity()) {
            o.get(i).accept(this);
            ++i;
        }
        return (T)this.fVisitor.visitNode(o);
    }

    @Override
    public T visitConstructor(IConstructor o) throws VisitorException {
        int i = 0;
        while (i < o.arity()) {
            o.get(i).accept(this);
            ++i;
        }
        return (T)this.fVisitor.visitConstructor(o);
    }

    @Override
    public T visitList(IList o) throws VisitorException {
        IListWriter w = this.fFactory.listWriter(o.getElementType());
        for (IValue elem : o) {
            elem.accept(this);
        }
        return (T)this.fVisitor.visitList(w.done());
    }

    @Override
    public T visitSet(ISet o) throws VisitorException {
        ISetWriter w = this.fFactory.setWriter(o.getElementType());
        for (IValue elem : o) {
            elem.accept(this);
        }
        return (T)this.fVisitor.visitSet(w.done());
    }

    @Override
    public T visitMap(IMap o) throws VisitorException {
        IMapWriter w = this.fFactory.mapWriter(o.getKeyType(), o.getValueType());
        for (IValue elem : o) {
            elem.accept(this);
            o.get(elem).accept(this);
        }
        return (T)this.fVisitor.visitMap(w.done());
    }

    @Override
    public T visitRelation(IRelation o) throws VisitorException {
        IRelationWriter w = this.fFactory.relationWriter(o.getFieldTypes());
        for (IValue tuple : o) {
            tuple.accept(this);
        }
        return (T)this.fVisitor.visitRelation((IRelation)w.done());
    }

    @Override
    public T visitTuple(ITuple o) throws VisitorException {
        int i = 0;
        while (i < o.arity()) {
            o.get(i).accept(this);
            ++i;
        }
        return (T)this.fVisitor.visitTuple(o);
    }

    @Override
    public T visitExternal(IExternalValue externalValue) throws VisitorException {
        return (T)this.fVisitor.visitExternal(externalValue);
    }
}

