/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.analysis;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.imp.pdb.PDBPlugin;
import org.eclipse.imp.pdb.analysis.AnalysisException;
import org.eclipse.imp.pdb.analysis.IAnalysisDescriptor;
import org.eclipse.imp.pdb.analysis.IFactGeneratorFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnalysisFactoryElement {
    public static final String ANALYZER_FACTORY_NAME_ATTR = "name";
    public static final String ANALYZER_FACTORY_CLASS_ATTR = "class";
    public static final String ANALYZER_SIGNATURE_DESC_ELEMENT = "signatureDescriptor";
    public static final String ANALYZER_OUTPUTS_ELEMENT = "outputs";
    public static final String ANALYZER_TYPE_DESC_ELEMENT = "typeDescriptor";
    public static final String ANALYZER_TYPE_ATTR = "typeName";
    private final String fName;
    private Set<IAnalysisDescriptor> fDescriptors;
    private final IFactGeneratorFactory fFactory;
    private IConfigurationElement fConfigurationElement;

    public AnalysisFactoryElement(IConfigurationElement configElement) {
        this.fConfigurationElement = configElement;
        this.fName = this.fConfigurationElement.getAttribute(ANALYZER_FACTORY_NAME_ATTR);
        try {
            this.fFactory = (IFactGeneratorFactory)this.fConfigurationElement.createExecutableExtension(ANALYZER_FACTORY_CLASS_ATTR);
        }
        catch (CoreException e) {
            PDBPlugin.getInstance().logException("Unable to instantiate analyzer factory: " + this.fName, e);
            throw new IllegalArgumentException("Invalid analyzer extension class or analyzer factory creation failed", e);
        }
    }

    private void initFromConfigurationElement(TypeStore typeStore) {
        IConfigurationElement[] signatures = this.fConfigurationElement.getChildren(ANALYZER_SIGNATURE_DESC_ELEMENT);
        this.fDescriptors = new HashSet<IAnalysisDescriptor>();
        int i = 0;
        while (i < signatures.length) {
            IConfigurationElement signature = signatures[i];
            IConfigurationElement outputTypes = signature.getChildren(ANALYZER_OUTPUTS_ELEMENT)[0];
            AnalysisDescriptor analysisDesc = new AnalysisDescriptor(outputTypes, typeStore);
            this.fDescriptors.add(analysisDesc);
            ++i;
        }
    }

    public String getName() {
        return this.fName;
    }

    public Set<IAnalysisDescriptor> getDescriptors() {
        if (this.fDescriptors == null) {
            this.initFromConfigurationElement(this.fFactory.declareTypes());
        }
        return this.fDescriptors;
    }

    public IFactGeneratorFactory getFactory() {
        return this.fFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AnalysisDescriptor
    implements IAnalysisDescriptor {
        final String fFactoryName;
        final Set<Type> fOutputs;

        private AnalysisDescriptor(IConfigurationElement outputElems, TypeStore typeStore) {
            this.fFactoryName = AnalysisFactoryElement.this.fName;
            this.fOutputs = new HashSet<Type>();
            IConfigurationElement[] outputTypes = outputElems.getChildren();
            boolean hasErrors = false;
            int i = 0;
            while (i < outputTypes.length) {
                IConfigurationElement outputTypeElem = outputTypes[i];
                String outputTypeStr = outputTypeElem.getAttribute(AnalysisFactoryElement.ANALYZER_TYPE_ATTR);
                try {
                    Type outputType = typeStore.lookupAlias(outputTypeStr);
                    if (outputType == null) {
                        outputType = typeStore.lookupAbstractDataType(outputTypeStr);
                    }
                    if (outputType == null) {
                        throw new AnalysisException("Output type " + outputTypeStr + " was not declared by the AnalysisGeneratorFactory");
                    }
                    this.fOutputs.add(outputType);
                }
                catch (FactTypeUseException e) {
                    PDBPlugin.getInstance().logException("Invalid type: " + outputTypeStr, e);
                    hasErrors = true;
                }
                catch (AnalysisException e) {
                    PDBPlugin.getInstance().logException("Invalid type: " + outputTypeStr, e);
                }
                ++i;
            }
            if (hasErrors) {
                PDBPlugin.getInstance().logException("Errors in analysis descriptor: " + AnalysisFactoryElement.this, null);
            }
        }

        @Override
        public String getName() {
            return this.fFactoryName;
        }

        @Override
        public Set<Type> getOutputDescriptors() {
            return this.fOutputs;
        }

        @Override
        public Properties getProperties() {
            throw new UnsupportedOperationException("AnalysisDescriptor.getProperties()");
        }
    }
}

