/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.wizards;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.wizards.ExtensionPointEnabler;
import org.eclipse.imp.wizards.ExtensionPointWizard;
import org.eclipse.imp.wizards.ExtensionPointWizardPage;
import org.eclipse.imp.wizards.WizardPageField;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;

public class NewPreferencesSpecificationWizardPage
extends ExtensionPointWizardPage {
    protected String fLanguageName = null;

    NewPreferencesSpecificationWizardPage(ExtensionPointWizard owner) {
        super(owner, "org.eclipse.imp.runtime", "preferencesSpecification", true, true);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setLanguageIfEmpty();
        this.setTemplateIfEmpty();
        this.setFileNameIfEmpty();
        this.setPagePackageIfEmpty();
        this.setPageClassNameBaseIfEmpty();
        this.setPageNameIfEmpty();
        this.setPageIdIfEmpty();
    }

    public String determineLanguage() {
        if (this.fLanguageName != null) {
            return this.fLanguageName;
        }
        try {
            IProject project = null;
            project = this.fProject != null ? this.fProject : this.getProjectBasedOnNameField();
            IPluginModel pluginModel = ExtensionPointEnabler.getPluginModel((IProject)project);
            if (pluginModel != null) {
                IPluginExtension[] extensions = pluginModel.getExtensions().getExtensions();
                for (int n = 0; n < extensions.length; ++n) {
                    IPluginExtension extension = extensions[n];
                    if (!extension.getPoint().equals("org.eclipse.imp.runtime.languageDescription")) continue;
                    IPluginObject[] children = extension.getChildren();
                    for (int k = 0; k < children.length; ++k) {
                        IPluginObject object = children[k];
                        if (!object.getName().equals("language")) continue;
                        this.fLanguageName = ((IPluginElement)object).getAttribute("language").getValue();
                        return this.fLanguageName;
                    }
                    System.err.println("NewPreferencesSpecificationWizardPage.determineLanguage():  Unable to determine language for plugin '" + pluginModel.getBundleDescription().getName() + "': no languageDescription extension.");
                }
            } else if (project != null) {
                System.out.println("Not a plugin project: " + project.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    protected void setLanguageIfEmpty() {
        try {
            String pluginLang = this.determineLanguage();
            if (pluginLang.length() == 0) {
                return;
            }
            WizardPageField field = this.getField("language");
            if (field.getText().length() == 0) {
                field.setText(pluginLang);
            }
        }
        catch (Exception e) {
            ErrorHandler.reportError((String)"NewPreferencesSpecificationWizardPage.setLanguageIfEmpty():  Cannot set 'language' field", (Throwable)e);
        }
    }

    protected void setTemplateIfEmpty() {
        try {
            WizardPageField field = this.getField("template");
            if (field.getText().length() == 0) {
                String templatesPath = NewPreferencesSpecificationWizardPage.getTemplatesPath() + "standard.pfsp";
                templatesPath = templatesPath.replace('\\', '/');
                field.setText(templatesPath);
            }
        }
        catch (Exception e) {
            ErrorHandler.reportError((String)"NewPreferencesSpecificationWizardPage.setTemplateIfEmpty():  Cannot set 'template' field", (Throwable)e);
        }
    }

    protected void setFileNameIfEmpty() {
        try {
            WizardPageField field = this.getField("fileName");
            if (field.getText().length() == 0) {
                String baseName = null;
                String pluginLang = this.determineLanguage();
                baseName = pluginLang.length() != 0 ? pluginLang : "preferences";
                field.setText(baseName + ".pfsp");
            }
        }
        catch (Exception e) {
            ErrorHandler.reportError((String)"NewPreferencesSpecificationWizardPage.setFileNameIfEmpty():  Cannot set 'fileName' field", (Throwable)e);
        }
    }

    protected void setPagePackageIfEmpty() {
        try {
            WizardPageField field = this.getField("pagePackage");
            if (field.getText().length() == 0) {
                Object baseName = null;
                String pluginLang = this.determineLanguage();
                if (pluginLang.length() != 0) {
                    field.setText(pluginLang + ".imp.preferences");
                } else {
                    field.setText("imp.preferences");
                }
            }
        }
        catch (Exception e) {
            ErrorHandler.reportError((String)"NewPreferencesSpecificationWizardPage.setPagePackageIfEmpty\t():  Cannot set 'pageName' field", (Throwable)e);
        }
    }

    protected void setPageClassNameBaseIfEmpty() {
        try {
            WizardPageField field = this.getField("pageClassNameBase");
            if (field.getText().length() == 0) {
                Object baseName = null;
                String pluginLang = this.determineLanguage();
                if (pluginLang.length() != 0) {
                    field.setText(pluginLang.substring(0, 1).toUpperCase() + pluginLang.substring(1) + "Preferences");
                } else {
                    field.setText("Preferences");
                }
            }
        }
        catch (Exception e) {
            ErrorHandler.reportError((String)"NewPreferencesSpecificationWizardPage.setPageClassNameBaseIfEmpty\t():  Cannot set 'pageName' field", (Throwable)e);
        }
    }

    protected void setPageNameIfEmpty() {
        try {
            WizardPageField field = this.getField("pageName");
            if (field.getText().length() == 0) {
                String pluginLang = this.determineLanguage();
                if ((pluginLang = pluginLang.substring(0, 1).toUpperCase() + pluginLang.substring(1)).length() != 0) {
                    field.setText(pluginLang);
                } else {
                    field.setText(this.getProjectOfRecord().getName());
                }
            }
        }
        catch (Exception e) {
            ErrorHandler.reportError((String)"NewPreferencesSpecificationWizardPage.setPageNameIfEmpty():  Cannot set 'pageName' field", (Throwable)e);
        }
    }

    protected void setPageIdIfEmpty() {
        try {
            WizardPageField field = this.getField("pageId");
            if (field.getText().length() == 0) {
                String pluginLang = this.determineLanguage();
                if (pluginLang.length() != 0) {
                    field.setText("org.eclipse.imp." + pluginLang + ".preferences");
                } else {
                    field.setText(this.getProjectOfRecord().getName() + ".preferences");
                }
            }
        }
        catch (Exception e) {
            ErrorHandler.reportError((String)"NewPreferencesSpecificationWizardPage.setPageNameIfEmpty():  Cannot set 'pageName' field", (Throwable)e);
        }
    }

    public static String getTemplatesPath() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.imp.preferences");
        try {
            String tmplPath = FileLocator.toFileURL((URL)bundle.getEntry("templates")).getFile();
            if (Platform.getOS().equals("win32")) {
                tmplPath = tmplPath.substring(1);
            }
            return tmplPath;
        }
        catch (IOException e) {
            return null;
        }
    }

    public WizardPageField createTemplateBrowseField(Composite parent, String componentID) {
        return null;
    }

    protected Schema getSchema() {
        return this.fSchema;
    }
}

