/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.preferences.wizards.NewPreferencesSpecificationWizardPage;
import org.eclipse.imp.prefspecs.builders.PrefspecsNature;
import org.eclipse.imp.wizards.CodeServiceWizard;
import org.eclipse.imp.wizards.ExtensionEnabler;
import org.eclipse.imp.wizards.ExtensionPointWizard;
import org.eclipse.imp.wizards.ExtensionPointWizardPage;
import org.eclipse.imp.wizards.IMPWizardPage;
import org.eclipse.imp.wizards.WizardPageField;
import org.eclipse.imp.wizards.WizardUtilities;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class NewPreferencesSpecificationWizard
extends CodeServiceWizard {
    protected String fPreferencesPackage;
    protected String fTemplate;
    protected String fFileName;
    protected String fPagePackage;
    protected String fPageClassNameBase;
    protected String fPageName;
    protected String fPageId;
    protected String fMenuItem;
    protected String fInitializerFileName;
    protected String fAlternativeMessage;
    public static final String PREFERENCES_ID = "org.eclipse.imp.preferences.problem";

    public void addPages() {
        this.addPages((IMPWizardPage[])new ExtensionPointWizardPage[]{new NewPreferencesSpecificationWizardPage((ExtensionPointWizard)this)});
    }

    public List getPluginDependencies() {
        return Arrays.asList("org.eclipse.core.runtime", "org.eclipse.core.resources", "org.eclipse.imp.runtime");
    }

    protected void collectCodeParms() {
        ExtensionPointWizardPage page = (ExtensionPointWizardPage)this.pages[0];
        WizardPageField field = null;
        this.fProject = page.getProjectOfRecord();
        field = page.getField("template");
        this.fTemplate = field.fValue;
        field = page.getField("fileName");
        this.fFileName = field.fValue;
        field = page.getField("pagePackage");
        this.fPagePackage = field.fValue;
        field = page.getField("pageClassNameBase");
        this.fPageClassNameBase = field.fValue;
        field = page.getField("pageName");
        this.fPageName = field.fValue;
        field = page.getField("pageId");
        this.fPageId = field.fValue;
        field = page.getField("category");
        this.fMenuItem = field.fValue;
        field = page.getField("alternative");
        this.fAlternativeMessage = field.fValue;
    }

    public void generateCodeStubs(IProgressMonitor mon) throws CoreException {
        String templateNameForCreatingFile;
        int lastIndex;
        Map subs = this.getStandardSubstitutions(this.fProject);
        String[] identifierSegments = this.fPageName.split(" ");
        String pageIdentifier = identifierSegments[0];
        for (int i = 1; i < identifierSegments.length; ++i) {
            pageIdentifier = pageIdentifier + identifierSegments[i];
        }
        subs.put("$PREFS_PAGE_NAME$", pageIdentifier);
        String templateName = this.fTemplate.replace('\\', '/');
        subs.put("$PREFS_TEMPLATE_NAME$", templateName);
        int lastFileSep = templateName.length();
        if (templateName.lastIndexOf("/") > -1) {
            lastFileSep = templateName.lastIndexOf("/");
        }
        subs.put("$PREFS_TEMPLATE_DIR$", templateName.substring(0, lastFileSep));
        subs.put("$PREFS_PACKAGE_NAME$", this.fPagePackage);
        if (this.fAlternativeMessage.length() != 0) {
            subs.put("$PREFS_ALTERNATIVE_MESSAGE$", this.fAlternativeMessage);
            IFile pageSrc = WizardUtilities.createFileFromTemplate((String)(this.fFullClassName + ".java"), (String)"preferencesPageAlternative.java", (String)this.fPackageFolder, (String)NewPreferencesSpecificationWizard.getProjectSourceLocation((IProject)this.fProject), (Map)subs, (IProject)this.fProject, (IProgressMonitor)mon);
            this.editFile(mon, pageSrc);
            return;
        }
        String projectLocation = this.fProject.getLocation().toString();
        String fieldSpecsLocation = this.fPagePackage;
        if ((fieldSpecsLocation = fieldSpecsLocation.replace("\\", "/")).startsWith(projectLocation)) {
            fieldSpecsLocation = fieldSpecsLocation.substring(projectLocation.length());
        }
        if ((lastIndex = (templateNameForCreatingFile = this.fTemplate.replace('\\', '/')).lastIndexOf(47)) >= 0 && lastIndex < templateNameForCreatingFile.length()) {
            templateNameForCreatingFile = templateNameForCreatingFile.substring(lastIndex + 1);
        }
        ExtensionEnabler.enable((IProject)this.fProject, (String)"org.eclipse.core.runtime", (String)"preferences", (String[][])new String[][]{{"initializer:class", this.fPagePackage + "." + this.fPageClassNameBase + "Initializer"}}, (boolean)false, (List)this.getPluginDependencies(), (IProgressMonitor)mon);
        IFile prefsSpecFile = WizardUtilities.createFileFromTemplate((String)this.fFileName, (String)"org.eclipse.imp.preferences", (String)templateNameForCreatingFile, (String)this.fPagePackage, (String)NewPreferencesSpecificationWizard.getProjectSourceLocation((IProject)this.fProject), (Map)subs, (IProject)this.fProject, (IProgressMonitor)mon);
        this.editFile(mon, prefsSpecFile);
        new PrefspecsNature().addToProject(this.fProject);
    }

    protected void writeOutGenerationParameters() throws CoreException {
        String contents = "PagePackage=" + this.fPagePackage + "\n" + "PageClassNameBase=" + this.fPageClassNameBase + "\n" + "PageName=" + this.fPageName + "\n" + "PageId=" + this.fPageId + "\n" + "PageMenuItem=" + (this.fMenuItem == null || this.fMenuItem.length() == 0 ? "TOP" : this.fMenuItem) + "\n" + "AlternativeMessage=" + (this.fAlternativeMessage == null || this.fAlternativeMessage.length() == 0 ? "Message omitted." : this.fAlternativeMessage) + "\n";
        String packagePath = NewPreferencesSpecificationWizard.getProjectSourceLocation((IProject)this.fProject) + this.fPagePackage.replace('.', '/');
        Path paramFilePath = new Path(packagePath + "/" + this.fPageClassNameBase + ".genparams");
        IFile file = this.fProject.getFile((IPath)paramFilePath);
        NullProgressMonitor mon = new NullProgressMonitor();
        if (file.exists()) {
            file.setContents((InputStream)new ByteArrayInputStream(contents.getBytes()), true, true, (IProgressMonitor)mon);
        } else {
            WizardUtilities.createSubFolders((String)packagePath, (IProject)this.fProject, (IProgressMonitor)mon);
            file.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, (IProgressMonitor)mon);
        }
    }

    public boolean performFinish() {
        this.collectCodeParms();
        if (!this.checkFieldConsistency()) {
            return false;
        }
        if (!this.okToClobberFiles(this.getFilesThatCouldBeClobbered())) {
            return false;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                IWorkspaceRunnable wsop = new IWorkspaceRunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            NewPreferencesSpecificationWizard.this.generateCodeStubs((IProgressMonitor)new NullProgressMonitor());
                            new PrefspecsNature().addToProject(NewPreferencesSpecificationWizard.this.fProject);
                        }
                        catch (Exception e) {
                            ErrorHandler.reportError((String)"NewPreferencesSpecificationWizard.performFinish():  Error adding extension or generating code", (Throwable)e);
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(wsop, monitor);
                }
                catch (Exception e) {
                    ErrorHandler.reportError((String)"Could not add extension points", (Throwable)e);
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ErrorHandler.reportError((String)"Error", (Throwable)realException);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    protected boolean checkFieldConsistency() {
        File templateFile = new File(this.fTemplate);
        if (!templateFile.exists()) {
            return this.postErrorMessage("Specified template file does not exist");
        }
        if (!templateFile.isFile()) {
            return this.postErrorMessage("Specified template file is not a file");
        }
        return true;
    }

    protected boolean postErrorMessage(String msg) {
        Shell parent = this.getShell();
        MessageBox messageBox = new MessageBox(parent, 256);
        messageBox.setMessage(msg);
        int result = messageBox.open();
        return false;
    }

    protected String[] getFilesThatCouldBeClobbered() {
        String packagePath = NewPreferencesSpecificationWizard.getProjectSourceLocation((IProject)this.fProject) + this.fPagePackage.replace('.', '/');
        Path specFilePath = new Path(packagePath + "/" + this.fFileName);
        IFile file = this.fProject.getFile((IPath)specFilePath);
        if (file.exists()) {
            return new String[]{file.getLocation().toString()};
        }
        return new String[0];
    }

    protected void doRefresh(final IResource resource) {
        new Thread(){

            public void run() {
                try {
                    resource.getProject().refreshLocal(2, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }
}

