/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.pageinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.imp.prefspecs.pageinfo.PreferencesPageInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualFieldInfo;
import org.eclipse.ui.console.MessageConsoleStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualEnumFieldInfo
extends VirtualFieldInfo {
    private static final int DEFAULT_NUM_COLS = 2;
    protected String defaultValue = "";
    protected final List<String> valueList = new ArrayList<String>();
    protected final List<String> labelList = new ArrayList<String>();
    private int numCols;
    private boolean hasNumCols = false;

    public VirtualEnumFieldInfo(PreferencesPageInfo parentPage, String name) {
        super(parentPage, name);
    }

    public VirtualEnumFieldInfo(PreferencesPageInfo parentPage, String name, String defValue) {
        this(parentPage, name);
        this.defaultValue = defValue;
    }

    public void setDefaultValue(String s) {
        this.defaultValue = s;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setValuesAndLabels(List<String> values, List<String> labels) {
        Assert.isTrue((values.size() == labels.size() || labels == null || labels.size() == 0 ? 1 : 0) != 0);
        this.valueList.clear();
        this.valueList.addAll(values);
        this.labelList.clear();
        this.labelList.addAll(labels);
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.valueList);
    }

    public List<String> getLabels() {
        return Collections.unmodifiableList(this.labelList);
    }

    @Override
    public void dump(String prefix, MessageConsoleStream out) {
        super.dump(prefix, out);
        String indent = prefix + "  ";
        for (int i = 0; i < this.valueList.size(); ++i) {
            out.println(indent + "slot[" + i + "] = " + this.valueList.get(i) + (this.labelList != null && this.labelList.size() > 0 ? ": " + this.labelList.get(i) : ""));
        }
        out.println(indent + "defaultValue    = " + this.defaultValue);
    }

    public void setNumColumns(int numCols) {
        this.numCols = numCols;
        this.hasNumCols = true;
    }

    public boolean hasNumColumns() {
        return this.hasNumCols;
    }

    public int getNumColumns() {
        return this.hasNumCols ? this.numCols : 2;
    }
}

