/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.parser;

import java.io.IOException;
import lpg.runtime.Monitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.MessageHandlerAdapter;
import org.eclipse.imp.parser.SimpleLPGParseController;
import org.eclipse.imp.prefspecs.parser.Ast.ASTNode;
import org.eclipse.imp.prefspecs.parser.PrefspecsLexer;
import org.eclipse.imp.prefspecs.parser.PrefspecsParser;
import org.eclipse.imp.prefspecs.parser.PrefspecsSyntaxProperties;
import org.eclipse.imp.services.ILanguageSyntaxProperties;

public class PrefspecsParseController
extends SimpleLPGParseController
implements IParseController {
    public PrefspecsParseController() {
        super("prefspecs");
    }

    public void initialize(IPath filePath, ISourceProject project, IMessageHandler handler) {
        super.initialize(filePath, project, handler);
        String fullFilePath = project.getRawProject().getLocation().toString() + "/" + filePath;
        this.createLexerAndParser(fullFilePath);
    }

    private void createLexerAndParser(String filePath) {
        try {
            this.fLexer = new PrefspecsLexer(filePath);
            this.fParser = new PrefspecsParser(this.fLexer.getILexStream());
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public ILanguageSyntaxProperties getSyntaxProperties() {
        return new PrefspecsSyntaxProperties();
    }

    public Object parse(String contents, IProgressMonitor monitor) {
        SimpleLPGParseController.PMMonitor my_monitor = new SimpleLPGParseController.PMMonitor((SimpleLPGParseController)this, monitor);
        char[] contentsArray = contents.toCharArray();
        if (this.fLexer == null) {
            this.fLexer = new PrefspecsLexer();
        }
        this.fLexer.reset(contentsArray, this.fFilePath.toPortableString());
        if (this.fParser == null) {
            this.fParser = new PrefspecsParser(this.fLexer.getILexStream());
        }
        this.fParser.reset(this.fLexer.getILexStream());
        this.fParser.getIPrsStream().setMessageHandler((lpg.runtime.IMessageHandler)new MessageHandlerAdapter(this.handler));
        IFile file = this.fProject.getRawProject().getFile(this.fFilePath);
        try {
            file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            System.err.println("prefspecsParseController.parse:  caught CoreException while deleting problem markers; continuing to parse regardless");
        }
        this.fLexer.lexer((Monitor)my_monitor, this.fParser.getIPrsStream());
        if (my_monitor.isCancelled()) {
            return this.fCurrentAst;
        }
        this.fCurrentAst = this.fParser.parser((Monitor)my_monitor, 0);
        ((PrefspecsParser)this.fParser).resolve((ASTNode)this.fCurrentAst);
        this.cacheKeywordsOnce();
        return this.fCurrentAst;
    }
}

