/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.referenceResolvers;

import java.util.HashMap;
import org.eclipse.imp.language.ILanguageService;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.prefspecs.parser.Ast.ASTNode;
import org.eclipse.imp.prefspecs.parser.Ast.AbstractVisitor;
import org.eclipse.imp.prefspecs.parser.Ast.Itab;
import org.eclipse.imp.prefspecs.parser.Ast.booleanFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.comboFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.conditionalsSpec;
import org.eclipse.imp.prefspecs.parser.Ast.configurationTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.customSpec;
import org.eclipse.imp.prefspecs.parser.Ast.defaultTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.dirListFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fieldsSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fileFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.identifier;
import org.eclipse.imp.prefspecs.parser.Ast.instanceTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.intFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.projectTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.radioFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.stringFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.tab0;
import org.eclipse.imp.prefspecs.parser.Ast.tab1;
import org.eclipse.imp.prefspecs.parser.Ast.tab2;
import org.eclipse.imp.prefspecs.parser.Ast.tab3;
import org.eclipse.imp.prefspecs.parser.Ast.tabsSpec;
import org.eclipse.imp.services.IReferenceResolver;

public class PrefspecsReferenceResolver
implements IReferenceResolver,
ILanguageService {
    private HashMap<String, ASTNode> tabDecls = null;
    private HashMap<String, ASTNode> fieldDecls = null;

    public String getLinkText(Object node) {
        return node.toString();
    }

    public Object getLinkTarget(Object node, IParseController controller) {
        if (controller.getCurrentAst() != null) {
            this.buildScopeAndDeclStructures(controller);
        }
        if (node instanceof identifier) {
            ASTNode bindingTarget = this.findDeclForIdentifier((identifier)node);
            return bindingTarget;
        }
        if (node instanceof Itab) {
            ASTNode bindingTarget = this.findDeclForTab((Itab)node);
            return bindingTarget;
        }
        return null;
    }

    protected ASTNode findDeclForTab(Itab node) {
        if (node instanceof tab0) {
            return this.tabDecls.get(((tab0)node).getDEFAULT().toString());
        }
        if (node instanceof tab1) {
            return this.tabDecls.get(((tab1)node).getCONFIGURATION().toString());
        }
        if (node instanceof tab2) {
            return this.tabDecls.get(((tab2)node).getINSTANCE().toString());
        }
        if (node instanceof tab3) {
            ASTNode res = this.tabDecls.get(((tab3)node).getPROJECT().toString());
            return res;
        }
        System.err.println("PrefspecsReferenceResolver.findDeclForTab:  got tab of unknown type, returning null");
        return null;
    }

    protected ASTNode findDeclForIdentifier(identifier node) {
        return this.fieldDecls.get(node.getIDENTIFIER().toString());
    }

    protected void buildScopeAndDeclStructures(IParseController controller) {
        this.tabDecls = new HashMap();
        this.fieldDecls = new HashMap();
        PageVisitor visitor = new PageVisitor();
        ASTNode ast = (ASTNode)controller.getCurrentAst();
        ast.accept(visitor);
    }

    public class PageVisitor
    extends AbstractVisitor {
        boolean inTabsSpec = false;
        boolean inFieldsSpec = false;
        boolean inCustomSpec = false;
        boolean inConditionalsSpec = false;

        PageVisitor() {
        }

        public void unimplementedVisitor(String s) {
        }

        public boolean visit(tabsSpec node) {
            this.inTabsSpec = true;
            return true;
        }

        public void endVisit(tabsSpec node) {
            this.inTabsSpec = false;
        }

        public boolean visit(fieldsSpec node) {
            this.inFieldsSpec = true;
            return true;
        }

        public void endVisit(fieldsSpec node) {
            this.inFieldsSpec = false;
        }

        public boolean visit(customSpec node) {
            this.inCustomSpec = true;
            return true;
        }

        public void endVisit(customSpec node) {
            this.inCustomSpec = false;
        }

        public boolean visit(conditionalsSpec node) {
            this.inConditionalsSpec = true;
            return true;
        }

        public void endVisit(conditionalsSpec node) {
            this.inConditionalsSpec = false;
        }

        public boolean visit(defaultTabSpec node) {
            if (this.inTabsSpec) {
                PrefspecsReferenceResolver.this.tabDecls.put("DEFAULT", node);
            }
            return true;
        }

        public boolean visit(configurationTabSpec node) {
            if (this.inTabsSpec) {
                PrefspecsReferenceResolver.this.tabDecls.put("CONFIGURATION", node);
            }
            return true;
        }

        public boolean visit(instanceTabSpec node) {
            if (this.inTabsSpec) {
                PrefspecsReferenceResolver.this.tabDecls.put("INSTANCE", node);
            }
            return true;
        }

        public boolean visit(projectTabSpec node) {
            if (this.inTabsSpec) {
                PrefspecsReferenceResolver.this.tabDecls.put("PROJECT", node);
            }
            return true;
        }

        public boolean visit(booleanFieldSpec node) {
            if (this.inFieldsSpec) {
                PrefspecsReferenceResolver.this.fieldDecls.put(node.getidentifier().getIDENTIFIER().toString(), node);
            }
            return true;
        }

        public boolean visit(comboFieldSpec node) {
            if (this.inFieldsSpec) {
                PrefspecsReferenceResolver.this.fieldDecls.put(node.getidentifier().getIDENTIFIER().toString(), node);
            }
            return true;
        }

        public boolean visit(dirListFieldSpec node) {
            if (this.inFieldsSpec) {
                PrefspecsReferenceResolver.this.fieldDecls.put(node.getidentifier().getIDENTIFIER().toString(), node);
            }
            return true;
        }

        public boolean visit(fileFieldSpec node) {
            if (this.inFieldsSpec) {
                PrefspecsReferenceResolver.this.fieldDecls.put(node.getidentifier().getIDENTIFIER().toString(), node);
            }
            return true;
        }

        public boolean visit(intFieldSpec node) {
            if (this.inFieldsSpec) {
                PrefspecsReferenceResolver.this.fieldDecls.put(node.getidentifier().getIDENTIFIER().toString(), node);
            }
            return true;
        }

        public boolean visit(radioFieldSpec node) {
            if (this.inFieldsSpec) {
                PrefspecsReferenceResolver.this.fieldDecls.put(node.getidentifier().getIDENTIFIER().toString(), node);
            }
            return true;
        }

        public boolean visit(stringFieldSpec node) {
            if (this.inFieldsSpec) {
                PrefspecsReferenceResolver.this.fieldDecls.put(node.getidentifier().getIDENTIFIER().toString(), node);
            }
            return true;
        }

        public boolean visit(tab0 node) {
            if (this.inTabsSpec) {
                PrefspecsReferenceResolver.this.tabDecls.put(node.getDEFAULT().toString(), node);
            }
            return false;
        }

        public boolean visit(tab1 node) {
            if (this.inTabsSpec) {
                PrefspecsReferenceResolver.this.tabDecls.put(node.getCONFIGURATION().toString(), node);
            }
            return false;
        }

        public boolean visit(tab2 node) {
            if (this.inTabsSpec) {
                PrefspecsReferenceResolver.this.tabDecls.put(node.getINSTANCE().toString(), node);
            }
            return false;
        }

        public boolean visit(tab3 node) {
            if (this.inTabsSpec) {
                PrefspecsReferenceResolver.this.tabDecls.put(node.getPROJECT().toString(), node);
            }
            return false;
        }
    }
}

