/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.pageinfo;

import org.eclipse.imp.prefspecs.pageinfo.ConcreteFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.PreferencesTabInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualStringFieldInfo;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConcreteStringFieldInfo
extends ConcreteFieldInfo {
    protected VirtualStringFieldInfo vStringFieldInfo = null;
    protected String specialValue = "\"Unspecified\"";
    protected boolean emptyValueAllowed = true;
    protected String emptyValue = "";

    public ConcreteStringFieldInfo(VirtualStringFieldInfo vFieldInfo, PreferencesTabInfo parentTab) {
        super(vFieldInfo, parentTab);
        this.vStringFieldInfo = vFieldInfo;
    }

    public String getDefaultValue() {
        return this.vStringFieldInfo.getDefaultValue();
    }

    public String getSpecialValue() {
        return this.specialValue;
    }

    public void setSpecialValue(String s) {
        if (!this.getHasSpecialValue()) {
            throw new IllegalStateException("ConcreteStringFieldInfo.setSpecialValue(String):  attempt to set special value when field has no special value");
        }
        this.specialValue = s;
    }

    public void setEmptyValueAllowed(boolean b) {
        this.emptyValueAllowed = b;
    }

    public boolean getEmptyValueAllowed() {
        return this.emptyValueAllowed;
    }

    public void setEmptyValue(String s) {
        this.emptyValue = s != null ? s : "";
    }

    public String getEmptyValue() {
        return this.vStringFieldInfo.getEmptyValue();
    }

    public String getValidatorQualClass() {
        return this.vStringFieldInfo.getValidatorQualClass();
    }

    public void dump(String prefix, MessageConsoleStream out) {
        super.dump(prefix, out);
        String indent = prefix + "  ";
        out.println(indent + "default value = " + this.vStringFieldInfo.getDefaultValue());
        if (this.getHasSpecialValue()) {
            out.println(indent + "special = " + this.getSpecialValue());
        } else {
            out.println(indent + "no special value defined");
        }
        out.println(indent + "emptyValueAllowed = " + this.getEmptyValueAllowed());
        if (this.getEmptyValueAllowed()) {
            out.println(indent + "empty value = " + this.getEmptyValue());
        } else {
            out.println(indent + "no empty value defined");
        }
    }
}

