/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.builders;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.builder.BuilderBase;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.prefspecs.PrefspecsPlugin;
import org.eclipse.imp.prefspecs.compiler.PrefspecsCompiler;
import org.eclipse.imp.runtime.PluginBase;

public class PrefspecsBuilder
extends BuilderBase {
    protected static final String PREFSPECS_CONSOLE_NAME = "Pref Specs Builder";
    public static final String BUILDER_ID = "org.eclipse.imp.prefspecs.builder";
    public static final String PROBLEM_MARKER_ID = "org.eclipse.imp.prefspecs.problem";
    public static final Language LANGUAGE = LanguageRegistry.findLanguage((String)"prefspecs");

    protected PluginBase getPlugin() {
        return PrefspecsPlugin.getInstance();
    }

    protected String getErrorMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected String getWarningMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected String getInfoMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected boolean isSourceFile(IFile file) {
        IPath path = file.getRawLocation();
        if (path == null) {
            return false;
        }
        String pathString = path.toString();
        if (pathString.indexOf("/bin/") != -1) {
            return false;
        }
        return LANGUAGE.hasExtension(path.getFileExtension());
    }

    protected boolean isNonRootSourceFile(IFile resource) {
        return false;
    }

    protected boolean isOutputFolder(IResource resource) {
        return resource.getFullPath().lastSegment().equals("bin");
    }

    protected void collectDependencies(IFile file) {
    }

    protected String getConsoleName() {
        return PREFSPECS_CONSOLE_NAME;
    }

    protected void compile(IFile file, IProgressMonitor monitor) {
        try {
            this.getConsoleStream().println("Builder.compile with file = " + file.getName());
            PrefspecsCompiler compiler = new PrefspecsCompiler(PROBLEM_MARKER_ID, this.getConsoleStream());
            compiler.compile(file, monitor);
            this.doRefresh((IResource)file.getParent());
        }
        catch (Exception e) {
            this.getPlugin().writeErrorMsg(e.getMessage());
            e.printStackTrace();
        }
    }
}

