/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.pageinfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.PreferencesPageInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualBooleanFieldInfo;
import org.eclipse.ui.console.MessageConsoleStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualFieldInfo {
    protected PreferencesPageInfo parentPage = null;
    protected String name = null;
    protected String toolTipText = null;
    protected boolean hasEditableSpec = false;
    protected boolean isEditable = true;
    protected boolean hasRemovableSpec = false;
    protected boolean isRemovable = false;
    protected String optLabel = null;
    protected boolean hasSpecialValue = false;
    protected boolean isConditional = false;
    protected boolean conditionalWith = true;
    protected VirtualBooleanFieldInfo conditionField = null;
    List<ConcreteFieldInfo> concreteFieldInfos = new ArrayList<ConcreteFieldInfo>();

    public VirtualFieldInfo(PreferencesPageInfo parentPage, String name) {
        if (parentPage == null) {
            throw new IllegalArgumentException("VirtualFieldInfo(..):  parent page is null; not allowed");
        }
        if (name == null) {
            throw new IllegalArgumentException("PreferencesIabInfo(..):  name is null; not allowed");
        }
        this.parentPage = parentPage;
        this.name = name;
        parentPage.addVirtualFieldInfo(this);
    }

    public PreferencesPageInfo getParentPage() {
        return this.parentPage;
    }

    public String getName() {
        return this.name;
    }

    public void addConcreteFieldInfo(ConcreteFieldInfo cFieldInfo) {
        this.concreteFieldInfos.add(cFieldInfo);
    }

    public Iterator<ConcreteFieldInfo> getConcreteFieldInfos() {
        return this.concreteFieldInfos.iterator();
    }

    public boolean hasEditableSpec() {
        return this.hasEditableSpec;
    }

    public boolean getIsEditable() {
        return this.isEditable;
    }

    public void setIsEditable(boolean isEditable) {
        this.isEditable = isEditable;
        this.hasEditableSpec = true;
    }

    public boolean hasRemovableSpec() {
        return this.hasRemovableSpec;
    }

    public boolean getIsRemovable() {
        if (this.getName().equals("default")) {
            return false;
        }
        return this.isRemovable;
    }

    public void setIsRemovable(boolean isRemovable) {
        if (this.getName().equals("default") && isRemovable) {
            throw new IllegalArgumentException("PreferenceIabInfo.setIsRemovable(..):  cannot set isRemovable ");
        }
        this.isRemovable = isRemovable;
        this.hasRemovableSpec = true;
    }

    public String getLabel() {
        return this.optLabel;
    }

    public void setLabel(String newLabel) {
        this.optLabel = newLabel;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
    }

    public boolean getHasSpecialValue() {
        return this.hasSpecialValue;
    }

    public void setHasSpecialValue(boolean hasSpecialValue) {
        this.hasSpecialValue = hasSpecialValue;
    }

    public boolean getIsConditional() {
        return this.isConditional;
    }

    public void setIsConditional(boolean b) {
        this.isConditional = b;
    }

    public boolean getConditionalWith() {
        return this.conditionalWith;
    }

    public void setConditionalWith(boolean b) {
        this.conditionalWith = b;
    }

    public VirtualBooleanFieldInfo getConditionField() {
        return this.conditionField;
    }

    public void setConditionField(VirtualBooleanFieldInfo vbf) {
        this.conditionField = vbf;
    }

    public void dump(String prefix, MessageConsoleStream out) {
        String indent = prefix + "  ";
        out.println(prefix + "Field '" + this.getName() + "'");
        out.println(indent + "parent page = " + this.getParentPage().getPageName());
        out.println(indent + "isEditable  = " + this.isEditable);
        out.println(indent + "isRemovable = " + this.isRemovable);
        if (this.isConditional) {
            out.println(indent + "isConditional " + (this.conditionalWith ? "with" : "against") + " " + (this.conditionField != null ? this.conditionField.getName() : "<unknown>"));
        } else {
            out.println(indent + "isConditional  = false");
        }
    }
}

