/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.pageinfo;

import org.eclipse.imp.prefspecs.pageinfo.ConcreteFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.PreferencesTabInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualIntFieldInfo;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConcreteIntFieldInfo
extends ConcreteFieldInfo {
    protected VirtualIntFieldInfo vIntFieldInfo = null;
    int specialValue = 0;
    protected int rangeHigh = Integer.MAX_VALUE;
    protected int rangeLow = Integer.MIN_VALUE;

    public ConcreteIntFieldInfo(VirtualIntFieldInfo vField, PreferencesTabInfo parentTab) {
        super(vField, parentTab);
    }

    public PreferencesTabInfo getParentTab() {
        return this.parentTab;
    }

    public int getDefaultValue() {
        return this.vIntFieldInfo.getDefaultValue();
    }

    public int getSpecialValue() {
        return this.specialValue;
    }

    public void setSpecialValue(int i) {
        if (!this.getHasSpecialValue()) {
            throw new IllegalArgumentException("ConcreteIntFieldInfo.setSpecialValue(int):  attempt to set special value when field has no special value");
        }
        if (i < this.getRangeLow() || i > this.getRangeHigh()) {
            throw new IllegalArgumentException("ConcreteIntFieldInfo.setSpecialValue(int):  attempt to set special value = " + i + " outside of range = " + this.getRangeLow() + ".." + this.getRangeHigh());
        }
        this.specialValue = i;
    }

    public void setRangeHigh(int i) {
        if (i < this.rangeLow) {
            throw new IllegalArgumentException("VirtualIintField.setRangeHigh(int):  given value = " + i + " is less than low value for range = " + this.rangeLow);
        }
        this.rangeHigh = i;
    }

    public int getRangeHigh() {
        return this.rangeHigh;
    }

    public void setRangeLow(int i) {
        if (i > this.rangeHigh) {
            throw new IllegalArgumentException("VirtualIintField.setRangeLow(int):  given value = " + i + " is greater than high value for range = " + this.rangeHigh);
        }
        this.rangeLow = i;
    }

    public int getRangeLow() {
        return this.rangeLow;
    }

    public void dump(String prefix, MessageConsoleStream out) {
        super.dump(prefix, out);
        String indent = prefix + "  ";
        out.println(indent + "hasSpecialValue = " + this.getHasSpecialValue());
        out.println(indent + "specialValue = " + this.getSpecialValue());
        out.println(indent + "rangeLow = " + this.getRangeLow());
        out.println(indent + "rangeHigh = " + this.getRangeHigh());
    }
}

