/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.compiler.codegen;

import org.eclipse.imp.prefspecs.compiler.DynamicEnumValueSource;
import org.eclipse.imp.prefspecs.compiler.codegen.EnumFieldCodeGenerator;
import org.eclipse.imp.prefspecs.compiler.model.ComboFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.PageInfo;

public class ComboFieldCodeGenerator
extends EnumFieldCodeGenerator {
    private final ComboFieldInfo fComboFieldInfo;

    public ComboFieldCodeGenerator(ComboFieldInfo fieldInfo) {
        super(fieldInfo);
        this.fComboFieldInfo = fieldInfo;
    }

    public void genPreferenceInitializer(StringBuilder srcText, String prefKeysClassName) {
        srcText.append("\t\tservice.setStringPreference(IPreferencesService.DEFAULT_LEVEL, " + prefKeysClassName + "." + this.getPreferenceKey() + ", " + this.getEnumDefaultValueExpr(this.fComboFieldInfo.getValueSource()) + ");\n");
    }

    public String getFieldEditorTypeName() {
        return "ComboFieldEditor";
    }

    public void genTextToCreateField(StringBuilder srcText, PageInfo pageInfo, String tabLevel, String parentComposite) {
        boolean editable = !tabLevel.equals("project");
        String label = this.fFieldInfo.getLabel() != null ? this.fFieldInfo.getLabel() : this.createLabelFor(this.fFieldInfo.getName());
        String toolTip = this.fFieldInfo.getToolTipText();
        srcText.append("\n");
        if (this.fComboFieldInfo.getValueSource() instanceof DynamicEnumValueSource) {
            DynamicEnumValueSource evs = (DynamicEnumValueSource)this.fComboFieldInfo.getValueSource();
            srcText.append("\t\tIEnumValueProvider evp = new " + evs.getQualClassName() + "();\n");
        }
        srcText.append("\t\tComboFieldEditor " + this.fFieldInfo.getName() + " = fPrefUtils.makeNewComboField(\n");
        srcText.append("\t\t\tpage, this, fPrefService,\n");
        srcText.append("\t\t\t\"" + tabLevel + "\", \"" + this.fFieldInfo.getName() + "\", \"" + label + "\",\n");
        srcText.append("\t\t\t\"" + (toolTip != null ? toolTip : "") + "\",\n");
        srcText.append("\t\t\t" + this.fComboFieldInfo.getNumColumns() + ",\n");
        srcText.append("\t\t\t" + this.getValueStringsExpr(this.fComboFieldInfo.getValueSource()) + ",\n");
        srcText.append("\t\t\t" + this.getLabelStringsExpr(this.fComboFieldInfo.getValueSource()) + ",\n");
        srcText.append("\t\t\t" + parentComposite + ",\n");
        srcText.append("\t\t\t" + editable + ",\n");
        srcText.append("\t\t\t" + this.fFieldInfo.getIsRemovable() + ");\n");
        srcText.append("\t\tfields.add(" + this.fFieldInfo.getName() + ");\n\n");
        if (!pageInfo.getNoDetails()) {
            String linkName = this.fFieldInfo.getName() + "DetailsLink";
            srcText.append("\t\tLink " + linkName + " = fPrefUtils.createDetailsLink(parent, " + this.fFieldInfo.getName() + ", " + this.fFieldInfo.getName() + ".getComboBoxControl().getParent()" + ", \"Details ...\");\n\n");
            srcText.append("\t\t" + linkName + ".setEnabled(" + editable + ");\n");
            srcText.append("\t\tfDetailsLinks.add(" + linkName + ");\n\n");
        }
    }
}

