/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.compiler.codegen;

import org.eclipse.imp.prefspecs.compiler.codegen.FieldCodeGenerator;
import org.eclipse.imp.prefspecs.compiler.model.FontFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.PageInfo;

public class FontFieldCodeGenerator
extends FieldCodeGenerator {
    private final FontFieldInfo fFontFieldInfo;

    public FontFieldCodeGenerator(FontFieldInfo fieldInfo) {
        super(fieldInfo);
        this.fFontFieldInfo = fieldInfo;
    }

    public void genPreferenceInitializer(StringBuilder srcText, String prefKeysClassName) {
        srcText.append("\t\tservice.setStringPreference(IPreferencesService.DEFAULT_LEVEL, " + prefKeysClassName + "." + this.getPreferenceKey() + ", " + this.fFontFieldInfo.getDefaultName() + ");\n");
    }

    public String getFieldEditorTypeName() {
        return "FontFieldEditor";
    }

    public void genTextToCreateField(StringBuilder srcText, PageInfo pageInfo, String tabLevel, String parentComposite) {
        boolean editable = !tabLevel.equals("project");
        String label = this.fFieldInfo.getLabel() != null ? this.fFieldInfo.getLabel() : this.createLabelFor(this.fFieldInfo.getName());
        String toolTip = this.fFieldInfo.getToolTipText();
        srcText.append("\n");
        srcText.append("\t\tFontFieldEditor " + this.fFieldInfo.getName() + " = fPrefUtils.makeNewFontField(\n");
        srcText.append("\t\t\tpage, this, fPrefService,\n");
        srcText.append("\t\t\t\"" + tabLevel + "\", \"" + this.fFieldInfo.getName() + "\", \"" + label + "\",\n");
        srcText.append("\t\t\t\"" + (toolTip != null ? toolTip : "") + "\",\n");
        srcText.append("\t\t\t" + parentComposite + ",\n");
        srcText.append("\t\t\t" + editable + ", " + editable + ",\n");
        srcText.append("\t\t\t" + this.fFieldInfo.getIsRemovable() + ");\n");
        srcText.append("\t\tfields.add(" + this.fFieldInfo.getName() + ");\n\n");
        if (!pageInfo.getNoDetails()) {
            String linkName = this.fFieldInfo.getName() + "DetailsLink";
            srcText.append("\t\tLink " + linkName + " = fPrefUtils.createDetailsLink(" + parentComposite + ", " + this.fFieldInfo.getName() + ", " + this.fFieldInfo.getName() + ".getChangeControl().getParent()" + ", \"Details ...\");\n\n");
            srcText.append("\t\t" + linkName + ".setEnabled(" + editable + ");\n");
            srcText.append("\t\tfDetailsLinks.add(" + linkName + ");\n\n");
        }
    }

    public void genTextToEnableField(StringBuilder srcText, String enablementExpr) {
        srcText.append("\t\t\t\t" + this.fFieldInfo.getName() + ".getChangeControl().setEnabled(" + enablementExpr + ");\n");
    }
}

