/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.imp.actions.ActionMessages;
import org.eclipse.imp.actions.OpenActionUtil;
import org.eclipse.imp.actions.SelectionDispatchAction;
import org.eclipse.imp.core.IMPMessages;
import org.eclipse.imp.editor.EditorUtility;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.model.ISourceEntity;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.IReferenceResolver;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;

public class OpenAction
extends SelectionDispatchAction {
    private UniversalEditor fEditor;

    public OpenAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenAction_label);
        this.setToolTipText(ActionMessages.OpenAction_tooltip);
        this.setDescription(ActionMessages.OpenAction_description);
    }

    public OpenAction(UniversalEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(ActionMessages.OpenAction_declaration_label);
        this.setEnabled(EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, false) != null);
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (element instanceof ISourceEntity || element instanceof IFile || element instanceof IStorage) continue;
            return false;
        }
        return true;
    }

    public void run(ITextSelection selection) {
        if (!this.isProcessable()) {
            return;
        }
        IParseController parseCtlr = this.fEditor.getParseController();
        ISourcePositionLocator locator = parseCtlr.getSourcePositionLocator();
        int offset = selection.getOffset();
        int endOffset = selection.getOffset() + selection.getLength() - 1;
        Object node = locator.findNode(parseCtlr.getCurrentAst(), offset, endOffset);
        if (node != null) {
            Object target;
            Language lang = parseCtlr.getLanguage();
            IReferenceResolver resolver = ServiceFactory.getInstance().getReferenceResolver(lang);
            if (resolver != null && (target = resolver.getLinkTarget(node, parseCtlr)) != null && target != node) {
                IPath path = locator.getPath(target);
                int targetOffset = locator.getStartOffset(target);
                int targetLength = locator.getLength(target);
                try {
                    IEditorPart editor = EditorUtility.openInEditor(path);
                    EditorUtility.revealInEditor(editor, targetOffset, targetLength);
                }
                catch (PartInitException e) {
                    RuntimePlugin.getInstance().logException("Unable to open declaration", e);
                }
            }
        }
    }

    private boolean isProcessable() {
        ISourceEntity se = EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, false);
        return this.fEditor != null && se instanceof ICompilationUnit;
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run(selection.toArray());
    }

    public void run(Object[] elements) {
        if (elements == null) {
            return;
        }
        for (int i = 0; i < elements.length; ++i) {
            Object element = elements[i];
            try {
                boolean activateOnOpen = this.fEditor != null ? true : OpenStrategy.activateOnOpen();
                OpenActionUtil.open(element, activateOnOpen);
                continue;
            }
            catch (PartInitException x) {
                String name = null;
                if (element instanceof ISourceEntity) {
                    name = ((ISourceEntity)element).getName();
                } else if (element instanceof IStorage) {
                    name = ((IStorage)element).getName();
                } else if (element instanceof IResource) {
                    name = ((IResource)element).getName();
                }
                if (name == null) continue;
                MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.OpenAction_error_messageProblems, (String)IMPMessages.format(ActionMessages.OpenAction_error_messageArgs, new String[]{name, x.getMessage()}));
            }
        }
    }
}

