/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.editor.LanguageServiceManager;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.services.IOccurrenceMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkOccurrencesAction
implements IWorkbenchWindowActionDelegate {
    public static final String OCCURRENCE_ANNOTATION = "org.eclipse.imp.runtime.occurrenceAnnotation";
    private boolean fMarkingEnabled = false;
    private ITextEditor fActiveEditor;
    private IParseController fParseController;
    private IDocumentProvider fDocumentProvider;
    private IDocument fDocument;
    private Object fCompilationUnit;
    private IOccurrenceMarker fOccurrenceMarker;
    private Annotation[] fOccurrenceAnnotations;
    private ISelectionChangedListener fSelectionListener;
    private IDocumentListener fDocumentListener;
    private IPartListener fPartListener;

    public void run(IAction action) {
        this.fMarkingEnabled = action.isChecked();
        if (this.fMarkingEnabled) {
            this.setUpActiveEditor((ITextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor());
        } else {
            this.unregisterListeners();
            this.removeExistingOccurrenceAnnotations();
        }
    }

    private void registerListeners() {
        IDocument document = this.getDocumentFromEditor();
        if (document == null) {
            return;
        }
        this.fSelectionListener = new SelectionListener();
        this.fDocumentListener = new DocumentListener();
        this.fActiveEditor.getSelectionProvider().addSelectionChangedListener(this.fSelectionListener);
        document.addDocumentListener(this.fDocumentListener);
    }

    private void unregisterListeners() {
        IDocument document;
        ISelectionProvider provider;
        if (this.fActiveEditor == null) {
            return;
        }
        if (this.fSelectionListener != null && (provider = this.fActiveEditor.getSelectionProvider()) != null) {
            this.fActiveEditor.getSelectionProvider().removeSelectionChangedListener(this.fSelectionListener);
        }
        if (this.fDocumentListener != null && (document = this.getDocumentFromEditor()) != null) {
            this.getDocumentFromEditor().removeDocumentListener(this.fDocumentListener);
        }
        if (this.fPartListener != null) {
            this.fActiveEditor.getSite().getPage().removePartListener(this.fPartListener);
        }
    }

    private IDocument getDocumentFromEditor() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null) {
            return provider.getDocument((Object)this.getEditorInput());
        }
        return null;
    }

    private void recomputeAnnotationsForSelection(int offset, int length, IDocument document) {
        IAnnotationModel annotationModel = this.fDocumentProvider.getAnnotationModel((Object)this.getEditorInput());
        Object root = this.getCompilationUnit();
        if (root == null) {
            return;
        }
        Object selectedNode = this.fParseController.getSourcePositionLocator().findNode(root, offset, offset + length - 1);
        if (this.fOccurrenceMarker == null) {
            return;
        }
        try {
            List<Object> occurrences = this.fOccurrenceMarker.getOccurrencesOf(this.fParseController, selectedNode);
            if (occurrences != null) {
                Position[] positions = this.convertRefNodesToPositions(occurrences);
                this.placeAnnotations(this.convertPositionsToAnnotationMap(positions, document), annotationModel);
            } else {
                ErrorHandler.reportError("Occurrence marker returned a null list of occurrences.");
            }
        }
        catch (Exception e) {
            ErrorHandler.reportError("Error obtaining occurrences of selected node", e);
        }
    }

    private Map<Annotation, Position> convertPositionsToAnnotationMap(Position[] positions, IDocument document) {
        HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(positions.length);
        for (int i = 0; i < positions.length; ++i) {
            Position position = positions[i];
            try {
                String message = document.get(position.offset, position.length);
                annotationMap.put(new Annotation(OCCURRENCE_ANNOTATION, false, message), position);
                continue;
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        return annotationMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void placeAnnotations(Map<Annotation, Position> annotationMap, IAnnotationModel annotationModel) {
        Object lockObject;
        Object object = lockObject = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, annotationMap);
            } else {
                this.removeExistingOccurrenceAnnotations();
                for (Map.Entry<Annotation, Position> mapEntry : annotationMap.entrySet()) {
                    annotationModel.addAnnotation(mapEntry.getKey(), mapEntry.getValue());
                }
            }
            this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExistingOccurrenceAnnotations() {
        if (this.fActiveEditor == null) {
            return;
        }
        if (this.fDocumentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = this.fDocumentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                int length = this.fOccurrenceAnnotations.length;
                for (int i = 0; i < length; ++i) {
                    annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    private Position[] convertRefNodesToPositions(List<Object> refs) {
        Position[] positions = new Position[refs.size()];
        int i = 0;
        ISourcePositionLocator locator = this.fParseController.getSourcePositionLocator();
        for (Object node : refs) {
            positions[i] = new Position(locator.getStartOffset(node), locator.getLength(node) + 1);
            ++i;
        }
        return positions;
    }

    private Object getCompilationUnit() {
        this.fCompilationUnit = this.fParseController.getCurrentAst();
        return this.fCompilationUnit;
    }

    private IEditorInput getEditorInput() {
        return this.fActiveEditor.getEditorInput();
    }

    private IDocumentProvider getDocumentProvider() {
        this.fDocumentProvider = this.fActiveEditor.getDocumentProvider();
        return this.fDocumentProvider;
    }

    private void setUpActiveEditor(ITextEditor textEditor) {
        this.unregisterListeners();
        if (textEditor == null) {
            return;
        }
        this.fActiveEditor = textEditor;
        LanguageServiceManager fLanguageServiceManager = LanguageServiceManager.getMyServiceManager((IEditorPart)this.fActiveEditor);
        if (fLanguageServiceManager == null) {
            return;
        }
        this.fDocument = this.getDocumentFromEditor();
        this.fParseController = fLanguageServiceManager.getParseController();
        if (this.fParseController == null) {
            return;
        }
        this.fOccurrenceMarker = fLanguageServiceManager.getOccurrenceMarker();
        this.registerListeners();
        ISelection selection = this.fActiveEditor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            this.recomputeAnnotationsForSelection(textSelection.getOffset(), textSelection.getLength(), this.fDocument);
        }
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        if (annotationModel instanceof ISynchronizable) {
            return ((ISynchronizable)annotationModel).getLockObject();
        }
        return annotationModel;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
        this.unregisterListeners();
    }

    public void init(IWorkbenchWindow window) {
        window.getActivePage().addPartListener((IPartListener)new EditorPartListener());
    }

    static /* synthetic */ Annotation[] access$302(MarkOccurrencesAction x0, Annotation[] x1) {
        x0.fOccurrenceAnnotations = x1;
        return x1;
    }

    private final class SelectionListener
    implements ISelectionChangedListener {
        private ISelection previousSelection = null;

        private SelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof ITextSelection) {
                if (this.previousSelection != null && this.previousSelection.equals(selection)) {
                    return;
                }
                this.previousSelection = selection;
                ITextSelection textSel = (ITextSelection)selection;
                int offset = textSel.getOffset();
                int length = textSel.getLength();
                if (length == 0) {
                    return;
                }
                MarkOccurrencesAction.this.recomputeAnnotationsForSelection(offset, length, MarkOccurrencesAction.this.getDocumentFromEditor());
            }
        }
    }

    private final class DocumentListener
    implements IDocumentListener {
        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            MarkOccurrencesAction.this.fCompilationUnit = null;
        }
    }

    private final class EditorPartListener
    implements IPartListener {
        private EditorPartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof ITextEditor) {
                MarkOccurrencesAction.this.setUpActiveEditor((ITextEditor)part);
                if (MarkOccurrencesAction.this.fDocumentProvider == null) {
                    return;
                }
                IAnnotationModel annotationModel = MarkOccurrencesAction.this.fDocumentProvider.getAnnotationModel((Object)MarkOccurrencesAction.this.getEditorInput());
                if (annotationModel != null) {
                    Iterator annotationIterator = annotationModel.getAnnotationIterator();
                    ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
                    while (annotationIterator.hasNext()) {
                        Annotation ann = (Annotation)annotationIterator.next();
                        if (ann.getType().indexOf(MarkOccurrencesAction.OCCURRENCE_ANNOTATION) <= -1) continue;
                        annotationList.add(ann);
                    }
                    MarkOccurrencesAction.access$302(MarkOccurrencesAction.this, annotationList.toArray(new Annotation[annotationList.size()]));
                }
            }
            if (!MarkOccurrencesAction.this.fMarkingEnabled) {
                MarkOccurrencesAction.this.unregisterListeners();
                MarkOccurrencesAction.this.removeExistingOccurrenceAnnotations();
            }
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == MarkOccurrencesAction.this.fActiveEditor) {
                MarkOccurrencesAction.this.unregisterListeners();
                MarkOccurrencesAction.this.fActiveEditor = null;
                MarkOccurrencesAction.this.fCompilationUnit = null;
                MarkOccurrencesAction.this.fDocumentProvider = null;
                MarkOccurrencesAction.this.fDocument = null;
                MarkOccurrencesAction.this.fParseController = null;
                MarkOccurrencesAction.this.fOccurrenceMarker = null;
                MarkOccurrencesAction.access$302(MarkOccurrencesAction.this, null);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

