/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences;

import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesInitializer;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.PreferencesUtilities;
import org.eclipse.imp.preferences.TabbedPreferencesPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public abstract class DefaultPreferencesTab
extends PreferencesTab {
    public DefaultPreferencesTab(IPreferencesService prefService, boolean noDetails) {
        super("default", noDetails);
        this.fPrefService = prefService;
        this.fPrefUtils = new PreferencesUtilities(prefService);
    }

    public Composite createTabContents(TabbedPreferencesPage page, TabFolder tabFolder) {
        this.fPrefPage = page;
        int numColumns = this.getNoDetails() ? 1 : 2;
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setFont(tabFolder.getFont());
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 0;
        gd.heightHint = -1;
        gd.horizontalSpan = 1;
        composite.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = numColumns;
        composite.setLayout((Layout)gl);
        this.fTabItem = new TabItem(tabFolder, 0);
        this.fTabItem.setText("Default");
        this.fTabItem.setControl((Control)composite);
        PreferencesTab.TabSelectionListener listener = new PreferencesTab.TabSelectionListener(this, this.fPrefPage, this.fTabItem);
        tabFolder.addSelectionListener((SelectionListener)listener);
        this.fFields = this.createFields(page, composite);
        this.clearModifiedMarksOnLabels();
        PreferencesUtilities.fillGridPlace(composite, numColumns);
        Composite bottom = new Composite(composite, 1088);
        GridLayout layout = new GridLayout();
        bottom.setLayout((Layout)layout);
        bottom.setLayoutData((Object)new GridData(1024));
        Label bar = new Label(bottom, 64);
        GridData data = new GridData();
        data.verticalAlignment = 64;
        bar.setLayoutData((Object)data);
        bar.setText("These preferences are set programmatically and are not stored\npersistently.  Changes made here apply only to the current execution.\n\nPreferences on the default level cannot be removed.\n\nModified fields are marked in red.\n\nTabs with erroneous fields are marked with \"**\"");
        PreferencesUtilities.fillGridPlace(bottom, 1);
        this.fButtons = this.fPrefUtils.createDefaultAndApplyButtons(composite, this);
        return composite;
    }

    public void performDefaults() {
        PreferencesInitializer initializer = this.fPrefPage.getPreferenceInitializer();
        if (initializer != null) {
            initializer.clearPreferencesOnLevel("default");
            initializer.initializeDefaultPreferences();
        }
        for (int i = 0; i < this.fFields.length; ++i) {
            this.fFields[i].load();
        }
    }
}

