/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields;

import java.io.File;
import java.util.Stack;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.fields.StringButtonFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class FileFieldEditor
extends StringButtonFieldEditor {
    private String[] extensions = null;
    private boolean enforceAbsolute = false;

    public FileFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int width, int strategy, Composite parent) {
        super(page, tab, service, level, name, labelText, width, strategy, parent);
        this.getChangeControl(parent).setText("Browse");
    }

    public FileFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int width, Composite parent) {
        super(page, tab, service, level, name, labelText, width, 0, parent);
        this.getChangeControl(parent).setText("Browse");
    }

    public FileFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, Composite parent) {
        super(page, tab, service, level, name, labelText, parent);
        this.getChangeControl(parent).setText("Browse");
    }

    protected String changePressed() {
        File d;
        File f = new File(this.getTextControl(this.parent).getText());
        if (!f.exists()) {
            f = null;
        }
        if ((d = this.getFile(f)) == null) {
            return null;
        }
        return d.getAbsolutePath();
    }

    public boolean getEnforceAbsolute() {
        return this.enforceAbsolute;
    }

    public void setEnforceAbsolute(boolean enforceAbsolute) {
        this.enforceAbsolute = enforceAbsolute;
    }

    protected File getFile(File startingDirectory) {
        String file;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        if (startingDirectory != null) {
            dialog.setFileName(startingDirectory.getPath());
        }
        if (this.extensions != null) {
            dialog.setFilterExtensions(this.extensions);
        }
        if ((file = dialog.open()) != null && (file = file.trim()).length() > 0) {
            return new File(file);
        }
        return null;
    }

    public void setFileExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    protected boolean doCheckState() {
        int start;
        Object msg = null;
        String path = this.getTextControl(this.parent).getText();
        if ((path = (path = this.preferencesService.performSubstitutions(path)) != null ? path.trim() : "").length() == 0 && !this.emptyStringAllowed) {
            this.setErrorMessage(this.getFieldMessagePrefix() + "Path length is zero when empty string is not allowed");
            return false;
        }
        String singleQuote = "'";
        String doubleQuote = "\"";
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '\'') {
                if (!stack.empty() && "'".equals(stack.peek())) {
                    stack.pop();
                } else {
                    stack.push("'");
                }
            }
            if (path.charAt(i) != '\"') continue;
            if (!stack.empty() && "\"".equals(stack.peek())) {
                stack.pop();
                continue;
            }
            stack.push("\"");
        }
        if (stack.size() != 0) {
            return false;
        }
        path = path.replace("\"", "'");
        String[] splits = path.split("'");
        boolean splitsVerified = true;
        for (int i = start = path.startsWith("'") ? 1 : 0; i < splits.length; ++i) {
            boolean bl = splitsVerified = splitsVerified && this.doCheckState(splits[i]);
            if (splitsVerified) continue;
            if (!this.hasErrorMessage()) {
                this.setErrorMessage(this.getFieldMessagePrefix() + "Path segment \"splits[i]\" failed verification");
            }
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    protected boolean doCheckState(String path) {
        String msg = null;
        File file = new File(path);
        if (file.isFile()) {
            if (this.enforceAbsolute && !file.isAbsolute()) {
                msg = JFaceResources.getString((String)"FileFieldEditor.errorMessage2");
            }
        } else {
            msg = "Path does not designate a valid file";
        }
        boolean result = true;
        if (msg != null) {
            this.setErrorMessage(this.getFieldMessagePrefix() + msg);
            result = false;
        } else {
            this.clearErrorMessage();
            result = true;
        }
        return result;
    }
}

