/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.core;

import org.eclipse.imp.core.IMPMessages;

public final class Assert {
    private Assert() {
    }

    public static void isNotNull(Object object) {
        if (object != null) {
            return;
        }
        Assert.isNotNull(object, "");
    }

    public static void isNotNull(Object object, String message) {
        if (object == null) {
            throw new AssertionFailedException(IMPMessages.Assert_null_argument + message);
        }
    }

    public static boolean isTrue(boolean expression) {
        if (expression) {
            return true;
        }
        return Assert.isTrue(expression, "");
    }

    public static boolean isTrue(boolean expression, String message) {
        if (!expression) {
            throw new AssertionFailedException(IMPMessages.Assert_assertion_failed + message);
        }
        return expression;
    }

    private static class AssertionFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AssertionFailedException() {
        }

        public AssertionFailedException(String detail) {
            super(detail);
        }
    }
}

