/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesInitializer;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.PreferencesUtilities;
import org.eclipse.imp.preferences.TabbedPreferencesPage;
import org.eclipse.imp.preferences.fields.BooleanFieldEditor;
import org.eclipse.imp.preferences.fields.ColorFieldEditor;
import org.eclipse.imp.preferences.fields.ComboFieldEditor;
import org.eclipse.imp.preferences.fields.FontFieldEditor;
import org.eclipse.imp.preferences.fields.RadioGroupFieldEditor;
import org.eclipse.imp.preferences.fields.StringFieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.osgi.service.prefs.Preferences;

public abstract class ProjectPreferencesTab
extends PreferencesTab {
    protected List<Link> detailsLinks = new ArrayList<Link>();
    protected IProject fProject = null;
    protected Combo selectedProjectCombo;
    protected List<PreferencesUtilities.PreferenceChangeListener> currentListeners = new ArrayList<PreferencesUtilities.PreferenceChangeListener>();
    protected List<IEclipsePreferences> currentListenerNodes = new ArrayList<IEclipsePreferences>();

    public ProjectPreferencesTab(IPreferencesService prefService, boolean noDetails) {
        super("project", noDetails);
        this.fPrefService = prefService;
        this.fPrefUtils = new PreferencesUtilities(prefService);
    }

    public Composite createTabContents(TabbedPreferencesPage page, TabFolder tabFolder) {
        this.fPrefPage = page;
        int numColumns = this.getNoDetails() ? 1 : 2;
        GridLayout layout = null;
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setFont(tabFolder.getFont());
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 0;
        gd.heightHint = -1;
        gd.horizontalSpan = 1;
        composite.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        this.fTabItem = new TabItem(tabFolder, 0);
        this.fTabItem.setText("Project");
        this.fTabItem.setControl((Control)composite);
        PreferencesTab.TabSelectionListener listener = new PreferencesTab.TabSelectionListener(this.fPrefPage, this.fTabItem);
        tabFolder.addSelectionListener((SelectionListener)listener);
        this.fFields = this.createFields(page, composite);
        PreferencesUtilities.fillGridPlace(composite, numColumns);
        for (int i = 0; i < this.detailsLinks.size(); ++i) {
            this.detailsLinks.get(i).setEnabled(false);
        }
        PreferencesUtilities.fillGridPlace(composite, 2);
        this.clearModifiedMarksOnLabels();
        Group groupHolder = new Group(composite, 16);
        groupHolder.setText("Project selection");
        groupHolder.setLayout((Layout)new GridLayout(2, false));
        groupHolder.setLayoutData((Object)new GridData(768));
        Label projLabel = new Label((Composite)groupHolder, 16384);
        projLabel.setText("Project:");
        final Combo projCombo = this.selectedProjectCombo = new Combo((Composite)groupHolder, 12);
        IProject[] pluginProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        projCombo.add("none selected");
        for (int i = 0; i < pluginProjects.length; ++i) {
            projCombo.add(pluginProjects[i].getName());
        }
        projCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String projName = projCombo.getText();
                ProjectPreferencesTab.this.fPrefService.setProjectName(projName);
            }
        });
        projCombo.setSize(150, 24);
        Label pad = new Label((Composite)groupHolder, 0);
        this.fPrefService.clearPreferencesAtLevel("project");
        this.addProjectSelectionListener(composite);
        PreferencesUtilities.fillGridPlace(composite, 3);
        Composite bottom = new Composite(composite, 1088);
        layout = new GridLayout();
        bottom.setLayout((Layout)layout);
        bottom.setLayoutData((Object)new GridData(1024));
        Label bar = new Label(bottom, 64);
        GridData data = new GridData();
        data.verticalAlignment = 64;
        bar.setLayoutData((Object)data);
        bar.setText("Preferences are shown here only when a project is selected.\n\nPreferences shown with a white background are set on this level.\n\nPreferences shown with a colored background are inherited from a\nhigher level.\n\nModified fields are marked in red.\n\nTabs with erroneous fields are marked with \"**\"");
        PreferencesUtilities.fillGridPlace(bottom, 1);
        this.fButtons = this.fPrefUtils.createDefaultAndApplyButtons(composite, this);
        if (this.fPrefService.getProject() == null) {
            for (int i = 0; i < this.fButtons.length; ++i) {
                this.fButtons[i].setEnabled(false);
            }
        }
        return composite;
    }

    private void addProjectSelectionListener(Composite composite) {
        this.fPrefService.addProjectSelectionListener(new ProjectSelectionListener(composite));
    }

    protected void addressProjectSelection(IPreferencesService.ProjectSelectionEvent event, Composite composite) {
        boolean haveCurrentListeners = false;
        Preferences oldeNode = event.getPrevious();
        Preferences newNode = event.getNew();
        if (oldeNode == null && newNode == null) {
            return;
        }
        if (oldeNode != null && oldeNode instanceof IEclipsePreferences && haveCurrentListeners) {
            this.removeProjectPreferenceChangeListeners();
            haveCurrentListeners = false;
        }
        if (newNode != null && newNode instanceof IEclipsePreferences) {
            if (!composite.isDisposed()) {
                this.clearModifiedMarksOnLabels();
            }
            haveCurrentListeners = true;
        }
        if (newNode == null || !(newNode instanceof IEclipsePreferences)) {
            this.fPrefService.clearPreferencesAtLevel("project");
            if (!composite.isDisposed()) {
                // empty if block
            }
            this.removeProjectPreferenceChangeListeners();
            haveCurrentListeners = false;
        }
    }

    protected void addProjectPreferenceChangeListeners(BooleanFieldEditor field, String key, Composite composite) {
        IEclipsePreferences[] nodes = this.fPrefService.getNodesForLevels();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            PreferencesUtilities preferencesUtilities = this.fPrefUtils;
            preferencesUtilities.getClass();
            PreferencesUtilities.BooleanPreferenceChangeListener listener = preferencesUtilities.new PreferencesUtilities.BooleanPreferenceChangeListener(field, key, composite);
            nodes[i].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
            this.currentListeners.add(listener);
            this.currentListenerNodes.add(nodes[i]);
        }
    }

    protected void addProjectPreferenceChangeListeners(FontFieldEditor field, String key, Composite composite) {
        IEclipsePreferences[] nodes = this.fPrefService.getNodesForLevels();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            PreferencesUtilities preferencesUtilities = this.fPrefUtils;
            preferencesUtilities.getClass();
            PreferencesUtilities.FontPreferenceChangeListener listener = preferencesUtilities.new PreferencesUtilities.FontPreferenceChangeListener(field, key, composite);
            nodes[i].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
            this.currentListeners.add(listener);
            this.currentListenerNodes.add(nodes[i]);
        }
    }

    protected void addProjectPreferenceChangeListeners(ColorFieldEditor field, String key, Composite composite) {
        IEclipsePreferences[] nodes = this.fPrefService.getNodesForLevels();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            PreferencesUtilities preferencesUtilities = this.fPrefUtils;
            preferencesUtilities.getClass();
            PreferencesUtilities.ColorPreferenceChangeListener listener = preferencesUtilities.new PreferencesUtilities.ColorPreferenceChangeListener(field, key, composite);
            nodes[i].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
            this.currentListeners.add(listener);
            this.currentListenerNodes.add(nodes[i]);
        }
    }

    protected void addProjectPreferenceChangeListeners(ComboFieldEditor field, String key, Composite composite) {
        IEclipsePreferences[] nodes = this.fPrefService.getNodesForLevels();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            PreferencesUtilities preferencesUtilities = this.fPrefUtils;
            preferencesUtilities.getClass();
            PreferencesUtilities.ComboPreferenceChangeListener listener = preferencesUtilities.new PreferencesUtilities.ComboPreferenceChangeListener(field, key, composite);
            nodes[i].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
            this.currentListeners.add(listener);
            this.currentListenerNodes.add(nodes[i]);
        }
    }

    protected void addProjectPreferenceChangeListeners(RadioGroupFieldEditor field, String key, Composite composite) {
        IEclipsePreferences[] nodes = this.fPrefService.getNodesForLevels();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            PreferencesUtilities preferencesUtilities = this.fPrefUtils;
            preferencesUtilities.getClass();
            PreferencesUtilities.RadioGroupPreferenceChangeListener listener = preferencesUtilities.new PreferencesUtilities.RadioGroupPreferenceChangeListener(field, key, composite);
            nodes[i].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
            this.currentListeners.add(listener);
            this.currentListenerNodes.add(nodes[i]);
        }
    }

    protected void addProjectPreferenceChangeListeners(StringFieldEditor field, String key, Composite composite) {
        IEclipsePreferences[] nodes = this.fPrefService.getNodesForLevels();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            PreferencesUtilities preferencesUtilities = this.fPrefUtils;
            preferencesUtilities.getClass();
            PreferencesUtilities.StringPreferenceChangeListener listener = preferencesUtilities.new PreferencesUtilities.StringPreferenceChangeListener(field, key, composite);
            nodes[i].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
            this.currentListeners.add(listener);
            this.currentListenerNodes.add(nodes[i]);
        }
    }

    protected void removeProjectPreferenceChangeListeners() {
        for (int i = 0; i < this.currentListeners.size(); ++i) {
            this.currentListenerNodes.get(i).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.currentListeners.get(i));
        }
        this.currentListeners = new ArrayList<PreferencesUtilities.PreferenceChangeListener>();
        this.currentListenerNodes = new ArrayList<IEclipsePreferences>();
    }

    protected void setProjectSelectionValidator(ContainerSelectionDialog dialog, boolean validateForPluginProject, boolean validateForIDEProject) {
    }

    public void performApply() {
        if (this.fPrefService.getProject() == null) {
            this.clearModifiedMarksOnLabels();
            return;
        }
        for (int i = 0; i < this.fFields.length; ++i) {
            this.fFields[i].store();
            this.fFields[i].clearModifiedMarkOnLabel();
        }
    }

    public boolean performCancel() {
        this.fPrefService.setProject(null);
        return true;
    }

    public void performDefaults() {
        if (this.fPrefService.getProject() == null) {
            return;
        }
        PreferencesInitializer initializer = this.fPrefPage.getPreferenceInitializer();
        initializer.clearPreferencesOnLevel("project");
        for (int i = 0; i < this.fFields.length; ++i) {
            this.fFields[i].loadWithInheritance();
        }
    }

    public boolean performOk() {
        if (this.fPrefService.getProject() != null) {
            for (int i = 0; i < this.fFields.length; ++i) {
                this.fFields[i].store();
            }
        } else {
            this.fPrefService.clearPreferencesAtLevel("project");
        }
        this.fPrefService.setProject(null);
        return true;
    }

    private class ProjectSelectionListener
    implements IPreferencesService.IProjectSelectionListener {
        Composite composite = null;
        IEclipsePreferences.IPreferenceChangeListener currentListener = null;

        ProjectSelectionListener(Composite composite) {
            this.composite = composite;
        }

        public void selection(IPreferencesService.ProjectSelectionEvent event) {
            ProjectPreferencesTab.this.addressProjectSelection(event, this.composite);
        }
    }
}

