/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.help;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.IContextProvider;
import org.eclipse.imp.editor.LanguageServiceManager;
import org.eclipse.imp.help.IMPHelpContext;
import org.eclipse.imp.help.IMPHelpContextProvider;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.IHelpService;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class IMPHelp {
    private static final Object[] NO_ELEMENTS = new Object[0];

    public static void setHelp(LanguageServiceManager svcMgr, StructuredViewer viewer, String contextId) {
        IMPViewerHelpListener listener = new IMPViewerHelpListener(svcMgr, viewer, contextId);
        viewer.getControl().addHelpListener((HelpListener)listener);
    }

    public static void setHelp(LanguageServiceManager svcMgr, ITextEditor editor, StyledText text, String contextId) {
        IMPEditorHelpListener listener = new IMPEditorHelpListener(svcMgr, editor, contextId);
        text.addHelpListener((HelpListener)listener);
    }

    public static IContextProvider getHelpContextProvider(IWorkbenchPart part, LanguageServiceManager srvcMgr, String contextId) {
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null) {
            ISelection sel = provider.getSelection();
            if (sel instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)sel;
                return new IMPHelpContextProvider(srvcMgr, contextId, selection.toArray());
            }
            if (sel instanceof ITextSelection) {
                ITextSelection textSel = (ITextSelection)sel;
                return new IMPHelpContextProvider(srvcMgr, contextId, (IRegion)new Region(textSel.getOffset(), textSel.getLength()));
            }
        }
        return null;
    }

    private static class IMPEditorHelpListener
    extends IMPHelpListenerBase {
        private final ITextEditor fEditor;
        private final IHelpService fHelpService;
        private final ISourcePositionLocator fLocator;
        private final IParseController fParseController;

        public IMPEditorHelpListener(LanguageServiceManager svcManager, ITextEditor editor, String contextId) {
            super(contextId);
            this.fHelpService = svcManager.getContextHelp();
            this.fParseController = svcManager.getParseController();
            this.fLocator = this.fParseController.getSourcePositionLocator();
            this.fEditor = editor;
        }

        public void helpRequested(HelpEvent e) {
            try {
                Object[] selected = null;
                if (this.fEditor != null) {
                    ITextSelection textSel = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
                    Object node = this.fLocator.findNode(this.fParseController.getCurrentAst(), textSel.getOffset());
                    selected = new Object[]{node};
                }
                IMPHelpContext.displayHelp(this.fHelpService, this.fParseController, this.fContextId, selected);
            }
            catch (CoreException x) {
                RuntimePlugin.getInstance().logException(x.getMessage(), x);
            }
        }
    }

    private static class IMPViewerHelpListener
    extends IMPHelpListenerBase {
        private StructuredViewer fViewer;
        private final IHelpService fHelpService;
        private final IParseController fParseController;

        public IMPViewerHelpListener(LanguageServiceManager svcManager, StructuredViewer viewer, String contextId) {
            super(contextId);
            this.fHelpService = svcManager.getContextHelp();
            this.fParseController = svcManager.getParseController();
            this.fViewer = viewer;
        }

        public void helpRequested(HelpEvent e) {
            try {
                ISelection selection;
                Object[] selected = null;
                if (this.fViewer != null && (selection = this.fViewer.getSelection()) instanceof IStructuredSelection) {
                    selected = ((IStructuredSelection)selection).toArray();
                }
                IMPHelpContext.displayHelp(this.fHelpService, this.fParseController, this.fContextId, selected);
            }
            catch (CoreException x) {
                RuntimePlugin.getInstance().logException(x.getMessage(), x);
            }
        }
    }

    private static abstract class IMPHelpListenerBase
    implements HelpListener {
        protected String fContextId;

        public IMPHelpListenerBase(String contextId) {
            this.fContextId = contextId;
        }
    }
}

