/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class StreamUtils {
    private StreamUtils() {
    }

    public static String readStreamContents(IStreamContentAccessor sca) throws CoreException {
        InputStream is = sca.getContents();
        if (is != null) {
            String encoding = null;
            if (sca instanceof IEncodedStreamContentAccessor) {
                try {
                    encoding = ((IEncodedStreamContentAccessor)sca).getCharset();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            return StreamUtils.readStreamContents(is, encoding);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readReaderContents(Reader r) {
        BufferedReader reader = null;
        try {
            StringBuffer buffer = new StringBuffer();
            char[] part = new char[2048];
            int read = 0;
            reader = new BufferedReader(r);
            while ((read = reader.read(part)) != -1) {
                buffer.append(part, 0, read);
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException ex) {
            System.err.println("I/O Exception: " + ex.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String readStreamContents(InputStream is, String encoding) {
        try {
            return StreamUtils.readReaderContents(new InputStreamReader(is, encoding));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String readStreamContents(InputStream is) {
        return StreamUtils.readStreamContents(is, ResourcesPlugin.getEncoding());
    }
}

