/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.fields.BooleanFieldEditor;
import org.eclipse.imp.preferences.fields.ChangeButtonFieldEditor;
import org.eclipse.imp.preferences.fields.ColorFieldEditor;
import org.eclipse.imp.preferences.fields.ComboFieldEditor;
import org.eclipse.imp.preferences.fields.DirectoryFieldEditor;
import org.eclipse.imp.preferences.fields.DirectoryListFieldEditor;
import org.eclipse.imp.preferences.fields.DoubleFieldEditor;
import org.eclipse.imp.preferences.fields.FieldEditor;
import org.eclipse.imp.preferences.fields.FileFieldEditor;
import org.eclipse.imp.preferences.fields.FontFieldEditor;
import org.eclipse.imp.preferences.fields.IntegerFieldEditor;
import org.eclipse.imp.preferences.fields.RadioGroupFieldEditor;
import org.eclipse.imp.preferences.fields.StringButtonFieldEditor;
import org.eclipse.imp.preferences.fields.StringFieldEditor;
import org.eclipse.imp.preferences.fields.details.DetailsDialogForBooleanFields;
import org.eclipse.imp.preferences.fields.details.DetailsDialogForColorFields;
import org.eclipse.imp.preferences.fields.details.DetailsDialogForComboFields;
import org.eclipse.imp.preferences.fields.details.DetailsDialogForFontFields;
import org.eclipse.imp.preferences.fields.details.DetailsDialogForRadioGroupFields;
import org.eclipse.imp.preferences.fields.details.DetailsDialogForStringFields;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class PreferencesUtilities {
    public static final Color colorBlack = new Color(null, 0, 0, 0);
    public static final Color colorWhite = new Color(null, 255, 255, 255);
    public static final Color colorBluish = new Color(null, 175, 207, 239);
    public static final Color colorGreenish = new Color(null, 0, 127, 239);
    public static final Color colorLightGray = new Color(null, 224, 223, 226);
    public static final Color colorRed = new Color(null, 255, 0, 0);
    public static final String comboDefaultValue = "none selected";
    public static final String comboDefaultName = "None selected";
    protected IPreferencesService service = null;

    public PreferencesUtilities(IPreferencesService service) {
        this.service = service;
    }

    public String setField(BooleanFieldEditor field, Composite parent) {
        String level = field.getPreferencesLevel();
        if ("project".equals(level) && this.service.getProject() == null) {
            if (parent == null) {
                System.err.println("PreferencesUtilities.setField(): parent is null");
            }
            if (parent.isDisposed()) {
                System.err.println("PreferencesUtilities.setField(): parent is disposed");
            }
            field.setFieldValueFromOutside(false);
            if (!parent.isDisposed()) {
                field.getChangeControl().setEnabled(false);
                field.getChangeControl().setBackground(colorBluish);
            }
            return "project";
        }
        String levelFromWhichSet = field.loadWithInheritance();
        if (parent != null && !parent.isDisposed()) {
            if (level != null && level.equals(levelFromWhichSet)) {
                field.getChangeControl().setBackground(colorWhite);
            } else if (level != null && field.getChangeControl().getEnabled()) {
                field.getChangeControl().setBackground(colorBluish);
            }
        }
        return levelFromWhichSet;
    }

    private void checkArgs(FieldEditor field, Composite parent, String whoiam) {
        if (field == null) {
            throw new IllegalArgumentException(whoiam + "given field is null");
        }
        if (parent == null) {
            throw new IllegalArgumentException(whoiam + "given parent is null");
        }
        if (parent.isDisposed()) {
            throw new IllegalStateException(whoiam + "parent is disposed");
        }
        if ("project".equals(field.getPreferencesLevel()) && this.service.getProject() == null) {
            throw new IllegalStateException(whoiam + "field represents a project-level preference and project is not set");
        }
    }

    private void checkArgs(ChangeButtonFieldEditor field, Composite parent, String whoiam) {
        this.checkArgs((FieldEditor)field, parent, whoiam);
        if (!field.getChangeControl().getEnabled()) {
            throw new IllegalStateException(whoiam + "field is not editable");
        }
    }

    private void checkArgs(FieldEditor field, Composite parent, Object value, String whoiam) {
        this.checkArgs(field, parent, whoiam);
        if (value == null) {
            throw new IllegalArgumentException(whoiam + "given value is null");
        }
    }

    private void checkArgs(ChangeButtonFieldEditor field, Composite parent, Object value, String whoiam) {
        this.checkArgs((FieldEditor)field, parent, value, whoiam);
        if (!field.getChangeControl().getEnabled()) {
            throw new IllegalStateException(whoiam + "field is not editable");
        }
    }

    public String setField(BooleanFieldEditor field, Composite parent, boolean value) {
        String whoiam = "PreferencesUtilities.setField(BooleanFieldEditor field, parent, value): ";
        this.checkArgs(field, parent, "PreferencesUtilities.setField(BooleanFieldEditor field, parent, value): ");
        String level = field.getPreferencesLevel();
        field.setFieldValueFromOutside(value);
        field.getChangeControl().setBackground(colorWhite);
        return level;
    }

    public String setField(ComboFieldEditor field, Composite parent) {
        String level = field.getPreferencesLevel();
        if ("project".equals(level) && this.service.getProject() == null) {
            if (parent.isDisposed()) {
                System.err.println("PreferencesUtilities.setField():  composite is disposed");
            }
            field.setFieldValueFromOutside(null);
            if (!parent.isDisposed()) {
                field.getComboBoxControl().setBackground(colorWhite);
                Control[] children = field.getComboBoxControl().getChildren();
                if (children != null) {
                    for (int i = 0; i < children.length; ++i) {
                        Button button = (Button)children[i];
                        button.setBackground(colorWhite);
                    }
                }
            }
            return "project";
        }
        String levelFromWhichSet = field.loadWithInheritance();
        if (!parent.isDisposed()) {
            // empty if block
        }
        return levelFromWhichSet;
    }

    public String setField(ComboFieldEditor field, Composite parent, String value) {
        String whoiam = "PreferencesUtilities.setField(ComboFieldEditor field, parent, value):  ";
        this.checkArgs(field, parent, (Object)value, "PreferencesUtilities.setField(ComboFieldEditor field, parent, value):  ");
        String level = field.getPreferencesLevel();
        field.setFieldValueFromOutside(value);
        field.getComboBoxControl().setBackground(colorWhite);
        return level;
    }

    public String setField(ColorFieldEditor field, Composite parent, String value) {
        String whoiam = "PreferencesUtilities.setField(ColorFieldEditor field, parent, value): ";
        this.checkArgs(field, parent, (Object)value, "PreferencesUtilities.setField(ColorFieldEditor field, parent, value): ");
        String level = field.getPreferencesLevel();
        field.setFieldValueFromOutside(value);
        field.getLabelControl(parent).setBackground(colorWhite);
        return level;
    }

    public String setField(FontFieldEditor field, Composite parent, FontData[] value) {
        String whoiam = "PreferencesUtilities.setField(FontFieldEditor field, composite, value): ";
        this.checkArgs(field, parent, (Object)value, "PreferencesUtilities.setField(FontFieldEditor field, composite, value): ");
        String level = field.getPreferencesLevel();
        field.setFieldValueFromOutside(value);
        field.getChangeControl().setBackground(colorWhite);
        return level;
    }

    public String setField(RadioGroupFieldEditor field, Composite composite) {
        String level = field.getPreferencesLevel();
        if ("project".equals(level) && this.service.getProject() == null) {
            if (composite.isDisposed()) {
                System.err.println("PreferencesUtilities.setField():  composite is disposed");
            }
            field.setFieldValueFromOutside(null);
            if (!composite.isDisposed()) {
                field.getRadioBoxControl().setBackground(colorBluish);
                Button[] radioButtons = field.getRadioButtons();
                if (radioButtons != null) {
                    for (int i = 0; i < radioButtons.length; ++i) {
                        Button button = radioButtons[i];
                        button.setBackground(colorBluish);
                    }
                }
            }
            return "project";
        }
        String levelFromWhichSet = field.loadWithInheritance();
        if (!composite.isDisposed()) {
            // empty if block
        }
        return levelFromWhichSet;
    }

    public String setField(RadioGroupFieldEditor field, Composite composite, String value) {
        String whoiam = "PreferenesUtilities.setField(RadioGroupFieldEditor field, composite, value):  ";
        this.checkArgs(field, composite, (Object)value, "PreferenesUtilities.setField(RadioGroupFieldEditor field, composite, value):  ");
        String level = field.getPreferencesLevel();
        field.setFieldValueFromOutside(value);
        field.getRadioBoxControl().setBackground(colorWhite);
        Button[] radioButtons = field.getRadioButtons();
        if (radioButtons != null) {
            for (int i = 0; i < radioButtons.length; ++i) {
                radioButtons[i].setBackground(colorWhite);
            }
        }
        return level;
    }

    public String setField(StringFieldEditor field, Composite composite) {
        String level = field.getPreferencesLevel();
        if ("project".equals(level) && this.service.getProject() == null) {
            if (composite.isDisposed()) {
                System.err.println("PreferencesUtilities.setField():  composite is disposed");
            }
            field.setFieldValueFromOutside(null);
            if (!composite.isDisposed()) {
                field.getTextControl(composite).setBackground(colorBluish);
            }
            return "project";
        }
        String levelFromWhichSet = field.loadWithInheritance();
        if (!composite.isDisposed()) {
            if (field.isInherited()) {
                field.getTextControl(composite).setBackground(colorBluish);
            } else {
                field.getTextControl(composite).setBackground(colorWhite);
            }
        }
        return levelFromWhichSet;
    }

    public String setField(StringFieldEditor field, Composite composite, String value) {
        String whoiam = "PreferencesUtilities.setField(StringFieldEditor field, composite, value):  ";
        this.checkArgs(field, composite, (Object)value, "PreferencesUtilities.setField(StringFieldEditor field, composite, value):  ");
        if (!field.getTextControl(composite).getEditable()) {
            throw new IllegalStateException("PreferencesUtilities.setField(StringFieldEditor field, composite, value):  field is not editable");
        }
        if (value.equals("") && !field.isEmptyValueAllowed()) {
            throw new IllegalArgumentException("PreferencesUtilities.setField(StringFieldEditor field, composite, value):  value is empty and field does not allow empty values");
        }
        String level = field.getPreferencesLevel();
        field.setFieldValueFromOutside(value);
        field.getTextControl(composite).setBackground(colorWhite);
        return level;
    }

    public String setField(FontFieldEditor field, Composite parent) {
        String level = field.getPreferencesLevel();
        if ("project".equals(level) && this.service.getProject() == null) {
            if (parent == null) {
                System.err.println("PreferencesUtilities.setField():  parent is null");
            }
            if (parent.isDisposed()) {
                System.err.println("PreferencesUtilities.setField():  parent is disposed");
            }
            field.setFieldValueFromOutside(null);
            if (!parent.isDisposed()) {
                field.getChangeControl().setEnabled(false);
                field.getChangeControl().setBackground(colorBluish);
            }
            return "project";
        }
        String levelFromWhichSet = field.loadWithInheritance();
        if (parent != null && !parent.isDisposed()) {
            if (level != null && level.equals(levelFromWhichSet)) {
                field.getChangeControl().setBackground(colorWhite);
            } else if (level != null && field.getChangeControl().getEnabled()) {
                field.getChangeControl().setBackground(colorBluish);
            }
        }
        return levelFromWhichSet;
    }

    public String setField(ColorFieldEditor field, Composite parent) {
        String level = field.getPreferencesLevel();
        if ("project".equals(level) && this.service.getProject() == null) {
            if (parent == null) {
                System.err.println("PreferencesUtilities.setField():  parent is null");
            }
            if (parent.isDisposed()) {
                System.err.println("PreferencesUtilities.setField():  parent is disposed");
            }
            field.setFieldValueFromOutside(null);
            if (!parent.isDisposed()) {
                field.getColorSelector().setEnabled(false);
                field.getLabelControl(parent).setBackground(colorBluish);
            }
            return "project";
        }
        String levelFromWhichSet = field.loadWithInheritance();
        if (parent != null && !parent.isDisposed()) {
            if (level != null && level.equals(levelFromWhichSet)) {
                field.getLabelControl(parent).setBackground(colorWhite);
            } else if (level != null && field.getLabelControl(parent).getEnabled()) {
                field.getLabelControl(parent).setBackground(colorBluish);
            }
        }
        return levelFromWhichSet;
    }

    protected void initializeField(FieldEditor pe, PreferencePage page) {
        if (page instanceof IPropertyChangeListener) {
            pe.setPropertyChangeListener((IPropertyChangeListener)page);
        }
        pe.setPreferenceStore(page.getPreferenceStore());
    }

    public BooleanFieldEditor makeNewBooleanField(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String key, String text, String toolTip, Composite parent, boolean isEnabled, boolean isEditable, boolean hasSpecialValue, boolean specialValue, boolean emptyValueAllowed, boolean emptyValue, boolean isRemovable) {
        Composite fieldHolder = new Composite(parent, 0);
        fieldHolder.setLayoutData((Object)new GridData(768));
        BooleanFieldEditor field = new BooleanFieldEditor(page, tab, service, level, key, text, fieldHolder);
        field.setToolTipText(toolTip);
        if (level != null && level.equals("project") && service.getProject() != null) {
            this.setField(field, fieldHolder);
            this.addBooleanPropertyChangeListeners(service, level, field, key, fieldHolder);
        } else {
            this.setField(field, fieldHolder);
            this.addBooleanPropertyChangeListeners(service, level, field, key, fieldHolder);
        }
        field.getChangeControl().setEnabled(isEnabled);
        if (!hasSpecialValue) {
            field.setNoSpecialValue();
        } else {
            field.setSpecialValue(specialValue);
        }
        if (level == null) {
            field.setRemovable(false);
        } else if (level.equals("default")) {
            field.setRemovable(false);
        } else {
            field.setRemovable(isRemovable);
        }
        this.initializeField(field, page);
        return field;
    }

    public ComboFieldEditor makeNewComboField(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, String toolTip, int numColumns, String[] valueList, String[] labelList, Composite parent, boolean isEnabled, boolean isRemovable) {
        Composite fieldHolder = new Composite(parent, 0);
        fieldHolder.setLayoutData((Object)new GridData(768));
        boolean onProjectLevelWithNullProject = level != null && level.equals("project") && service.getProject() == null;
        ComboFieldEditor field = new ComboFieldEditor(page, tab, service, level, name, labelText, valueList, labelList, numColumns, fieldHolder, isEnabled, isRemovable);
        field.setToolTipText(toolTip);
        if (!onProjectLevelWithNullProject) {
            this.setField(field, fieldHolder);
            this.addComboPropertyChangeListeners(service, level, field, name, fieldHolder);
        }
        field.setEnabled(isEnabled, fieldHolder);
        if (level == null) {
            field.setRemovable(false);
        } else if (level.equals("default")) {
            field.setRemovable(false);
        } else {
            field.setRemovable(isRemovable);
        }
        return field;
    }

    public void setupStringButtonField(StringButtonFieldEditor field, PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String key, String text, String toolTip, boolean isEnabled, boolean isEditable, boolean emptyValueAllowed, String emptyValue, boolean isRemovable) {
        this.setupStringField(field, page, tab, service, level, key, text, toolTip, isEnabled, isEditable, emptyValueAllowed, emptyValue, isRemovable);
        field.getChangeControl(field.getParent()).setEnabled(isEnabled);
    }

    public void setupStringField(StringFieldEditor field, PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String key, String text, String toolTip, boolean isEnabled, boolean isEditable, boolean emptyValueAllowed, String emptyValue, boolean isRemovable) {
        Composite fieldHolder = field.getParent();
        boolean onProjectLevelWithNullProject = "project".equals(level) && service.getProject() == null;
        boolean notOnARealLevel = level == null;
        boolean onAFunctioningLevel = !onProjectLevelWithNullProject && notOnARealLevel;
        field.setToolTipText(toolTip);
        if (!onProjectLevelWithNullProject) {
            this.setField(field, fieldHolder);
            this.addStringPropertyChangeListeners(service, level, field, key, fieldHolder);
        }
        Text textControl = field.getTextControl();
        textControl.setEnabled(isEnabled);
        if (onProjectLevelWithNullProject || notOnARealLevel) {
            textControl.setEditable(false);
        } else if (onAFunctioningLevel) {
            textControl.setEditable(isEditable);
        }
        field.setNoSpecialValue();
        field.setEmptyValueAllowed(emptyValueAllowed);
        if (level == null) {
            field.setRemovable(false);
        } else if (level.equals("default")) {
            field.setRemovable(false);
        } else {
            field.setRemovable(isRemovable);
        }
    }

    public FileFieldEditor makeNewFileField(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String key, String text, String toolTip, Composite parent, boolean isEnabled, boolean isEditable, boolean hasSpecialValue, String specialValue, boolean emptyValueAllowed, String emptyValue, boolean isRemovable) {
        Composite fieldHolder = new Composite(parent, 0);
        fieldHolder.setLayoutData((Object)new GridData(768));
        FileFieldEditor field = new FileFieldEditor(page, tab, service, level, key, text, fieldHolder);
        this.setupStringButtonField(field, page, tab, service, level, key, text, toolTip, isEnabled, isEditable, emptyValueAllowed, emptyValue, isRemovable);
        return field;
    }

    public DirectoryFieldEditor makeNewDirectoryField(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String key, String text, String toolTip, Composite parent, boolean isEnabled, boolean isEditable, boolean hasSpecialValue, String specialValue, boolean emptyValueAllowed, String emptyValue, boolean isRemovable) {
        Composite fieldHolder = new Composite(parent, 0);
        fieldHolder.setLayoutData((Object)new GridData(768));
        DirectoryFieldEditor field = new DirectoryFieldEditor(page, tab, service, level, key, text, fieldHolder);
        this.setupStringButtonField(field, page, tab, service, level, key, text, toolTip, isEnabled, isEditable, emptyValueAllowed, emptyValue, isRemovable);
        return field;
    }

    public DirectoryListFieldEditor makeNewDirectoryListField(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String key, String text, String toolTip, Composite parent, boolean isEnabled, boolean isEditable, boolean hasSpecialValue, String specialValue, boolean emptyValueAllowed, String emptyValue, boolean isRemovable) {
        Composite fieldHolder = new Composite(parent, 0);
        fieldHolder.setLayoutData((Object)new GridData(768));
        DirectoryListFieldEditor field = new DirectoryListFieldEditor(page, tab, service, level, key, text, fieldHolder);
        this.setupStringButtonField(field, page, tab, service, level, key, text, toolTip, isEnabled, isEditable, emptyValueAllowed, emptyValue, isRemovable);
        return field;
    }

    public IntegerFieldEditor makeNewIntegerField(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String key, String text, String toolTip, Composite parent, boolean isEnabled, boolean isEditable, boolean hasSpecialValue, String specialValue, boolean emptyValueAllowed, String emptyValue, boolean isRemovable) {
        Composite fieldHolder = new Composite(parent, 0);
        fieldHolder.setLayoutData((Object)new GridData(768));
        IntegerFieldEditor field = new IntegerFieldEditor(page, tab, service, level, key, text, fieldHolder);
        this.setupStringField(field, page, tab, service, level, key, text, toolTip, isEnabled, isEditable, emptyValueAllowed, emptyValue, isRemovable);
        this.initializeField(field, page);
        return field;
    }

    public DoubleFieldEditor makeNewDoubleField(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String key, String text, String toolTip, Composite parent, boolean isEnabled, boolean isEditable, boolean emptyValueAllowed, String emptyValue, boolean isRemovable) {
        Composite fieldHolder = new Composite(parent, 0);
        fieldHolder.setLayoutData((Object)new GridData(768));
        DoubleFieldEditor field = new DoubleFieldEditor(page, tab, service, level, key, text, fieldHolder);
        this.setupStringField(field, page, tab, service, level, key, text, toolTip, isEnabled, isEditable, emptyValueAllowed, emptyValue, isRemovable);
        this.initializeField(field, page);
        return field;
    }

    public FontFieldEditor makeNewFontField(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String key, String text, String toolTip, Composite parent, boolean isEnabled, boolean isEditable, boolean isRemovable) {
        Composite fieldHolder = new Composite(parent, 0);
        fieldHolder.setLayoutData((Object)new GridData(768));
        boolean onProjectLevelWithNullProject = level != null && level.equals("project") && service.getProject() == null;
        boolean notOnARealLevel = level == null;
        boolean onAFunctioningLevel = !onProjectLevelWithNullProject && !notOnARealLevel;
        FontFieldEditor field = new FontFieldEditor(page, tab, service, level, key, text, fieldHolder);
        field.setToolTipText(toolTip);
        if (!onProjectLevelWithNullProject) {
            this.setField(field, fieldHolder);
            this.addFontPropertyChangeListeners(service, level, field, key, fieldHolder);
        }
        if (onProjectLevelWithNullProject || notOnARealLevel) {
            field.getPreviewControl().setEnabled(false);
            field.setEnabled(false, field.getParent());
        } else if (onAFunctioningLevel) {
            field.getPreviewControl().setEnabled(isEnabled);
            field.setEnabled(isEnabled, field.getParent());
        }
        if (level == null) {
            field.setRemovable(false);
        } else if (level.equals("default")) {
            field.setRemovable(false);
        } else {
            field.setRemovable(isRemovable);
        }
        this.initializeField(field, page);
        return field;
    }

    public ColorFieldEditor makeNewColorField(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String key, String text, String toolTip, Composite parent, boolean isEnabled, boolean isEditable, boolean isRemovable) {
        Composite fieldHolder = new Composite(parent, 0);
        fieldHolder.setLayoutData((Object)new GridData(768));
        boolean onProjectLevelWithNullProject = level != null && level.equals("project") && service.getProject() == null;
        boolean notOnARealLevel = level == null;
        boolean onAFunctioningLevel = !onProjectLevelWithNullProject && !notOnARealLevel;
        ColorFieldEditor field = new ColorFieldEditor(page, tab, service, level, key, text, fieldHolder);
        field.setToolTipText(toolTip);
        if (!onProjectLevelWithNullProject) {
            this.setField(field, fieldHolder);
            this.addColorPropertyChangeListeners(service, level, field, key, fieldHolder);
        }
        if (onProjectLevelWithNullProject || notOnARealLevel) {
            field.getColorSelector().setEnabled(false);
            field.setEnabled(false, field.getParent());
        } else if (onAFunctioningLevel) {
            field.getColorSelector().setEnabled(isEnabled);
            field.setEnabled(isEnabled, field.getParent());
        }
        if (level == null) {
            field.setRemovable(false);
        } else if (level.equals("default")) {
            field.setRemovable(false);
        } else {
            field.setRemovable(isRemovable);
        }
        this.initializeField(field, page);
        return field;
    }

    public RadioGroupFieldEditor makeNewRadioGroupField(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, String toolTip, int numColumns, String[] values, String[] labels, Composite parent, boolean useGroup, boolean isEnabled, boolean isRemovable) {
        boolean onProjectLevelWithNullProject = level != null && level.equals("project") && service.getProject() == null;
        boolean notOnARealLevel = level == null;
        boolean onAFunctioningLevel = !onProjectLevelWithNullProject && !notOnARealLevel;
        RadioGroupFieldEditor field = new RadioGroupFieldEditor(page, tab, service, level, name, labelText, numColumns, values, labels, parent, useGroup);
        field.setToolTipText(toolTip);
        if (!onProjectLevelWithNullProject) {
            this.setField(field, parent);
            this.addRadioGroupPropertyChangeListeners(service, level, field, name, parent);
        }
        if (onProjectLevelWithNullProject || notOnARealLevel) {
            if (useGroup) {
                Group radioGroup = (Group)field.getRadioBoxControl();
                radioGroup.setEnabled(false);
            }
            field.setEnabled(false, parent);
        } else if (onAFunctioningLevel) {
            if (useGroup) {
                Group radioGroup = (Group)field.getRadioBoxControl();
                radioGroup.setEnabled(isEnabled);
            }
            field.setEnabled(isEnabled, parent);
        }
        if (level == null) {
            field.setRemovable(false);
        } else if (level.equals("default")) {
            field.setRemovable(false);
        } else {
            field.setRemovable(isRemovable);
        }
        return field;
    }

    public StringFieldEditor makeNewStringField(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String key, String text, String toolTip, Composite parent, boolean isEnabled, boolean isEditable, boolean hasSpecialValue, String specialValue, boolean emptyValueAllowed, String emptyValue, boolean isRemovable) {
        Composite fieldHolder = new Composite(parent, 0);
        fieldHolder.setLayoutData((Object)new GridData(768));
        boolean onProjectLevelWithNullProject = level != null && level.equals("project") && service.getProject() == null;
        boolean notOnARealLevel = level == null;
        boolean onAFunctioningLevel = !onProjectLevelWithNullProject && !notOnARealLevel;
        StringFieldEditor field = new StringFieldEditor(page, tab, service, level, key, text, fieldHolder);
        field.setToolTipText(toolTip);
        if (!onProjectLevelWithNullProject) {
            this.setField(field, fieldHolder);
            this.addStringPropertyChangeListeners(service, level, field, key, fieldHolder);
        }
        if (onProjectLevelWithNullProject || notOnARealLevel) {
            field.getTextControl().setEnabled(false);
            field.getTextControl().setEditable(false);
            field.setEnabled(false, field.getParent());
        } else if (onAFunctioningLevel) {
            field.getTextControl().setEnabled(isEnabled);
            field.getTextControl().setEditable(isEditable);
            field.setEnabled(isEnabled, field.getParent());
        }
        if (hasSpecialValue) {
            field.setSpecialValue(specialValue);
        } else {
            field.setNoSpecialValue();
        }
        field.setEmptyValueAllowed(emptyValueAllowed);
        if (level == null) {
            field.setRemovable(false);
        } else if (level.equals("default")) {
            field.setRemovable(false);
        } else {
            field.setRemovable(isRemovable);
        }
        this.initializeField(field, page);
        return field;
    }

    public StringFieldEditor makeNewModifiedMarkField(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String key, String text, Composite parent) {
        Composite fieldHolder = new Composite(parent, 0);
        fieldHolder.setLayoutData((Object)new GridData(768));
        StringFieldEditor field = new StringFieldEditor(page, tab, service, level, key + "Marker", "", 1, fieldHolder);
        return field;
    }

    private void addBooleanPropertyChangeListeners(IPreferencesService service, String level, BooleanFieldEditor field, String key, Composite composite) {
        int levelIndex = service.getIndexForLevel(level);
        IEclipsePreferences[] nodes = service.getNodesForLevels();
        for (int i = levelIndex + 1; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            nodes[i].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new BooleanPreferenceChangeListener(field, key, composite));
        }
    }

    protected void addComboPropertyChangeListeners(IPreferencesService service, String level, ComboFieldEditor field, String key, Composite composite) {
        int levelIndex = service.getIndexForLevel(level);
        IEclipsePreferences[] nodes = service.getNodesForLevels();
        for (int i = levelIndex + 1; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            nodes[i].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new ComboPreferenceChangeListener(field, key, composite));
        }
    }

    protected void addRadioGroupPropertyChangeListeners(IPreferencesService service, String level, RadioGroupFieldEditor field, String key, Composite composite) {
        int levelIndex = service.getIndexForLevel(level);
        IEclipsePreferences[] nodes = service.getNodesForLevels();
        for (int i = levelIndex + 1; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            nodes[i].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new RadioGroupPreferenceChangeListener(field, key, composite));
        }
    }

    protected void addStringPropertyChangeListeners(IPreferencesService service, String level, StringFieldEditor field, String key, Composite composite) {
        int levelIndex = service.getIndexForLevel(level);
        IEclipsePreferences[] nodes = service.getNodesForLevels();
        for (int i = levelIndex + 1; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            nodes[i].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new StringPreferenceChangeListener(field, key, composite));
        }
    }

    protected void addFontPropertyChangeListeners(IPreferencesService service, String level, FontFieldEditor field, String key, Composite composite) {
        int levelIndex = service.getIndexForLevel(level);
        IEclipsePreferences[] nodes = service.getNodesForLevels();
        for (int i = levelIndex + 1; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            nodes[i].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new FontPreferenceChangeListener(field, key, composite));
        }
    }

    protected void addColorPropertyChangeListeners(IPreferencesService service, String level, ColorFieldEditor field, String key, Composite composite) {
        int levelIndex = service.getIndexForLevel(level);
        IEclipsePreferences[] nodes = service.getNodesForLevels();
        for (int i = levelIndex + 1; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            nodes[i].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new ColorPreferenceChangeListener(field, key, composite));
        }
    }

    public boolean firstLevelAboveSecond(String first, String second) {
        return this.service.indexForLevel(first) > this.service.indexForLevel(second);
    }

    public void createToggleFieldListener(BooleanFieldEditor booleanField, StringFieldEditor stringField, boolean sense) {
        this.createFieldControlToggle(booleanField, stringField, sense);
        this.createFieldStateToggle(booleanField, stringField, sense);
    }

    public FieldControlToggleListener createFieldControlToggle(BooleanFieldEditor booleanField, StringFieldEditor stringField, boolean sense) {
        FieldControlToggleListener listener = new FieldControlToggleListener(booleanField, stringField, sense);
        booleanField.getChangeControl().addSelectionListener((SelectionListener)listener);
        return listener;
    }

    public FieldStateToggleListener createFieldStateToggle(BooleanFieldEditor booleanField, StringFieldEditor stringField, boolean sense) {
        FieldStateToggleListener listener = new FieldStateToggleListener(booleanField, stringField, sense);
        booleanField.setPropertyChangeListener(listener);
        return listener;
    }

    public Link createDetailsLink(Composite parent, final BooleanFieldEditor field, final Composite fieldHolder, String text) {
        Composite detailsHolder = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        detailsHolder.setLayout((Layout)gl);
        Link link = new Link(detailsHolder, 0);
        link.setFont(detailsHolder.getFont());
        link.setText("<A>" + text + "</A>");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class DetailsLinkListener
        implements SelectionListener {
            DetailsLinkListener() {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtilities.this.doDetailsLinkActivated((Link)e.widget, field, fieldHolder);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PreferencesUtilities.this.doDetailsLinkActivated((Link)e.widget, field, fieldHolder);
            }
        }
        DetailsLinkListener detailsLinkListener = new DetailsLinkListener();
        link.addSelectionListener((SelectionListener)detailsLinkListener);
        return link;
    }

    public Link createDetailsLink(Composite detailsHolder, final ComboFieldEditor field, final Composite fieldHolder, String text) {
        Link link = new Link(detailsHolder, 0);
        link.setFont(detailsHolder.getFont());
        link.setText("  <A>" + text + "</A>");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class DetailsLinkListener
        implements SelectionListener {
            DetailsLinkListener(Composite fieldHolder2) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtilities.this.doDetailsLinkActivated((Link)e.widget, field, fieldHolder);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PreferencesUtilities.this.doDetailsLinkActivated((Link)e.widget, field, fieldHolder);
            }
        }
        DetailsLinkListener detailsLinkListener = new DetailsLinkListener(detailsHolder);
        link.addSelectionListener((SelectionListener)detailsLinkListener);
        return link;
    }

    public Link createDetailsLink(Composite detailsHolder, final RadioGroupFieldEditor field, final Composite fieldHolder, String text) {
        Link link = new Link(detailsHolder, 0);
        link.setFont(detailsHolder.getFont());
        link.setText("  <A>" + text + "</A>");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class DetailsLinkListener
        implements SelectionListener {
            DetailsLinkListener(Composite fieldHolder2) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtilities.this.doDetailsLinkActivated((Link)e.widget, field, fieldHolder);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PreferencesUtilities.this.doDetailsLinkActivated((Link)e.widget, field, fieldHolder);
            }
        }
        DetailsLinkListener detailsLinkListener = new DetailsLinkListener(detailsHolder);
        link.addSelectionListener((SelectionListener)detailsLinkListener);
        return link;
    }

    public Link createDetailsLink(Composite detailsHolder, final StringFieldEditor field, final Composite fieldHolder, String text) {
        Link link = new Link(detailsHolder, 0);
        link.setFont(detailsHolder.getFont());
        link.setText("  <A>" + text + "</A>");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class DetailsLinkListener
        implements SelectionListener {
            DetailsLinkListener(Composite fieldHolder2) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtilities.this.doDetailsLinkActivated((Link)e.widget, field, fieldHolder);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PreferencesUtilities.this.doDetailsLinkActivated((Link)e.widget, field, fieldHolder);
            }
        }
        DetailsLinkListener detailsLinkListener = new DetailsLinkListener(detailsHolder);
        link.addSelectionListener((SelectionListener)detailsLinkListener);
        return link;
    }

    public Link createDetailsLinkDefault(Composite detailsHolder, final BooleanFieldEditor field, final Composite fieldHolder, String text) {
        Link link = new Link(detailsHolder, 0);
        link.setFont(detailsHolder.getFont());
        link.setText("<A>" + text + "</A>");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class DetailsLinkListener
        implements SelectionListener {
            DetailsLinkListener(Composite fieldHolder2) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtilities.this.doDetailsLinkActivated((Link)e.widget, field, fieldHolder);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PreferencesUtilities.this.doDetailsLinkActivated((Link)e.widget, field, fieldHolder);
            }
        }
        DetailsLinkListener detailsLinkListener = new DetailsLinkListener(detailsHolder);
        link.addSelectionListener((SelectionListener)detailsLinkListener);
        return link;
    }

    public Link createDetailsLink(Composite detailsHolder, final FontFieldEditor field, final Composite fieldHolder, String text) {
        Link link = new Link(detailsHolder, 0);
        link.setFont(detailsHolder.getFont());
        link.setText("  <A>" + text + "</A>");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class DetailsLinkListener
        implements SelectionListener {
            DetailsLinkListener(Composite fieldHolder2) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtilities.this.doDetailsLinkActivated((Link)e.widget, field, fieldHolder);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PreferencesUtilities.this.doDetailsLinkActivated((Link)e.widget, field, fieldHolder);
            }
        }
        DetailsLinkListener detailsLinkListener = new DetailsLinkListener(detailsHolder);
        link.addSelectionListener((SelectionListener)detailsLinkListener);
        return link;
    }

    final void doDetailsLinkActivated(Link link, BooleanFieldEditor field, Composite fieldHolder) {
        DetailsDialogForBooleanFields dialog = new DetailsDialogForBooleanFields(fieldHolder.getShell(), field, fieldHolder, this.service);
        dialog.open();
    }

    final void doDetailsLinkActivated(Link link, ComboFieldEditor field, Composite fieldHolder) {
        DetailsDialogForComboFields dialog = new DetailsDialogForComboFields(fieldHolder.getShell(), field, fieldHolder, this.service);
        dialog.open();
    }

    final void doDetailsLinkActivated(Link link, RadioGroupFieldEditor field, Composite fieldHolder) {
        DetailsDialogForRadioGroupFields dialog = new DetailsDialogForRadioGroupFields(fieldHolder.getShell(), field, fieldHolder, this.service);
        dialog.open();
    }

    void doDetailsLinkActivated(Link link, StringFieldEditor field, Composite fieldHolder) {
        DetailsDialogForStringFields dialog = new DetailsDialogForStringFields(fieldHolder.getShell(), field, fieldHolder, this.service);
        dialog.open();
    }

    final void doDetailsLinkActivated(Link link, FontFieldEditor field, Composite fieldHolder) {
        DetailsDialogForFontFields dialog = new DetailsDialogForFontFields(fieldHolder.getShell(), field, fieldHolder, this.service);
        dialog.open();
    }

    final void doDetailsLinkActivated(Link link, ColorFieldEditor field, Composite fieldHolder) {
        DetailsDialogForColorFields dialog = new DetailsDialogForColorFields(fieldHolder.getShell(), field, fieldHolder, this.service);
        dialog.open();
    }

    public Control[] createDefaultAndApplyButtons(Composite parent, final PreferencesTab buttonHolder) {
        Composite buttonBar = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        buttonBar.setLayout((Layout)layout);
        GridData bbgd = new GridData(0x1000008);
        buttonBar.setLayoutData((Object)bbgd);
        boolean createDefaultAndApplyButton = true;
        if (createDefaultAndApplyButton) {
            layout.numColumns += 2;
            String[] labels = JFaceResources.getStrings((String[])new String[]{"defaults", "apply"});
            Button defaultsButton = new Button(buttonBar, 8);
            defaultsButton.setText(labels[0]);
            Dialog.applyDialogFont((Control)defaultsButton);
            GridData data = new GridData(256);
            Point minButtonSize = defaultsButton.computeSize(-1, -1, true);
            defaultsButton.setLayoutData((Object)data);
            defaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    buttonHolder.performDefaults();
                }
            });
            Button applyButton = new Button(buttonBar, 8);
            applyButton.setText(labels[1]);
            Dialog.applyDialogFont((Control)applyButton);
            data = new GridData(256);
            minButtonSize = applyButton.computeSize(-1, -1, true);
            applyButton.setLayoutData((Object)data);
            applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    buttonHolder.performApply();
                }
            });
            Dialog.applyDialogFont((Control)buttonBar);
        } else if (buttonBar.getChildren().length < 1) {
            buttonBar.dispose();
        }
        return buttonBar.getChildren();
    }

    public static void fillGridPlace(Composite composite, int num) {
        for (int i = 1; i <= num; ++i) {
            Label label = new Label(composite, 0);
            label.setText("This space intentionally left blank");
            label.setVisible(false);
        }
    }

    public class FieldStateToggleListener
    implements IPropertyChangeListener {
        public BooleanFieldEditor booleanField = null;
        public StringFieldEditor stringField = null;
        boolean sense = true;

        public FieldStateToggleListener(BooleanFieldEditor booleanField, StringFieldEditor stringField, boolean sense) {
            this.booleanField = booleanField;
            this.stringField = stringField;
            this.sense = sense;
        }

        public void propertyChange(PropertyChangeEvent event) {
            boolean value = (Boolean)event.getNewValue();
            value = this.sense ? value : !value;
            this.stringField.getTextControl().setEditable(value);
            this.stringField.getTextControl().setEnabled(value);
            this.stringField.setEnabled(value, this.stringField.getParent());
        }
    }

    public class FieldControlToggleListener
    implements SelectionListener {
        public BooleanFieldEditor booleanField = null;
        public StringFieldEditor stringField = null;
        boolean sense = true;

        public FieldControlToggleListener(BooleanFieldEditor booleanField, StringFieldEditor stringField, boolean sense) {
            this.booleanField = booleanField;
            this.stringField = stringField;
            this.sense = sense;
        }

        public void widgetSelected(SelectionEvent e) {
            boolean value = this.booleanField.getBooleanValue();
            value = this.sense ? value : !value;
            this.stringField.getTextControl().setEditable(value);
            this.stringField.getTextControl().setEnabled(value);
            this.stringField.setEnabled(value, this.stringField.getParent());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            boolean value = this.booleanField.getBooleanValue();
            value = this.sense ? value : !value;
            this.stringField.getTextControl().setEditable(value);
            this.stringField.getTextControl().setEnabled(value);
            this.stringField.setEnabled(value, this.stringField.getParent());
        }
    }

    public class ColorPreferenceChangeListener
    extends PreferenceChangeListener {
        public ColorPreferenceChangeListener(FieldEditor field, String key, Composite composite) {
            super(field, key, composite);
        }

        protected void setFieldByListener(FieldEditor field, Composite composite) {
            PreferencesUtilities.this.setField((ColorFieldEditor)field, composite);
        }
    }

    public class FontPreferenceChangeListener
    extends PreferenceChangeListener {
        public FontPreferenceChangeListener(FieldEditor field, String key, Composite composite) {
            super(field, key, composite);
        }

        protected void setFieldByListener(FieldEditor field, Composite composite) {
            PreferencesUtilities.this.setField((FontFieldEditor)field, composite);
        }
    }

    public class StringPreferenceChangeListener
    extends PreferenceChangeListener {
        public StringPreferenceChangeListener(FieldEditor field, String key, Composite composite) {
            super(field, key, composite);
        }

        protected void setFieldByListener(FieldEditor field, Composite composite) {
            PreferencesUtilities.this.setField((StringFieldEditor)field, composite);
        }
    }

    public class RadioGroupPreferenceChangeListener
    extends PreferenceChangeListener {
        public RadioGroupPreferenceChangeListener(FieldEditor field, String key, Composite composite) {
            super(field, key, composite);
        }

        protected void setFieldByListener(FieldEditor field, Composite composite) {
            PreferencesUtilities.this.setField((RadioGroupFieldEditor)field, composite);
        }
    }

    public class ComboPreferenceChangeListener
    extends PreferenceChangeListener {
        public ComboPreferenceChangeListener(FieldEditor field, String key, Composite composite) {
            super(field, key, composite);
        }

        protected void setFieldByListener(FieldEditor field, Composite composite) {
            PreferencesUtilities.this.setField((ComboFieldEditor)field, composite);
        }
    }

    public class BooleanPreferenceChangeListener
    extends PreferenceChangeListener {
        public BooleanPreferenceChangeListener(FieldEditor field, String key, Composite composite) {
            super(field, key, composite);
        }

        protected void setFieldByListener(FieldEditor field, Composite composite) {
            PreferencesUtilities.this.setField((BooleanFieldEditor)field, composite);
        }
    }

    public abstract class PreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        Composite composite = null;
        String key = null;
        FieldEditor field = null;

        public PreferenceChangeListener(FieldEditor field, String key, Composite composite) {
            this.field = field;
            this.key = key;
            this.composite = composite;
            if (!field.getParent().equals(composite)) {
                System.err.println("PreferencesUtilities.PreferenceChangeListener():  field and composite don't match!");
                System.err.println("\tfield = " + field.getLabelText());
            }
        }

        protected abstract void setFieldByListener(FieldEditor var1, Composite var2);

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!event.getKey().equals(this.key)) {
                return;
            }
            if (event.getNewValue() == null && event.getOldValue() == null) {
                return;
            }
            if (event.getNewValue() != null && event.getNewValue().equals(event.getOldValue())) {
                return;
            }
            String fieldLevel = this.field.getPreferencesLevel();
            String eventLevel = event.getNode().parent().name();
            String levelAtWhichSet = this.field.getLevelFromWhichLoaded();
            if (levelAtWhichSet != null && PreferencesUtilities.this.firstLevelAboveSecond(eventLevel, levelAtWhichSet)) {
                return;
            }
            if (!(this.composite.isDisposed() || "project".equals(fieldLevel) && PreferencesUtilities.this.service.getProject() == null)) {
                this.setFieldByListener(this.field, this.field.getParent());
            }
        }
    }
}

