/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.ui.textPresentation;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.ui.textPresentation.HTML2TextReader;
import org.eclipse.imp.ui.textPresentation.LineBreakingReader;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class HTMLTextPresenter
implements DefaultInformationControl.IInformationPresenter,
DefaultInformationControl.IInformationPresenterExtension {
    private static final String LINE_DELIM = System.getProperty("line.separator", "\n");
    private int fCounter;
    private boolean fEnforceUpperLineLimit;
    private boolean fUseBoldFont = false;

    public HTMLTextPresenter(boolean enforceUpperLineLimit) {
        this.fEnforceUpperLineLimit = enforceUpperLineLimit;
    }

    public HTMLTextPresenter() {
        this(true);
    }

    protected HTML2TextReader createReader(String hoverInfo, TextPresentation presentation) {
        return new HTML2TextReader(new StringReader(hoverInfo), presentation);
    }

    protected void adaptTextPresentation(TextPresentation presentation, int offset, int insertLength) {
        int yoursStart = offset;
        int yoursEnd = offset + insertLength - 1;
        yoursEnd = Math.max(yoursStart, yoursEnd);
        Iterator e = presentation.getAllStyleRangeIterator();
        while (e.hasNext()) {
            StyleRange range = (StyleRange)e.next();
            int myStart = range.start;
            int myEnd = range.start + range.length - 1;
            if ((myEnd = Math.max(myStart, myEnd)) < yoursStart) continue;
            if (myStart < yoursStart) {
                range.length += insertLength;
                continue;
            }
            range.start += insertLength;
        }
    }

    private void append(StringBuffer buffer, String string, TextPresentation presentation) {
        int length = string.length();
        buffer.append(string);
        if (presentation != null) {
            this.adaptTextPresentation(presentation, this.fCounter, length);
        }
        this.fCounter += length;
    }

    private String getIndent(String line) {
        int i;
        int length = line.length();
        for (i = 0; i < length && Character.isWhitespace(line.charAt(i)); ++i) {
        }
        return (i == length ? line : line.substring(0, i)) + " ";
    }

    public String updatePresentation(Display display, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        return this.updatePresentation((Drawable)display, hoverInfo, presentation, maxWidth, maxHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updatePresentation(Drawable drawable, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        if (hoverInfo == null) {
            return null;
        }
        GC gc = new GC(drawable);
        Font font = null;
        if (this.fUseBoldFont) {
            font = gc.getFont();
            FontData[] fontData = font.getFontData();
            for (int i = 0; i < fontData.length; ++i) {
                fontData[i].setStyle(1);
            }
            font = new Font(gc.getDevice(), fontData);
            gc.setFont(font);
        }
        try {
            StringBuffer buffer = new StringBuffer();
            this.fCounter = 0;
            LineBreakingReader reader = new LineBreakingReader(this.createReader(hoverInfo, presentation), gc, maxWidth);
            boolean lastLineFormatted = false;
            String lastLineIndent = null;
            String line = reader.readLine();
            boolean lineFormatted = reader.isFormattedLine();
            boolean firstLineProcessed = false;
            for (int maxNumberOfLines = Math.round((float)maxHeight / (float)gc.getFontMetrics().getHeight()); !(line == null || this.fEnforceUpperLineLimit && maxNumberOfLines <= 0); --maxNumberOfLines) {
                if (firstLineProcessed) {
                    if (!lastLineFormatted) {
                        this.append(buffer, LINE_DELIM, null);
                    } else {
                        this.append(buffer, LINE_DELIM, presentation);
                        if (lastLineIndent != null) {
                            this.append(buffer, lastLineIndent, presentation);
                        }
                    }
                }
                this.append(buffer, line, null);
                firstLineProcessed = true;
                lastLineFormatted = lineFormatted;
                if (!lineFormatted) {
                    lastLineIndent = null;
                } else if (lastLineIndent == null) {
                    lastLineIndent = this.getIndent(line);
                }
                line = reader.readLine();
                lineFormatted = reader.isFormattedLine();
            }
            if (line != null && buffer.length() > 0) {
                this.append(buffer, LINE_DELIM, (TextPresentation)(lineFormatted ? presentation : null));
                this.append(buffer, "...", presentation);
            }
            String string = this.trim(buffer, presentation);
            return string;
        }
        catch (IOException e) {
            RuntimePlugin.getInstance().logException("Exception in updatePresentation", e);
            String string = null;
            return string;
        }
        finally {
            if (font != null) {
                font.dispose();
            }
            gc.dispose();
        }
    }

    private String trim(StringBuffer buffer, TextPresentation presentation) {
        int start;
        int end;
        int length = buffer.length();
        for (end = length - 1; end >= 0 && Character.isWhitespace(buffer.charAt(end)); --end) {
        }
        if (end == -1) {
            return "";
        }
        if (end < length - 1) {
            buffer.delete(end + 1, length);
        } else {
            end = length;
        }
        for (start = 0; start < end && Character.isWhitespace(buffer.charAt(start)); ++start) {
        }
        buffer.delete(0, start);
        presentation.setResultWindow((IRegion)new Region(start, buffer.length()));
        return buffer.toString();
    }
}

