/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.imp.parser.IMessageHandlerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AnnotationCreator
implements IMessageHandlerExtension {
    private final ITextEditor fEditor;
    private final String fAnnotationType;
    private final List<PositionedMessage> fMessages = new LinkedList<PositionedMessage>();
    private final List<Annotation> fAnnotations = new LinkedList<Annotation>();

    public AnnotationCreator(ITextEditor textEditor, String annotationType) {
        this.fEditor = textEditor;
        this.fAnnotationType = annotationType == null ? "org.eclipse.imp.editor.parseAnnotation" : annotationType;
    }

    public void clearMessages() {
        this.removeAnnotations();
        this.fMessages.clear();
    }

    public void startMessageGroup(String groupName) {
    }

    public void endMessageGroup() {
    }

    public void handleSimpleMessage(String message, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine) {
        Position pos = new Position(startOffset, endOffset - startOffset + 1);
        this.fMessages.add(new PositionedMessage(message, pos));
    }

    public void endMessages() {
        IAnnotationModel model = this.fEditor.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension modelExt = (IAnnotationModelExtension)model;
            HashMap<Annotation, Position> newAnnotations = new HashMap<Annotation, Position>(this.fMessages.size());
            for (PositionedMessage pm : this.fMessages) {
                Annotation anno = new Annotation(this.fAnnotationType, false, pm.message);
                newAnnotations.put(anno, pm.pos);
                this.fAnnotations.add(anno);
            }
            modelExt.replaceAnnotations(null, newAnnotations);
        } else {
            for (PositionedMessage pm : this.fMessages) {
                Annotation annotation = new Annotation(this.fAnnotationType, false, pm.message);
                model.addAnnotation(annotation, pm.pos);
                this.fAnnotations.add(annotation);
            }
        }
        this.fMessages.clear();
    }

    private void removeAnnotations() {
        IDocumentProvider docProvider = this.fEditor.getDocumentProvider();
        if (docProvider == null) {
            return;
        }
        IAnnotationModel model = docProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model == null) {
            return;
        }
        if (model instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension modelExt = (IAnnotationModelExtension)model;
            Annotation[] allAnnotations = this.fAnnotations.toArray(new Annotation[this.fAnnotations.size()]);
            modelExt.replaceAnnotations(allAnnotations, Collections.EMPTY_MAP);
        } else {
            Iterator i = model.getAnnotationIterator();
            while (i.hasNext()) {
                Annotation a = (Annotation)i.next();
                if (!a.getType().equals(this.fAnnotationType)) continue;
                model.removeAnnotation(a);
            }
        }
        this.fAnnotations.clear();
    }

    private static class PositionedMessage {
        public final String message;
        public final Position pos;

        public PositionedMessage(String msg, Position pos) {
            this.message = msg;
            this.pos = pos;
        }
    }
}

