/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.builder;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IParseController;

public class MarkerCreator
implements IMessageHandler {
    protected IParseController parseController;
    protected IFile file;
    protected String problemType;

    public MarkerCreator(IFile file, IParseController parseController) {
        this(file, parseController, "org.eclipse.core.resources.problemmarker");
    }

    public MarkerCreator(IFile file, IParseController parseController, String problemType) {
        this.file = file;
        this.parseController = parseController;
        this.problemType = problemType;
    }

    public void clearMessages() {
    }

    public void handleSimpleMessage(String msg, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine) {
        try {
            IMarker m = this.file.createMarker(this.problemType);
            String[] attributeNames = new String[]{"lineNumber", "charStart", "charEnd", "message", "priority", "severity"};
            Object[] values = new Object[]{startLine, startOffset, endOffset, msg, 2, 2};
            m.setAttributes(attributeNames, values);
        }
        catch (CoreException e) {
            System.err.println("MarkerCreator.handleMessage:  CoreException trying to create marker");
        }
        catch (Exception e) {
            System.err.println("MarkerCreator.handleMessage:  Exception trying to create marker");
        }
    }

    public void endMessageGroup() {
    }

    public void startMessageGroup(String groupName) {
    }
}

