/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.ToggleBreakpointAction;
import org.eclipse.help.IContextProvider;
import org.eclipse.imp.actions.OpenAction;
import org.eclipse.imp.actions.QuickMenuAction;
import org.eclipse.imp.actions.RulerEnableDisableBreakpointAction;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.editor.EditorInputUtils;
import org.eclipse.imp.editor.FoldingActionGroup;
import org.eclipse.imp.editor.GotoMatchingFenceAction;
import org.eclipse.imp.editor.GotoNextTargetAction;
import org.eclipse.imp.editor.GotoPreviousTargetAction;
import org.eclipse.imp.editor.IProblemChangedListener;
import org.eclipse.imp.editor.IRegionSelectionService;
import org.eclipse.imp.editor.LanguageServiceManager;
import org.eclipse.imp.editor.OutlineInformationControl;
import org.eclipse.imp.editor.ParserScheduler;
import org.eclipse.imp.editor.SelectEnclosingAction;
import org.eclipse.imp.editor.ServiceControllerManager;
import org.eclipse.imp.editor.StructuredSourceViewer;
import org.eclipse.imp.editor.internal.AnnotationCreator;
import org.eclipse.imp.editor.internal.EditorErrorTickUpdater;
import org.eclipse.imp.editor.internal.FoldingController;
import org.eclipse.imp.editor.internal.ProblemMarkerManager;
import org.eclipse.imp.editor.internal.ToggleBreakpointsAdapter;
import org.eclipse.imp.help.IMPHelp;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferenceCache;
import org.eclipse.imp.preferences.PreferencesService;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.IASTFindReplaceTarget;
import org.eclipse.imp.services.IAnnotationTypeInfo;
import org.eclipse.imp.services.IDocumentationProvider;
import org.eclipse.imp.services.IEditorService;
import org.eclipse.imp.services.ILanguageActionsContributor;
import org.eclipse.imp.services.ILanguageSyntaxProperties;
import org.eclipse.imp.services.IOccurrenceMarker;
import org.eclipse.imp.services.IRefactoringContributor;
import org.eclipse.imp.services.IToggleBreakpointsHandler;
import org.eclipse.imp.services.ITokenColorer;
import org.eclipse.imp.services.base.DefaultAnnotationHover;
import org.eclipse.imp.services.base.TreeModelBuilderBase;
import org.eclipse.imp.ui.DefaultPartListener;
import org.eclipse.imp.ui.textPresentation.HTMLTextPresenter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class UniversalEditor
extends TextEditor
implements IASTFindReplaceTarget {
    public static final String FORMAT_SOURCE_COMMAND = "org.eclipse.imp.runtime.editor.formatSource";
    public static final String TOGGLE_COMMENT_COMMAND = "org.eclipse.imp.runtime.editor.toggleComment";
    public static final String SHOW_OUTLINE_COMMAND = "org.eclipse.imp.runtime.editor.showOutline";
    public static final String INDENT_SELECTION_COMMAND = "org.eclipse.imp.runtime.editor.indentSelection";
    public static final String SELECT_ENCLOSING_COMMAND = "org.eclipse.imp.runtime.editor.selectEnclosing";
    public static final String GOTO_MATCHING_FENCE_COMMAND = "org.eclipse.imp.runtime.editor.gotoMatchingFence";
    public static final String GOTO_PREVIOUS_TARGET_COMMAND = "org.eclipse.imp.runtime.editor.gotoPreviousTarget";
    public static final String GOTO_NEXT_TARGET_COMMAND = "org.eclipse.imp.runtime.editor.gotoNextTarget";
    public static final String MESSAGE_BUNDLE = "org.eclipse.imp.editor.messages";
    public static final String EDITOR_ID = "org.eclipse.imp.runtime.impEditor";
    public static final String PARSE_ANNOTATION_TYPE = "org.eclipse.imp.editor.parseAnnotation";
    protected static final String MATCHING_BRACKETS = "matchingBrackets";
    protected static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    public Language fLanguage;
    public ParserScheduler fParserScheduler;
    protected LanguageServiceManager fLanguageServiceManager;
    protected ServiceControllerManager fServiceControllerManager;
    private ProjectionAnnotationModel fAnnotationModel;
    private ProblemMarkerManager fProblemMarkerManager;
    private ICharacterPairMatcher fBracketMatcher;
    private SubActionBars fActionBars;
    private DefaultPartListener fRefreshContributions;
    private IPreferencesService fLangSpecificPrefs;
    private IPreferencesService.PreferenceServiceListener fFontListener;
    private IPreferencesService.PreferenceServiceListener fTabListener;
    private IPreferencesService.PreferenceServiceListener fSpacesForTabsListener;
    private IPropertyChangeListener fPropertyListener;
    private ToggleBreakpointAction fToggleBreakpointAction;
    private IAction fEnableDisableBreakpointAction;
    private ToggleBreakpointsAdapter fBreakpointHandler;
    private IResourceChangeListener fResourceListener;
    private IDocumentListener fDocumentListener;
    private FoldingActionGroup fFoldingActionGroup;
    private static final String BUNDLE_FOR_CONSTRUCTED_KEYS = "org.eclipse.imp.editor.messages";
    private static final String IMP_EDITOR_CONTEXT = "org.eclipse.imp.runtime.imp_editor_context";
    public static ResourceBundle fgBundleForConstructedKeys = ResourceBundle.getBundle("org.eclipse.imp.editor.messages");
    private QuickMenuAction fQuickAccessAction;
    private IHandlerActivation fQuickAccessHandlerActivation;
    private IHandlerService fHandlerService;
    private static final String QUICK_MENU_ID = "org.eclipse.imp.runtime.editor.refactor.quickMenu";
    private BracketInserter fBracketInserter;
    private final String CLOSE_FENCES = "closeFences";
    private static final int REPARSE_SCHEDULE_DELAY = 100;
    public final String PARSE_ANNOTATION = "Parse_Annotation";
    private Map<IMarker, Annotation> markerParseAnnotations = new HashMap<IMarker, Annotation>();
    private Map<IMarker, MarkerAnnotation> markerMarkerAnnotations = new HashMap<IMarker, MarkerAnnotation>();
    private IMessageHandler fAnnotationCreator = new AnnotationCreator((ITextEditor)this, "org.eclipse.imp.editor.parseAnnotation");
    private final IRegionSelectionService fRegionSelector = new IRegionSelectionService(){

        public void selectAndReveal(int startOffset, int length) {
            IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            AbstractTextEditor textEditor = (AbstractTextEditor)activeEditor;
            textEditor.selectAndReveal(startOffset, length);
        }
    };
    private EditorErrorTickUpdater fEditorErrorTickUpdater;
    private IProblemChangedListener fAnnotationUpdater;

    public UniversalEditor() {
        if (PreferenceCache.emitMessages) {
            RuntimePlugin.getInstance().writeInfoMsg("Creating UniversalEditor instance");
        }
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new StructuredSourceViewerConfiguration());
        this.configureInsertMode(SMART_INSERT, true);
        this.setInsertMode(SMART_INSERT);
        this.fProblemMarkerManager = new ProblemMarkerManager();
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            return this.fServiceControllerManager == null ? null : this.fServiceControllerManager.getOutlineController();
        }
        if (IToggleBreakpointsTarget.class.equals((Object)required)) {
            IToggleBreakpointsHandler bkptHandler;
            IToggleBreakpointsHandler iToggleBreakpointsHandler = bkptHandler = this.fLanguageServiceManager == null ? null : this.fLanguageServiceManager.getToggleBreakpointsHandler();
            if (bkptHandler != null) {
                if (this.fBreakpointHandler == null) {
                    this.fBreakpointHandler = new ToggleBreakpointsAdapter(this, bkptHandler);
                }
                return this.fBreakpointHandler;
            }
        }
        if (IRegionSelectionService.class.equals((Object)required)) {
            return this.fRegionSelector;
        }
        if (IContextProvider.class.equals((Object)required)) {
            return IMPHelp.getHelpContextProvider((IWorkbenchPart)this, this.fLanguageServiceManager, IMP_EDITOR_CONTEXT);
        }
        return super.getAdapter(required);
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.imp.editor.messages");
        Object action = new ContentAssistAction(bundle, "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        this.fToggleBreakpointAction = new ToggleBreakpointAction((IWorkbenchPart)this, this.getDocumentProvider().getDocument((Object)this.getEditorInput()), (IVerticalRulerInfo)this.getVerticalRuler());
        this.setAction("ToggleBreakpoint", (IAction)action);
        this.fEnableDisableBreakpointAction = new RulerEnableDisableBreakpointAction((ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler());
        this.setAction("ToggleBreakpoint", (IAction)action);
        action = new TextOperationAction(bundle, "Format.", (ITextEditor)this, 15);
        action.setActionDefinitionId(FORMAT_SOURCE_COMMAND);
        this.setAction("Format", (IAction)action);
        this.markAsStateDependentAction("Format", true);
        this.markAsSelectionDependentAction("Format", true);
        action = new TextOperationAction(bundle, "ShowOutline.", (ITextEditor)this, 51);
        action.setActionDefinitionId(SHOW_OUTLINE_COMMAND);
        this.setAction(SHOW_OUTLINE_COMMAND, (IAction)action);
        action = new TextOperationAction(bundle, "ToggleComment.", (ITextEditor)this, 54);
        action.setActionDefinitionId(TOGGLE_COMMENT_COMMAND);
        this.setAction(TOGGLE_COMMENT_COMMAND, (IAction)action);
        action = new TextOperationAction(bundle, "IndentSelection.", (ITextEditor)this, 60);
        action.setActionDefinitionId(INDENT_SELECTION_COMMAND);
        this.setAction(INDENT_SELECTION_COMMAND, (IAction)action);
        action = new GotoMatchingFenceAction(this);
        action.setActionDefinitionId(GOTO_MATCHING_FENCE_COMMAND);
        this.setAction(GOTO_MATCHING_FENCE_COMMAND, (IAction)action);
        action = new GotoPreviousTargetAction(this);
        action.setActionDefinitionId(GOTO_PREVIOUS_TARGET_COMMAND);
        this.setAction(GOTO_PREVIOUS_TARGET_COMMAND, (IAction)action);
        action = new GotoNextTargetAction(this);
        action.setActionDefinitionId(GOTO_NEXT_TARGET_COMMAND);
        this.setAction(GOTO_NEXT_TARGET_COMMAND, (IAction)action);
        action = new SelectEnclosingAction(this);
        action.setActionDefinitionId(SELECT_ENCLOSING_COMMAND);
        this.setAction(SELECT_ENCLOSING_COMMAND, (IAction)action);
        this.fFoldingActionGroup = new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getSourceViewer());
        this.installQuickAccessAction();
    }

    private void installQuickAccessAction() {
        this.fHandlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        if (this.fHandlerService != null) {
            this.fQuickAccessAction = new RefactorQuickAccessAction();
            this.fQuickAccessHandlerActivation = this.fHandlerService.activateHandler(this.fQuickAccessAction.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.fQuickAccessAction));
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IAction)new OpenAction(this));
        super.editorContextMenuAboutToShow(menu);
        this.contributeRefactoringActions(menu);
        this.contributeLanguageActions(menu);
    }

    private void contributeRefactoringActions(IMenuManager menu) {
        Set<IRefactoringContributor> contributors = this.fLanguageServiceManager.getRefactoringContributors();
        if (contributors != null && !contributors.isEmpty()) {
            ArrayList<IAction> editorActions = new ArrayList<IAction>();
            for (IRefactoringContributor con : contributors) {
                try {
                    IAction[] conActions = con.getEditorRefactoringActions(this);
                    for (int i = 0; i < conActions.length; ++i) {
                        editorActions.add(conActions[i]);
                    }
                }
                catch (Exception e) {
                    RuntimePlugin.getInstance().logException("Unable to create refactoring actions for contributor " + con, e);
                }
            }
            Separator refGroup = new Separator("group.refactor");
            MenuManager refMenu = new MenuManager("Refac&tor", "org.eclipse.imp.refactor");
            menu.add((IContributionItem)refGroup);
            menu.appendToGroup("group.refactor", (IContributionItem)refMenu);
            Iterator actionIter = editorActions.iterator();
            while (actionIter.hasNext()) {
                refMenu.add((IAction)actionIter.next());
            }
        }
    }

    private void contributeLanguageActions(IMenuManager menu) {
        Set<ILanguageActionsContributor> actionContributors = this.fLanguageServiceManager.getActionContributors();
        if (!actionContributors.isEmpty()) {
            menu.add((IContributionItem)new Separator());
        }
        for (ILanguageActionsContributor con : actionContributors) {
            try {
                con.contributeToEditorMenu(this, menu);
            }
            catch (Exception e) {
                RuntimePlugin.getInstance().logException("Unable to create editor actions for contributor " + con, e);
            }
        }
    }

    protected boolean isOverviewRulerVisible() {
        return true;
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        this.addDebugActions(menu);
        super.rulerContextMenuAboutToShow(menu);
        MenuManager foldingMenu = new MenuManager("Folding", "projection");
        menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
        IAction action = this.getAction("FoldingExpandAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingRestore");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseMembers");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseComments");
        foldingMenu.add(action);
    }

    private void addDebugActions(IMenuManager menu) {
        menu.add((IAction)this.fToggleBreakpointAction);
        menu.add(this.fEnableDisableBreakpointAction);
    }

    protected void setStatusLineErrorMessage(String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, msg, null);
        }
    }

    protected void setStatusLineMessage(String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(false, msg, null);
        }
    }

    public ProblemMarkerManager getProblemMarkerManager() {
        return this.fProblemMarkerManager;
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public Annotation gotoAnnotation(boolean forward) {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Position position = new Position(0, 0);
        Annotation annotation = this.getNextAnnotation(selection.getOffset(), selection.getLength(), forward, position);
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
        if (annotation != null) {
            this.updateAnnotationViews(annotation);
            this.selectAndReveal(position.getOffset(), position.getLength());
            this.setStatusLineMessage(annotation.getText());
        }
        return annotation;
    }

    private Annotation getNextAnnotation(int offset, int length, boolean forward, Position annotationPosition) {
        Annotation nextAnnotation = null;
        Position nextAnnotationPosition = null;
        Annotation containingAnnotation = null;
        Position containingAnnotationPosition = null;
        boolean currentAnnotation = false;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int endOfDocument = document.getLength();
        int distance = Integer.MAX_VALUE;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            int currentDistance;
            Position p;
            Annotation a = (Annotation)e.next();
            if (!(a instanceof MarkerAnnotation) && !a.getType().equals(PARSE_ANNOTATION_TYPE) || (p = model.getPosition(a)) == null) continue;
            if (forward && p.offset == offset || !forward && p.offset + p.getLength() == offset + length) {
                if (containingAnnotation != null && (!forward || p.length < containingAnnotationPosition.length) && (forward || p.length < containingAnnotationPosition.length)) continue;
                containingAnnotation = a;
                containingAnnotationPosition = p;
                currentAnnotation = p.length == length;
                continue;
            }
            int n = currentDistance = forward ? p.getOffset() - offset : offset + length - (p.getOffset() + p.length);
            if (currentDistance < 0) {
                currentDistance = endOfDocument + currentDistance;
            }
            if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
            distance = currentDistance;
            nextAnnotation = a;
            nextAnnotationPosition = p;
        }
        if (!(containingAnnotationPosition == null || currentAnnotation && nextAnnotation != null)) {
            annotationPosition.setOffset(containingAnnotationPosition.getOffset());
            annotationPosition.setLength(containingAnnotationPosition.getLength());
            return containingAnnotation;
        }
        if (nextAnnotationPosition != null) {
            annotationPosition.setOffset(nextAnnotationPosition.getOffset());
            annotationPosition.setLength(nextAnnotationPosition.getLength());
        }
        return nextAnnotation;
    }

    private void updateAnnotationViews(Annotation annotation) {
        IMarker marker = null;
        if (annotation instanceof MarkerAnnotation) {
            marker = ((MarkerAnnotation)annotation).getMarker();
        } else if (marker != null) {
            try {
                boolean isProblem = marker.isSubtypeOf("org.eclipse.core.resources.problemmarker");
                IWorkbenchPage page = this.getSite().getPage();
                IViewPart view = page.findView(isProblem ? "org.eclipse.ui.views.ProblemView" : "org.eclipse.ui.views.TaskList");
                if (view != null) {
                    Method method = view.getClass().getMethod("setSelection", IStructuredSelection.class, Boolean.TYPE);
                    method.invoke((Object)view, new StructuredSelection((Object)marker), Boolean.TRUE);
                }
            }
            catch (CoreException x) {
            }
            catch (NoSuchMethodException x) {
            }
            catch (IllegalAccessException x) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.fLanguage = LanguageRegistry.findLanguage(this.getEditorInput(), this.getDocumentProvider());
        if (this.fLanguage == null) {
            // empty if block
        }
        if (this.fLanguage != null) {
            this.fLanguageServiceManager = new LanguageServiceManager(this.fLanguage);
            this.fLanguageServiceManager.initialize((IEditorPart)this);
            this.fServiceControllerManager = new ServiceControllerManager((ITextEditor)this, this.fLanguageServiceManager);
            this.fServiceControllerManager.initialize();
            if (this.fLanguageServiceManager.getParseController() != null) {
                this.initializeParseController();
                this.findLanguageSpecificPreferences();
            }
        }
        super.createPartControl(parent);
        if (this.fLanguageServiceManager != null && this.fLanguageServiceManager.getParseController() != null) {
            this.fServiceControllerManager.setSourceViewer(this.getSourceViewer());
            this.initiateServiceControllers();
        }
        this.setTitleImageFromLanguageIcon();
        this.setSourceFontFromPreference();
        this.setupBracketCloser();
        this.setupSourcePrefListeners();
        this.initializeEditorContributors();
        this.watchForSourceMove();
    }

    private void initializeParseController() {
        IEditorInput editorInput = this.getEditorInput();
        IFile file = EditorInputUtils.getFile(editorInput);
        IPath filePath = EditorInputUtils.getPath(editorInput);
        try {
            ISourceProject srcProject = file != null ? ModelFactory.open(file.getProject()) : null;
            this.fLanguageServiceManager.getParseController().initialize(filePath, srcProject, this.fAnnotationCreator);
        }
        catch (ModelFactory.ModelException e) {
            ErrorHandler.reportError("Error initializing parser for input " + editorInput.getName() + ":", e);
        }
    }

    private void findLanguageSpecificPreferences() {
        ISourceProject srcProject = this.fLanguageServiceManager.getParseController().getProject();
        if (srcProject != null) {
            IProject project = srcProject.getRawProject();
            this.fLangSpecificPrefs = new PreferencesService(project, this.fLanguage.getName());
        } else {
            this.fLangSpecificPrefs = new PreferencesService(null, this.fLanguage.getName());
        }
        boolean spacesForTabs = RuntimePlugin.getInstance().getPreferenceStore().getBoolean("spacesForTabs");
        this.getPreferenceStore().setValue("spacesForTabs", spacesForTabs);
    }

    private void setupSourcePrefListeners() {
        if (this.fLangSpecificPrefs == null || !this.fLangSpecificPrefs.isDefined("sourceFont") && !this.fLangSpecificPrefs.isDefined("tabWidth") && !this.fLangSpecificPrefs.isDefined("spacesForTabs")) {
            this.fPropertyListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("sourceFont")) {
                        if (UniversalEditor.this.getSourceViewer() != null) {
                            FontData[] newValue = (FontData[])event.getNewValue();
                            String fontDescriptor = newValue[0].toString();
                            UniversalEditor.this.handleFontChange(newValue, fontDescriptor);
                        }
                    } else if (event.getProperty().equals("tabWidth")) {
                        if (UniversalEditor.this.getSourceViewer() != null) {
                            int newTab = (Integer)event.getNewValue();
                            UniversalEditor.this.getSourceViewer().getTextWidget().setTabs(newTab);
                        }
                    } else if (event.getProperty().equals("spacesForTabs") && UniversalEditor.this.getSourceViewer() != null) {
                        UniversalEditor.this.handleSpacesForTabsChange((Boolean)event.getNewValue());
                    }
                }
            };
            RuntimePlugin.getInstance().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
            return;
        }
        this.fFontListener = new IPreferencesService.StringPreferenceListener(this.fLangSpecificPrefs, "sourceFont"){

            public void changed(String oldValue, String newValue) {
                FontData[] fontData = PreferenceConverter.readFontData((String)newValue);
                UniversalEditor.this.handleFontChange(fontData, newValue);
            }
        };
        this.fTabListener = new IPreferencesService.IntegerPreferenceListener(this.fLangSpecificPrefs, "tabWidth"){

            public void changed(int oldValue, int newValue) {
                if (UniversalEditor.this.getSourceViewer() != null) {
                    UniversalEditor.this.getSourceViewer().getTextWidget().setTabs(newValue);
                }
            }
        };
        this.fSpacesForTabsListener = new IPreferencesService.BooleanPreferenceListener(this.fLangSpecificPrefs, "spacesForTabs"){

            public void changed(boolean oldValue, boolean newValue) {
                if (UniversalEditor.this.getSourceViewer() != null) {
                    UniversalEditor.this.handleSpacesForTabsChange(newValue);
                }
            }
        };
    }

    private void handleSpacesForTabsChange(boolean newValue) {
        if (newValue) {
            this.installTabsToSpacesConverter();
        } else {
            this.uninstallTabsToSpacesConverter();
        }
    }

    private void handleFontChange(FontData[] fontData, String fontDescriptor) {
        Font sourceFont;
        FontRegistry fontRegistry = RuntimePlugin.getInstance().getFontRegistry();
        if (!fontRegistry.hasValueFor(fontDescriptor)) {
            fontRegistry.put(fontDescriptor, fontData);
        }
        if ((sourceFont = fontRegistry.get(fontDescriptor)) != null) {
            this.getSourceViewer().getTextWidget().setFont(sourceFont);
        }
    }

    private void watchDocument(final long reparse_schedule_delay) {
        if (this.fLanguageServiceManager.getParseController() == null) {
            return;
        }
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        this.fDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                UniversalEditor.this.fParserScheduler.cancel();
                UniversalEditor.this.fParserScheduler.schedule(reparse_schedule_delay);
            }
        };
        doc.addDocumentListener(this.fDocumentListener);
    }

    private void setupBracketCloser() {
    }

    private void watchForSourceMove() {
        if (this.fLanguageServiceManager == null || this.fLanguageServiceManager.getParseController() == null || this.fLanguageServiceManager.getParseController().getProject() == null) {
            return;
        }
        this.fResourceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() != 1) {
                    return;
                }
                IParseController pc = UniversalEditor.this.fLanguageServiceManager.getParseController();
                if (pc == null) {
                    return;
                }
                IPath oldWSRelPath = pc.getProject().getRawProject().getFullPath().append(pc.getPath());
                IResourceDelta rd = event.getDelta().findMember(oldWSRelPath);
                if (rd != null && (rd.getFlags() & 0x2000) == 8192) {
                    IPath newPath = rd.getMovedToPath();
                    IPath newProjRelPath = newPath.removeFirstSegments(1);
                    String newProjName = newPath.segment(0);
                    boolean sameProj = pc.getProject().getRawProject().getName().equals(newProjName);
                    try {
                        ISourceProject proj = sameProj ? pc.getProject() : ModelFactory.open(ResourcesPlugin.getWorkspace().getRoot().getProject(newProjName));
                        pc.initialize(newProjRelPath, proj, UniversalEditor.this.fAnnotationCreator);
                    }
                    catch (ModelFactory.ModelException e) {
                        RuntimePlugin.getInstance().logException("Error tracking resource move", e);
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceListener);
    }

    private void setSourceFontFromPreference() {
        Font sourceFont;
        FontRegistry fontRegistry;
        String fontName = null;
        if (this.fLangSpecificPrefs != null) {
            fontName = this.fLangSpecificPrefs.getStringPreference("sourceFont");
        }
        if (fontName == null) {
            IPreferenceStore prefStore = RuntimePlugin.getInstance().getPreferenceStore();
            fontName = prefStore.getString("sourceFont");
        }
        if (!(fontRegistry = RuntimePlugin.getInstance().getFontRegistry()).hasValueFor(fontName)) {
            fontRegistry.put(fontName, PreferenceConverter.readFontData((String)fontName));
        }
        if ((sourceFont = fontRegistry.get(fontName)) != null) {
            this.getSourceViewer().getTextWidget().setFont(sourceFont);
        }
    }

    private void initiateServiceControllers() {
        try {
            StructuredSourceViewer sourceViewer = (StructuredSourceViewer)this.getSourceViewer();
            if (PreferenceCache.emitMessages) {
                RuntimePlugin.getInstance().writeInfoMsg("Creating language service controllers for " + this.fLanguage.getName());
            }
            this.fEditorErrorTickUpdater = new EditorErrorTickUpdater(this);
            this.fProblemMarkerManager.addListener(this.fEditorErrorTickUpdater);
            this.fAnnotationUpdater = new AnnotationUpdater();
            this.fProblemMarkerManager.addListener(this.fAnnotationUpdater);
            this.fParserScheduler = new ParserScheduler(this.fLanguageServiceManager.getParseController(), (IEditorPart)this, this.getDocumentProvider(), this.fAnnotationCreator);
            sourceViewer.setTextHover(this.fServiceControllerManager.getHoverHelpController(), "__dftl_partition_content_type");
            ContentFormatter formatter = new ContentFormatter();
            formatter.setFormattingStrategy((IFormattingStrategy)this.fServiceControllerManager.getFormattingController(), "__dftl_partition_content_type");
            sourceViewer.setFormatter((IContentFormatter)formatter);
            try {
                this.fServiceControllerManager.getPresentationController().damage((IRegion)new Region(0, sourceViewer.getDocument().getLength()));
            }
            catch (Exception e) {
                ErrorHandler.reportError("Error during initial damage repair", e);
            }
            sourceViewer.setParseController(this.fLanguageServiceManager.getParseController());
            if (this.fLanguageServiceManager.getFoldingUpdater() != null) {
                StructuredSourceViewer projViewer = sourceViewer;
                ProjectionSupport projectionSupport = new ProjectionSupport((ProjectionViewer)projViewer, this.getAnnotationAccess(), this.getSharedColors());
                projectionSupport.install();
                projViewer.doOperation(19);
                this.fAnnotationModel = projViewer.getProjectionAnnotationModel();
                this.fParserScheduler.addModelListener(new FoldingController(this.fAnnotationModel, this.fLanguageServiceManager.getFoldingUpdater()));
            }
            this.fParserScheduler.addModelListener(new AnnotationCreatorListener());
            this.fServiceControllerManager.setupModelListeners(this.fParserScheduler);
            this.installExternalEditorServices();
            this.watchDocument(100L);
            this.fParserScheduler.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            ErrorHandler.reportError("Error while creating service controllers", e);
        }
    }

    private void setTitleImageFromLanguageIcon() {
        if (this.fLanguageServiceManager != null && this.fLanguageServiceManager.getLabelProvider() != null) {
            IEditorInput editorInput = this.getEditorInput();
            IFile file = EditorInputUtils.getFile(editorInput);
            try {
                this.setTitleImage(this.fLanguageServiceManager.getLabelProvider().getImage((Object)file));
            }
            catch (Exception e) {
                ErrorHandler.reportError("Error while setting source editor title icon from label provider", e);
            }
        }
    }

    private void installExternalEditorServices() {
        Set<IModelListener> editorServices = this.fLanguageServiceManager.getEditorServices();
        for (IModelListener editorService : editorServices) {
            if (editorService instanceof IEditorService) {
                ((IEditorService)editorService).setEditor(this);
            }
            this.fParserScheduler.addModelListener(editorService);
        }
    }

    private void initializeEditorContributors() {
        if (this.fLanguage != null) {
            this.addEditorActions();
            this.registerEditorContributionsActivator();
        }
    }

    private void registerEditorContributionsActivator() {
        this.fRefreshContributions = new DefaultPartListener(){
            private UniversalEditor editor;
            {
                this.editor = UniversalEditor.this;
            }

            public void partActivated(IWorkbenchPart part) {
                if (part == this.editor) {
                    this.editor.fActionBars.activate();
                    this.editor.fActionBars.updateActionBars();
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
                if (part == this.editor) {
                    this.editor.fActionBars.deactivate();
                    this.editor.fActionBars.updateActionBars();
                }
            }
        };
        this.getSite().getPage().addPartListener((IPartListener)this.fRefreshContributions);
    }

    private void unregisterEditorContributionsActivator() {
        if (this.fRefreshContributions != null) {
            this.getSite().getPage().removePartListener((IPartListener)this.fRefreshContributions);
        }
        this.fRefreshContributions = null;
    }

    private void addEditorActions() {
        IActionBars allActionBars = this.getEditorSite().getActionBars();
        if (this.fActionBars == null) {
            Set<ILanguageActionsContributor> contributors = ServiceFactory.getInstance().getLanguageActionsContributors(this.fLanguage);
            this.fActionBars = new SubActionBars(allActionBars);
            IStatusLineManager status = this.fActionBars.getStatusLineManager();
            IToolBarManager toolbar = this.fActionBars.getToolBarManager();
            IMenuManager menu = this.fActionBars.getMenuManager();
            for (ILanguageActionsContributor c : contributors) {
                c.contributeToStatusLine(this, status);
                c.contributeToToolBar(this, toolbar);
                c.contributeToMenuBar(this, menu);
            }
            this.fActionBars.updateActionBars();
            allActionBars.updateActionBars();
        }
        allActionBars.updateActionBars();
    }

    public void dispose() {
        if (this.fFontListener != null) {
            this.fFontListener.dispose();
        }
        if (this.fTabListener != null) {
            this.fTabListener.dispose();
        }
        if (this.fSpacesForTabsListener != null) {
            this.fSpacesForTabsListener.dispose();
        }
        if (this.fPropertyListener != null) {
            RuntimePlugin.getInstance().getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
        }
        this.unregisterEditorContributionsActivator();
        if (this.fEditorErrorTickUpdater != null) {
            this.fProblemMarkerManager.removeListener(this.fEditorErrorTickUpdater);
        }
        if (this.fAnnotationUpdater != null) {
            this.fProblemMarkerManager.removeListener(this.fAnnotationUpdater);
        }
        if (this.fActionBars != null) {
            this.fActionBars.dispose();
            this.fActionBars = null;
        }
        if (this.fDocumentListener != null) {
            this.getDocumentProvider().getDocument((Object)this.getEditorInput()).removeDocumentListener(this.fDocumentListener);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceListener);
        this.fLanguageServiceManager.dispose();
        this.fToggleBreakpointAction.dispose();
        this.fFoldingActionGroup.dispose();
        this.fServiceControllerManager.getCompletionProcessor().dispose();
        this.fServiceControllerManager = null;
        this.fParserScheduler.cancel();
        this.fParserScheduler = null;
        ((StructuredSourceViewer)this.getSourceViewer()).setParseController(null);
        super.dispose();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        StructuredSourceViewer viewer = new StructuredSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        if (this.fLanguageServiceManager != null && this.fLanguageServiceManager.getParseController() != null) {
            IMPHelp.setHelp(this.fLanguageServiceManager, (ITextEditor)this, viewer.getTextWidget(), IMP_EDITOR_CONTEXT);
        }
        return viewer;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        String[][] fences;
        if (this.fLanguage == null || this.fLanguageServiceManager == null) {
            return;
        }
        IParseController parseController = this.fLanguageServiceManager.getParseController();
        if (parseController == null) {
            return;
        }
        ILanguageSyntaxProperties syntaxProps = parseController.getSyntaxProperties();
        this.getPreferenceStore().setValue(MATCHING_BRACKETS, true);
        if (syntaxProps != null && (fences = syntaxProps.getFences()) != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < fences.length; ++i) {
                sb.append(fences[i][0]);
                sb.append(fences[i][1]);
            }
            this.fBracketMatcher = new DefaultCharacterPairMatcher(sb.toString().toCharArray());
            support.setCharacterPairMatcher(this.fBracketMatcher);
            support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        }
        super.configureSourceViewerDecorationSupport(support);
    }

    public void gotoMatchingFence() {
        IRegion region;
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = this.getSignedSelection(sourceViewer);
        int selectionLength = Math.abs(selection.getLength());
        if (selectionLength > 1) {
            this.setStatusLineErrorMessage("Invalid selection");
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int sourceCaretOffset = selection.getOffset() + selection.getLength();
        if (this.isSurroundedByBrackets(document, sourceCaretOffset)) {
            sourceCaretOffset -= selection.getLength();
        }
        if ((region = this.fBracketMatcher.match(document, sourceCaretOffset)) == null) {
            this.setStatusLineErrorMessage("No matching fence!");
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.fBracketMatcher.getAnchor();
        int targetOffset = 0 == anchor ? offset + 1 : offset + length;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage("Matching fence is outside the currently selected element.");
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (selection.getLength() < 0) {
            targetOffset -= selection.getLength();
        }
        sourceViewer.setSelectedRange(targetOffset, selection.getLength());
        sourceViewer.revealRange(targetOffset, selection.getLength());
    }

    private boolean isBracket(char character) {
        ILanguageSyntaxProperties syntaxProps = this.fLanguageServiceManager.getParseController().getSyntaxProperties();
        String[][] fences = syntaxProps.getFences();
        for (int i = 0; i != fences.length; ++i) {
            if (fences[i][0].indexOf(character) >= 0) {
                return true;
            }
            if (fences[i][1].indexOf(character) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean isSurroundedByBrackets(IDocument document, int offset) {
        if (offset == 0 || offset == document.getLength()) {
            return false;
        }
        try {
            return this.isBracket(document.getChar(offset - 1)) && this.isBracket(document.getChar(offset));
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public IRegion getSignedSelection(ISourceViewer sourceViewer) {
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            selection.x += selection.y;
            selection.y = -selection.y;
        }
        selection.x = UniversalEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)selection.x);
        return new Region(selection.x, selection.y);
    }

    public IRegion getSelectedRegion() {
        StyledText text = this.getSourceViewer().getTextWidget();
        Point selection = text.getSelectionRange();
        return new Region(selection.x, selection.y);
    }

    public void refreshMarkerAnnotations(String problemMarkerType) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        Iterator annIter = model.getAnnotationIterator();
        ArrayList<MarkerAnnotation> markerAnnotations = new ArrayList<MarkerAnnotation>();
        while (annIter.hasNext()) {
            Object ann = annIter.next();
            if (!(ann instanceof MarkerAnnotation)) continue;
            markerAnnotations.add((MarkerAnnotation)ann);
        }
        for (int i = 0; i < markerAnnotations.size(); ++i) {
            IMarker marker;
            block5: {
                marker = ((MarkerAnnotation)markerAnnotations.get(i)).getMarker();
                try {
                    String markerType = marker.getType();
                    if (!markerType.endsWith(problemMarkerType)) {
                    }
                    break block5;
                }
                catch (CoreException e) {
                    model.removeAnnotation((Annotation)markerAnnotations.get(i));
                }
                continue;
            }
            if (this.markerParseAnnotations.get(marker) != null) continue;
            model.removeAnnotation((Annotation)markerAnnotations.get(i));
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        try {
            super.doSetInput(input);
        }
        catch (NullPointerException e) {
            return;
        }
        this.setInsertMode(SMART_INSERT);
        IAnnotationModel annotationModel = this.getDocumentProvider().getAnnotationModel((Object)input);
        if (annotationModel != null) {
            annotationModel.addAnnotationModelListener((IAnnotationModelListener)new InputAnnotationModelListener());
        }
    }

    public void addModelListener(IModelListener listener) {
        this.fParserScheduler.addModelListener(listener);
    }

    public void removeModelListener(IModelListener listener) {
        this.fParserScheduler.removeModelListener(listener);
    }

    public String getSelectionText() {
        Point sel = this.getSelection();
        IFileEditorInput fileEditorInput = (IFileEditorInput)this.getEditorInput();
        IDocument document = this.getDocumentProvider().getDocument((Object)fileEditorInput);
        try {
            return document.get(sel.x, sel.y);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    public Point getSelection() {
        ISelection sel = this.getSelectionProvider().getSelection();
        ITextSelection textSel = (ITextSelection)sel;
        return new Point(textSel.getOffset(), textSel.getLength());
    }

    public boolean canPerformFind() {
        return true;
    }

    public IParseController getParseController() {
        return this.fLanguageServiceManager.getParseController();
    }

    public IOccurrenceMarker getOccurrenceMarker() {
        return this.fLanguageServiceManager.getOccurrenceMarker();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
    }

    public void removeParserAnnotations() {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        Iterator i = model.getAnnotationIterator();
        while (i.hasNext()) {
            Annotation a = (Annotation)i.next();
            if (!a.getType().equals(PARSE_ANNOTATION_TYPE)) continue;
            model.removeAnnotation(a);
        }
    }

    public String toString() {
        String langName = this.fLanguage != null ? " for " + this.fLanguage.getName() : "";
        String inputDesc = this.fParserScheduler != null && this.fLanguageServiceManager.getParseController() != null && this.fLanguageServiceManager.getParseController().getPath() != null ? "source " + this.fLanguageServiceManager.getParseController().getPath().toPortableString() : "";
        return "Universal Editor" + langName + " on " + inputDesc + this.getEditorInput();
    }

    private class AnnotationCreatorListener
    implements IModelListener {
        private AnnotationCreatorListener() {
        }

        public IModelListener.AnalysisRequired getAnalysisRequired() {
            return IModelListener.AnalysisRequired.NONE;
        }

        public void update(IParseController parseController, IProgressMonitor monitor) {
            IAnnotationTypeInfo annotationTypeInfo = parseController.getAnnotationTypeInfo();
            if (annotationTypeInfo != null) {
                List<String> problemMarkerTypes = annotationTypeInfo.getProblemMarkerTypes();
                for (int i = 0; i < problemMarkerTypes.size(); ++i) {
                    UniversalEditor.this.refreshMarkerAnnotations(problemMarkerTypes.get(i));
                }
            }
        }
    }

    private class PresentationRepairer
    implements IPresentationRepairer {
        ITypedRegion previousDamage = null;
        private final IProgressMonitor fProgressMonitor = new NullProgressMonitor();

        private PresentationRepairer() {
        }

        public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
            boolean hyperlinkRestore = false;
            if (this.previousDamage != null && damage.getOffset() == this.previousDamage.getOffset() && damage.getLength() == this.previousDamage.getLength()) {
                hyperlinkRestore = true;
            }
            try {
                if (UniversalEditor.this.fServiceControllerManager.getPresentationController() != null) {
                    UniversalEditor.this.fServiceControllerManager.getPresentationController().damage((IRegion)damage);
                    if (hyperlinkRestore) {
                        UniversalEditor.this.fServiceControllerManager.getPresentationController().update(UniversalEditor.this.fLanguageServiceManager.getParseController(), this.fProgressMonitor);
                    }
                }
            }
            catch (Exception e) {
                ErrorHandler.reportError("Could not repair damage ", e);
            }
            this.previousDamage = damage;
        }

        public void setDocument(IDocument document) {
        }
    }

    private class PresentationDamager
    implements IPresentationDamager {
        private PresentationDamager() {
        }

        public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean documentPartitioningChanged) {
            ITokenColorer tokenColorer = UniversalEditor.this.fLanguageServiceManager.getTokenColorer();
            if (tokenColorer != null) {
                return tokenColorer.calculateDamageExtent((IRegion)partition, UniversalEditor.this.fLanguageServiceManager.getParseController());
            }
            return partition;
        }

        public void setDocument(IDocument document) {
        }
    }

    class StructuredSourceViewerConfiguration
    extends TextSourceViewerConfiguration {
        private InformationPresenter fInfoPresenter;
        private IInformationProvider fOutlineElementProvider = new OutlineInformationProvider();

        StructuredSourceViewerConfiguration() {
        }

        public int getTabWidth(ISourceViewer sourceViewer) {
            boolean langSpecificSetting = UniversalEditor.this.fLangSpecificPrefs != null && UniversalEditor.this.fLangSpecificPrefs.isDefined("tabWidth");
            return langSpecificSetting ? UniversalEditor.this.fLangSpecificPrefs.getIntPreference("tabWidth") : PreferenceCache.tabWidth;
        }

        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
            if (UniversalEditor.this.fServiceControllerManager == null) {
                return super.getPresentationReconciler(sourceViewer);
            }
            PresentationReconciler reconciler = new PresentationReconciler();
            reconciler.setRepairer((IPresentationRepairer)new PresentationRepairer(), "__dftl_partition_content_type");
            reconciler.setDamager((IPresentationDamager)new PresentationDamager(), "__dftl_partition_content_type");
            return reconciler;
        }

        public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
            if (UniversalEditor.this.fServiceControllerManager == null) {
                return super.getContentAssistant(sourceViewer);
            }
            ContentAssistant ca = new ContentAssistant();
            ca.setContentAssistProcessor((IContentAssistProcessor)UniversalEditor.this.fServiceControllerManager.getCompletionProcessor(), "__dftl_partition_content_type");
            ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            return ca;
        }

        public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
            if (UniversalEditor.this.fLanguageServiceManager == null) {
                return super.getAnnotationHover(sourceViewer);
            }
            IAnnotationHover hover = UniversalEditor.this.fLanguageServiceManager.getAnnotationHover();
            if (hover == null) {
                hover = new DefaultAnnotationHover();
            }
            return hover;
        }

        public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
            if (UniversalEditor.this.fLanguageServiceManager == null) {
                return super.getAutoEditStrategies(sourceViewer, contentType);
            }
            Set<org.eclipse.imp.services.IAutoEditStrategy> autoEdits = UniversalEditor.this.fLanguageServiceManager.getAutoEditStrategies();
            if (autoEdits == null || autoEdits.size() == 0) {
                return super.getAutoEditStrategies(sourceViewer, contentType);
            }
            return autoEdits.toArray(new IAutoEditStrategy[autoEdits.size()]);
        }

        public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
            if (UniversalEditor.this.fServiceControllerManager == null || UniversalEditor.this.fServiceControllerManager.getFormattingController() == null) {
                return null;
            }
            ContentFormatter formatter = new ContentFormatter();
            formatter.setFormattingStrategy((IFormattingStrategy)UniversalEditor.this.fServiceControllerManager.getFormattingController(), "__dftl_partition_content_type");
            return formatter;
        }

        public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
            return super.getDefaultPrefixes(sourceViewer, contentType);
        }

        public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
            return super.getDoubleClickStrategy(sourceViewer, contentType);
        }

        public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
            if (UniversalEditor.this.fServiceControllerManager != null && UniversalEditor.this.fServiceControllerManager.getHyperLinkController() != null) {
                return new IHyperlinkDetector[]{UniversalEditor.this.fServiceControllerManager.getHyperLinkController()};
            }
            return super.getHyperlinkDetectors(sourceViewer);
        }

        public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
            return super.getHyperlinkPresenter(sourceViewer);
        }

        public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
            return super.getIndentPrefixes(sourceViewer, contentType);
        }

        public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, "Press 'F2' for focus", (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
                }
            };
        }

        public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
            if (UniversalEditor.this.fLanguageServiceManager == null) {
                return super.getInformationPresenter(sourceViewer);
            }
            if (this.fInfoPresenter == null) {
                this.fInfoPresenter = new InformationPresenter(this.getInformationControlCreator(sourceViewer));
                this.fInfoPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
                this.fInfoPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
                IInformationProvider provider = new IInformationProvider(){

                    public IRegion getSubject(ITextViewer textViewer, int offset) {
                        IParseController pc = UniversalEditor.this.fLanguageServiceManager.getParseController();
                        ISourcePositionLocator locator = pc.getSourcePositionLocator();
                        if (locator == null) {
                            return new Region(offset, 0);
                        }
                        Object selNode = locator.findNode(pc, offset);
                        return new Region(locator.getStartOffset(selNode), locator.getLength(selNode));
                    }

                    public String getInformation(ITextViewer textViewer, IRegion subject) {
                        IParseController pc = UniversalEditor.this.fLanguageServiceManager.getParseController();
                        ISourcePositionLocator locator = pc.getSourcePositionLocator();
                        if (locator == null) {
                            return "";
                        }
                        IDocumentationProvider docProvider = UniversalEditor.this.fLanguageServiceManager.getDocProvider();
                        Object selNode = locator.findNode(pc.getCurrentAst(), subject.getOffset());
                        return docProvider != null ? docProvider.getDocumentation(selNode, pc) : "No documentation available on the selected entity.";
                    }
                };
                this.fInfoPresenter.setInformationProvider(provider, "__dftl_partition_content_type");
                this.fInfoPresenter.setSizeConstraints(60, 10, true, false);
                this.fInfoPresenter.setRestoreInformationControlBounds(this.getSettings("outline_presenter_bounds"), true, true);
            }
            return this.fInfoPresenter;
        }

        public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
            if (UniversalEditor.this.fServiceControllerManager == null) {
                return super.getTextHover(sourceViewer, contentType);
            }
            return UniversalEditor.this.fServiceControllerManager.getHoverHelpController();
        }

        public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
            return super.getTextHover(sourceViewer, contentType, stateMask);
        }

        public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
            return super.getUndoManager(sourceViewer);
        }

        public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
            return super.getOverviewRulerAnnotationHover(sourceViewer);
        }

        public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer) {
            if (UniversalEditor.this.fLanguageServiceManager == null) {
                return null;
            }
            TreeModelBuilderBase modelBuilder = UniversalEditor.this.fLanguageServiceManager.getModelBuilder();
            if (modelBuilder == null) {
                return null;
            }
            InformationPresenter presenter = new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, UniversalEditor.SHOW_OUTLINE_COMMAND));
            presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
            IInformationProvider provider = this.fOutlineElementProvider;
            presenter.setInformationProvider(provider, "__dftl_partition_content_type");
            presenter.setSizeConstraints(50, 20, true, false);
            presenter.setRestoreInformationControlBounds(this.getSettings("outline_presenter_bounds"), true, true);
            return presenter;
        }

        private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, final String commandId) {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    int shellStyle = 16;
                    int treeStyle = 768;
                    return new OutlineInformationControl(parent, shellStyle, treeStyle, commandId, UniversalEditor.this.fLanguage);
                }
            };
        }

        public IInformationPresenter getHierarchyPresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
            InformationPresenter presenter = new InformationPresenter(this.getHierarchyPresenterControlCreator(sourceViewer));
            presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
            IInformationProvider provider = null;
            presenter.setInformationProvider(provider, "__dftl_partition_content_type");
            presenter.setSizeConstraints(50, 20, true, false);
            presenter.setRestoreInformationControlBounds(this.getSettings("hierarchy_presenter_bounds"), true, true);
            return presenter;
        }

        private IInformationControlCreator getHierarchyPresenterControlCreator(ISourceViewer sourceViewer) {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent);
                }
            };
        }

        private IDialogSettings getSettings(String sectionName) {
            IDialogSettings settings = RuntimePlugin.getInstance().getDialogSettings().getSection(sectionName);
            if (settings == null) {
                settings = RuntimePlugin.getInstance().getDialogSettings().addNewSection(sectionName);
            }
            return settings;
        }

        private class OutlineInformationProvider
        implements IInformationProvider,
        IInformationProviderExtension {
            private TreeModelBuilderBase fBuilder;

            private OutlineInformationProvider() {
            }

            public IRegion getSubject(ITextViewer textViewer, int offset) {
                return new Region(offset, 0);
            }

            public String getInformation(ITextViewer textViewer, IRegion subject) {
                return "never called?!?";
            }

            public Object getInformation2(ITextViewer textViewer, IRegion subject) {
                if (this.fBuilder == null) {
                    this.fBuilder = UniversalEditor.this.fLanguageServiceManager.getModelBuilder();
                }
                return this.fBuilder.buildTree(UniversalEditor.this.fLanguageServiceManager.getParseController().getCurrentAst());
            }
        }
    }

    protected class InputAnnotationModelListener
    implements IAnnotationModelListener {
        protected InputAnnotationModelListener() {
        }

        public void modelChanged(IAnnotationModel model) {
            IMarker marker;
            ArrayList<Annotation> currentParseAnnotations = new ArrayList<Annotation>();
            ArrayList<IMarker> currentMarkers = new ArrayList<IMarker>();
            UniversalEditor.this.markerParseAnnotations = new HashMap();
            UniversalEditor.this.markerMarkerAnnotations = new HashMap();
            Iterator annotations = model.getAnnotationIterator();
            while (annotations.hasNext()) {
                Annotation annotation;
                Object ann = annotations.next();
                if (ann instanceof MarkerAnnotation) {
                    marker = ((MarkerAnnotation)ann).getMarker();
                    if (marker.exists()) {
                        currentMarkers.add(marker);
                    }
                    UniversalEditor.this.markerMarkerAnnotations.put(marker, (MarkerAnnotation)ann);
                    continue;
                }
                if (!(ann instanceof Annotation) || !(annotation = (Annotation)ann).getType().equals(UniversalEditor.PARSE_ANNOTATION_TYPE)) continue;
                currentParseAnnotations.add(annotation);
            }
            for (int i = 0; i < currentMarkers.size(); ++i) {
                marker = (IMarker)currentMarkers.get(i);
                Annotation annotation = this.findParseAnnotationForMarker(model, marker, currentParseAnnotations);
                if (annotation == null) continue;
                UniversalEditor.this.markerParseAnnotations.put(marker, annotation);
            }
        }

        public Annotation findParseAnnotationForMarker(IAnnotationModel model, IMarker marker, List parseAnnotations) {
            Integer markerStartAttr = null;
            Integer markerEndAttr = null;
            try {
                markerStartAttr = (Integer)marker.getAttribute("charStart");
                markerEndAttr = (Integer)marker.getAttribute("charEnd");
                if (markerStartAttr == null || markerEndAttr == null) {
                    return null;
                }
            }
            catch (CoreException e) {
                RuntimePlugin.getInstance().logException("UniversalEditor.findParseAnnotationForMarker:  CoreException getting marker start and end attributes", e);
                return null;
            }
            catch (NullPointerException e) {
                RuntimePlugin.getInstance().logException("UniversalEditor.findParseAnnotationForMarker:  NullPointerException getting marker start and end attributes", e);
                return null;
            }
            int markerStart = markerStartAttr;
            int markerEnd = markerEndAttr;
            int markerLength = markerEnd - markerStart;
            for (int j = 0; j < parseAnnotations.size(); ++j) {
                Annotation parseAnnotation = (Annotation)parseAnnotations.get(j);
                Position pos = model.getPosition(parseAnnotation);
                if (pos == null) continue;
                int annotationStart = pos.offset;
                int annotationLength = pos.length;
                if (markerStart != annotationStart || markerLength != annotationLength) continue;
                return parseAnnotation;
            }
            return null;
        }
    }

    private class BracketInserter
    implements VerifyKeyListener {
        private final Map<String, String> fFencePairs = new HashMap<String, String>();
        private final String fOpenFences;
        private final Map<Character, Boolean> fCloseFenceMap = new HashMap<Character, Boolean>();

        public BracketInserter() {
            String[][] pairs = UniversalEditor.this.fLanguageServiceManager.getParseController().getSyntaxProperties().getFences();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < pairs.length; ++i) {
                sb.append(pairs[i][0]);
                this.fFencePairs.put(pairs[i][0], pairs[i][1]);
            }
            this.fOpenFences = sb.toString();
        }

        public void setCloseFenceEnabled(char openingFence, boolean enabled) {
            this.fCloseFenceMap.put(Character.valueOf(openingFence), enabled);
        }

        public void setCloseFencesEnabled(boolean enabled) {
            for (int i = 0; i < this.fOpenFences.length(); ++i) {
                this.fCloseFenceMap.put(Character.valueOf(this.fOpenFences.charAt(i)), enabled);
            }
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit || UniversalEditor.this.getInsertMode() != ITextEditorExtension3.SMART_INSERT) {
                return;
            }
            if (this.fOpenFences.indexOf(event.character) < 0) {
                return;
            }
            ISourceViewer sourceViewer = UniversalEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            Point selection = sourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            try {
                ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)UniversalEditor.this.getSourceViewerConfiguration().getConfiguredDocumentPartitioning(sourceViewer), (int)offset, (boolean)true);
                if (!"__dftl_partition_content_type".equals(partition.getType())) {
                    return;
                }
                if (!UniversalEditor.this.validateEditorInputState()) {
                    return;
                }
                String inputStr = new String(new char[]{event.character});
                String closingFence = this.fFencePairs.get(inputStr);
                StringBuffer buffer = new StringBuffer();
                buffer.append(inputStr);
                buffer.append(closingFence);
                document.replace(offset, length, buffer.toString());
                sourceViewer.setSelectedRange(offset + inputStr.length(), 0);
                event.doit = false;
            }
            catch (BadLocationException e) {
                RuntimePlugin.getInstance().logException(e.getMessage(), e);
            }
        }
    }

    private class RefactorQuickAccessAction
    extends QuickMenuAction {
        public RefactorQuickAccessAction() {
            super(UniversalEditor.QUICK_MENU_ID);
        }

        protected void fillMenu(IMenuManager menu) {
            UniversalEditor.this.contributeRefactoringActions(menu);
        }
    }

    private final class AnnotationUpdater
    implements IProblemChangedListener {
        private AnnotationUpdater() {
        }

        public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
            if (UniversalEditor.this.fParserScheduler != null) {
                UniversalEditor.this.fParserScheduler.schedule(50L);
            }
        }
    }
}

