/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.editor.EditorInputUtils;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IMessageHandlerExtension;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.preferences.PreferenceCache;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ParserScheduler
extends Job {
    private final IParseController fParseController;
    private final IEditorPart fEditorPart;
    private final IDocumentProvider fDocumentProvider;
    private final IMessageHandler fMsgHandler;
    private final List<IModelListener> fAstListeners = new ArrayList<IModelListener>();

    public ParserScheduler(IParseController parseController, IEditorPart editorPart, IDocumentProvider docProvider, IMessageHandler msgHandler) {
        super(LanguageRegistry.findLanguage(EditorInputUtils.getPath(editorPart.getEditorInput()), null).getName() + " ParserScheduler for " + editorPart.getEditorInput().getName());
        this.setSystem(true);
        this.fParseController = parseController;
        this.fEditorPart = editorPart;
        this.fDocumentProvider = docProvider;
        this.fMsgHandler = msgHandler;
    }

    public IStatus run(IProgressMonitor monitor) {
        if (this.fParseController == null || this.fDocumentProvider == null) {
            return Status.OK_STATUS;
        }
        IEditorInput editorInput = this.fEditorPart.getEditorInput();
        try {
            IDocument document = this.fDocumentProvider.getDocument((Object)editorInput);
            if (document == null) {
                return Status.OK_STATUS;
            }
            if (PreferenceCache.emitMessages) {
                RuntimePlugin.getInstance().writeInfoMsg("Parsing language " + this.fParseController.getLanguage().getName() + " for input " + editorInput.getName());
            }
            if (this.sourceStillExists()) {
                this.fMsgHandler.clearMessages();
                this.fParseController.parse(document.get(), monitor);
                if (this.fMsgHandler instanceof IMessageHandlerExtension) {
                    ((IMessageHandlerExtension)this.fMsgHandler).endMessages();
                }
            }
            if (!monitor.isCanceled()) {
                this.notifyModelListeners(monitor);
            }
        }
        catch (Exception e) {
            Language lang = this.fParseController.getLanguage();
            String input = editorInput != null ? editorInput.getName() : "<unknown editor input";
            String name = lang != null ? lang.getName() : "<unknown language>";
            ErrorHandler.reportError("Error running parser for language " + name + " and input " + input + ":", e);
            this.notifyModelListeners(monitor);
        }
        catch (LinkageError e) {
            ErrorHandler.reportError("Error loading IParseController implementation class for language " + this.fParseController.getLanguage().getName(), e);
        }
        return Status.OK_STATUS;
    }

    private boolean sourceStillExists() {
        ISourceProject project = this.fParseController.getProject();
        if (project == null) {
            return true;
        }
        IProject rawProject = project.getRawProject();
        if (!rawProject.exists()) {
            return false;
        }
        IFile file = rawProject.getFile(this.fParseController.getPath());
        return file.exists();
    }

    public void addModelListener(IModelListener listener) {
        this.fAstListeners.add(listener);
    }

    public void removeModelListener(IModelListener listener) {
        this.fAstListeners.remove(listener);
    }

    public void notifyModelListeners(IProgressMonitor monitor) {
        if (this.fParseController != null) {
            if (PreferenceCache.emitMessages) {
                RuntimePlugin.getInstance().writeInfoMsg("Notifying AST listeners of change in " + (this.fParseController.getPath() != null ? this.fParseController.getPath().toPortableString() : "<unknown file>"));
            }
            for (int n = this.fAstListeners.size() - 1; n >= 0 && !monitor.isCanceled(); --n) {
                IModelListener listener = this.fAstListeners.get(n);
                int analysisLevel = IModelListener.AnalysisRequired.POINTER_ANALYSIS.level();
                if (this.fParseController.getCurrentAst() == null) {
                    analysisLevel = IModelListener.AnalysisRequired.LEXICAL_ANALYSIS.level();
                }
                if (listener.getAnalysisRequired().level() > analysisLevel) continue;
                listener.update(this.fParseController, monitor);
            }
        } else if (PreferenceCache.emitMessages) {
            RuntimePlugin.getInstance().writeInfoMsg("No AST; bypassing listener notification.");
        }
    }
}

