/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.imp.editor.IRegionSelectionService;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public final class TargetLink
implements IHyperlink {
    private final String fText;
    private final Object fTarget;
    private final int fStart;
    private final int fLength;
    private final int fTargetStart;
    private final int fTargetLength;
    private IRegionSelectionService fSelectionService;

    public TargetLink(String text, int srcStart, int srcLength, Object target, int targetStart, int targetLength, IRegionSelectionService selService) {
        this.fText = text;
        this.fStart = srcStart;
        this.fTarget = target;
        this.fLength = srcLength;
        this.fTargetStart = targetStart;
        this.fTargetLength = targetLength;
        this.fSelectionService = selService;
    }

    public IRegion getHyperlinkRegion() {
        return new Region(this.fStart, this.fLength);
    }

    public String getTypeLabel() {
        return this.fTarget.getClass().getName();
    }

    public String getHyperlinkText() {
        return new String(this.fText);
    }

    public void open() {
        if (this.fSelectionService == null) {
            IEditorPart editor;
            if (!(this.fTarget instanceof IPath)) {
                RuntimePlugin.getInstance().writeErrorMsg("Unable to link to a target of type other than IPath: " + this.fTarget.getClass().getName());
                return;
            }
            IPath targetPath = (IPath)this.fTarget;
            IEditorDescriptor ed = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(targetPath.lastSegment());
            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage activePage = activeWindow.getActivePage();
            if (ed == null) {
                MessageDialog.openError((Shell)activeWindow.getShell(), (String)"Error", (String)("No editor defined for target file " + targetPath.toPortableString()));
                return;
            }
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            IPath wsLoc = wsRoot.getLocation();
            try {
                boolean targetPathHasWSPrefix = wsLoc.isPrefixOf(targetPath);
                if (targetPathHasWSPrefix || wsRoot.getFile(targetPath).exists()) {
                    IFile file = wsRoot.getFile(targetPathHasWSPrefix ? targetPath.removeFirstSegments(wsLoc.segmentCount()) : targetPath);
                    FileEditorInput editorInput = new FileEditorInput(file);
                    editor = activePage.openEditor((IEditorInput)editorInput, ed.getId());
                } else {
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(targetPath);
                    editor = IDE.openEditorOnFileStore((IWorkbenchPage)activePage, (IFileStore)fileStore);
                }
            }
            catch (PartInitException e) {
                RuntimePlugin.getInstance().logException(e.getLocalizedMessage(), e);
                return;
            }
            this.fSelectionService = editor instanceof IRegionSelectionService ? (IRegionSelectionService)editor : (IRegionSelectionService)editor.getAdapter(IRegionSelectionService.class);
        }
        if (this.fSelectionService != null) {
            this.fSelectionService.selectAndReveal(this.fTargetStart, this.fTargetLength);
        }
    }
}

