/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.imp.editor.SourceEntityImageDescriptor;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.DecorationDescriptor;
import org.eclipse.imp.services.IEntityImageDecorator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageDecoratorController {
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final DecorationDescriptor WARNING_DECORATION = new DecorationDescriptor(1, RuntimePlugin.getInstance().getBundle(), "icons/warning_co.gif", DecorationDescriptor.Quadrant.BOTTOM_LEFT);
    public static final DecorationDescriptor ERROR_DECORATION = new DecorationDescriptor(2, RuntimePlugin.getInstance().getBundle(), "icons/error_co.gif", DecorationDescriptor.Quadrant.BOTTOM_LEFT);
    private final IEntityImageDecorator fDecorator;
    private final List<DecorationDescriptor> topLeftDecorations = new LinkedList<DecorationDescriptor>();
    private final List<DecorationDescriptor> topRightDecorations = new LinkedList<DecorationDescriptor>();
    private final List<DecorationDescriptor> bottomLeftDecorations = new LinkedList<DecorationDescriptor>();
    private final List<DecorationDescriptor> bottomRightDecorations = new LinkedList<DecorationDescriptor>();

    public ImageDecoratorController(Language lang) {
        this.fDecorator = ServiceFactory.getInstance().getEntityImageDecorator(lang);
        if (this.fDecorator != null) {
            DecorationDescriptor[] allDescs = this.fDecorator.getAllDecorations();
            for (int i = 0; i < allDescs.length; ++i) {
                DecorationDescriptor desc = allDescs[i];
                if (desc.quadrant == DecorationDescriptor.Quadrant.BOTTOM_LEFT) {
                    this.bottomLeftDecorations.add(desc);
                    continue;
                }
                if (desc.quadrant == DecorationDescriptor.Quadrant.BOTTOM_RIGHT) {
                    this.bottomRightDecorations.add(desc);
                    continue;
                }
                if (desc.quadrant == DecorationDescriptor.Quadrant.TOP_LEFT) {
                    this.topLeftDecorations.add(desc);
                    continue;
                }
                if (desc.quadrant != DecorationDescriptor.Quadrant.TOP_RIGHT) continue;
                this.topRightDecorations.add(desc);
            }
        }
        this.bottomRightDecorations.add(WARNING_DECORATION);
        this.bottomRightDecorations.add(ERROR_DECORATION);
    }

    public SourceEntityImageDescriptor getImageDescriptor(ImageDescriptor baseImage, Object entity, Point size) {
        int attrs = this.fDecorator.getDecorationAttributes(entity);
        return new SourceEntityImageDescriptor(baseImage, attrs, size, this);
    }

    public List<DecorationDescriptor> getBottomLeftDecorations() {
        return this.bottomLeftDecorations;
    }

    public List<DecorationDescriptor> getBottomRightDecorations() {
        return this.bottomRightDecorations;
    }

    public List<DecorationDescriptor> getTopLeftDecorations() {
        return this.topLeftDecorations;
    }

    public List<DecorationDescriptor> getTopRightDecorations() {
        return this.topRightDecorations;
    }
}

