/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public interface IPreferencesService {
    public static final String PROJECT_LEVEL = "project";
    public static final String INSTANCE_LEVEL = "instance";
    public static final String CONFIGURATION_LEVEL = "configuration";
    public static final String DEFAULT_LEVEL = "default";
    public static final int PROJECT_INDEX = 0;
    public static final int INSTANCE_INDEX = 1;
    public static final int CONFIGURATION_INDEX = 2;
    public static final int DEFAULT_INDEX = 3;
    public static final String[] levels = new String[]{"project", "instance", "configuration", "default"};

    public int indexForLevel(String var1);

    public boolean isaPreferencesLevel(String var1);

    public void setLanguageName(String var1);

    public String getLanguageName();

    public void setProjectName(String var1);

    public String getProjectName();

    public void setProject(IProject var1);

    public IProject getProject();

    public IEclipsePreferences getPreferences(String var1);

    public void setPreferences(String var1, IEclipsePreferences var2);

    public boolean getBooleanPreference(String var1);

    public byte[] getByteArrayPreference(String var1);

    public double getDoublePreference(String var1);

    public float getFloatPreference(String var1);

    public int getIntPreference(String var1);

    public long getLongPreference(String var1);

    public String getStringPreference(String var1);

    public String getRawStringPreference(String var1);

    public boolean getBooleanPreference(IProject var1, String var2);

    public byte[] getByteArrayPreference(IProject var1, String var2);

    public double getDoublePreference(IProject var1, String var2);

    public float getFloatPreference(IProject var1, String var2);

    public int getIntPreference(IProject var1, String var2);

    public long getLongPreference(IProject var1, String var2);

    public String getStringPreference(IProject var1, String var2);

    public String getRawStringPreference(IProject var1, String var2);

    public boolean getBooleanPreference(String var1, String var2);

    public byte[] getByteArrayPreference(String var1, String var2);

    public double getDoublePreference(String var1, String var2);

    public float getFloatPreference(String var1, String var2);

    public int getIntPreference(String var1, String var2);

    public long getLongPreference(String var1, String var2);

    public String getStringPreference(String var1, String var2);

    public String getRawStringPreference(String var1, String var2);

    public boolean getBooleanPreferenceForProject(IProject var1, String var2);

    public byte[] getByteArrayPreferenceForProject(IProject var1, String var2);

    public double getDoublePreferenceForProject(IProject var1, String var2);

    public float getFloatPreferenceForProject(IProject var1, String var2);

    public int getIntPreferenceForProject(IProject var1, String var2);

    public long getLongPreferenceForProject(IProject var1, String var2);

    public String getStringPreferenceForProject(IProject var1, String var2);

    public String getRawStringPreferenceForProject(IProject var1, String var2);

    public void setBooleanPreference(String var1, String var2, boolean var3);

    public void setByteArrayPreference(String var1, String var2, byte[] var3);

    public void setDoublePreference(String var1, String var2, double var3);

    public void setFloatPreference(String var1, String var2, float var3);

    public void setIntPreference(String var1, String var2, int var3);

    public void setLongPreference(String var1, String var2, long var3);

    public void setStringPreference(String var1, String var2, String var3);

    public boolean getBooleanPreference(String var1, String var2, String var3, String var4, boolean var5);

    public byte[] getByteArrayPreference(String var1, String var2, String var3, String var4, byte[] var5);

    public double getDoublePreference(String var1, String var2, String var3, String var4, double var5);

    public float getFloatPreference(String var1, String var2, String var3, String var4, float var5);

    public int getIntPreference(String var1, String var2, String var3, String var4, int var5);

    public long getLongPreference(String var1, String var2, String var3, String var4, long var5);

    public String getStringPreference(String var1, String var2, String var3, String var4, String var5);

    public String getRawStringPreference(String var1, String var2, String var3, String var4, String var5);

    public void setBooleanPreference(String var1, String var2, String var3, String var4, boolean var5);

    public void setByteArrayPreference(String var1, String var2, String var3, String var4, byte[] var5);

    public void setDoublePreference(String var1, String var2, String var3, String var4, double var5);

    public void setFloatPreference(String var1, String var2, String var3, String var4, float var5);

    public void setIntPreference(String var1, String var2, String var3, String var4, int var5);

    public void setLongPreference(String var1, String var2, String var3, String var4, long var5);

    public void setStringPreference(String var1, String var2, String var3, String var4, String var5);

    public String performSubstitutions(String var1);

    public String performSubstitutions(String var1, IProject var2);

    public IEclipsePreferences clearPreferencesAtLevel(String var1);

    public String clearPreferenceAtLevel(String var1, String var2);

    public IEclipsePreferences clearPreferencesAtLevel(IProject var1, String var2);

    public String clearPreferenceAtLevel(IProject var1, String var2, String var3);

    public String getApplicableLevel(String var1, String var2);

    public boolean isDefault(String var1, String var2);

    public boolean isDefined(String var1);

    public String getApplicableLevel(IProject var1, String var2, String var3);

    public boolean isDefault(IProject var1, String var2, String var3);

    public boolean isDefined(IProject var1, String var2);

    public IEclipsePreferences getRootNode();

    public IEclipsePreferences getNodeForLevel(String var1);

    public IEclipsePreferences getNodeForProject(IProject var1);

    public IEclipsePreferences[] getNodesForLevels();

    public IEclipsePreferences[] getNodesForLevels(IProject var1);

    public IScopeContext getScopeForLevel(String var1);

    public IScopeContext getScopeForProject(IProject var1);

    public int getIndexForLevel(String var1);

    public void addProjectSelectionListener(IProjectSelectionListener var1);

    public void removeProjectSelectionListener(IProjectSelectionListener var1);

    public static interface IProjectSelectionListener {
        public void selection(ProjectSelectionEvent var1);
    }

    public static final class ProjectSelectionEvent {
        private static final long serialVersionUID = 1L;
        private Preferences previous;
        private Preferences neww;

        public ProjectSelectionEvent(Preferences previous, Preferences neww) {
            this.previous = previous;
            this.neww = neww;
        }

        public Preferences getPrevious() {
            return this.previous;
        }

        public Preferences getNew() {
            return this.neww;
        }
    }

    public static abstract class IntegerPreferenceListener
    extends PreferenceServiceListener {
        public IntegerPreferenceListener(IPreferencesService service, String key) {
            super(service, key);
        }

        protected final void handleChange(Object oldValue, Object newValue) {
            this.changed(Integer.parseInt((String)oldValue), Integer.parseInt((String)newValue));
        }

        public abstract void changed(int var1, int var2);
    }

    public static abstract class BooleanPreferenceListener
    extends PreferenceServiceListener {
        public BooleanPreferenceListener(IPreferencesService service, String key) {
            super(service, key);
        }

        protected final void handleChange(Object oldValue, Object newValue) {
            this.changed(Boolean.parseBoolean((String)oldValue), Boolean.parseBoolean((String)newValue));
        }

        public abstract void changed(boolean var1, boolean var2);
    }

    public static abstract class StringPreferenceListener
    extends PreferenceServiceListener {
        public StringPreferenceListener(IPreferencesService service, String key) {
            super(service, key);
        }

        protected final void handleChange(Object oldValue, Object newValue) {
            this.changed((String)oldValue, (String)newValue);
        }

        public abstract void changed(String var1, String var2);
    }

    public static abstract class PreferenceServiceListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final String fKey;
        private final IEclipsePreferences fConfigLevel;
        private final IEclipsePreferences fWSLevel;
        private final IEclipsePreferences fProjLevel;

        PreferenceServiceListener(IPreferencesService service, String key) {
            this.fKey = key;
            this.fConfigLevel = service.getPreferences(IPreferencesService.CONFIGURATION_LEVEL);
            this.fWSLevel = service.getPreferences(IPreferencesService.INSTANCE_LEVEL);
            this.fProjLevel = service.getPreferences(IPreferencesService.PROJECT_LEVEL);
            this.fConfigLevel.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            this.fWSLevel.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            if (this.fProjLevel != null) {
                this.fProjLevel.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            }
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!event.getKey().equals(this.fKey)) {
                return;
            }
            this.handleChange(event.getOldValue(), event.getNewValue());
        }

        public void dispose() {
            try {
                if (this.fConfigLevel.nodeExists("")) {
                    this.fConfigLevel.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                }
                if (this.fWSLevel.nodeExists("")) {
                    this.fWSLevel.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                }
                if (this.fProjLevel != null && this.fProjLevel.nodeExists("")) {
                    this.fProjLevel.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                }
            }
            catch (BackingStoreException e) {
                RuntimePlugin.getInstance().logException(e.getMessage(), e);
            }
        }

        protected abstract void handleChange(Object var1, Object var2);
    }
}

