/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final int DEFAULT_SOURCE_FONT_STYLE = 0;
    private static final int DEFAULT_SOURCE_FONT_HEIGHT = Platform.getOS().equals("macosx") ? 11 : 10;
    private static String[] sSourceFontNames = new String[]{"Monaco", "Courier New", "Monospace", "Courier"};

    public void initializeDefaultPreferences() {
        if (Display.getCurrent() == null) {
            UIJob job = new UIJob("IMP Preference Initializer"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (Display.getCurrent() != null) {
                        new PreferenceInitializer().initializeDefaultPreferences();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule(0L);
            return;
        }
        IPreferenceStore store = RuntimePlugin.getInstance().getPreferenceStore();
        FontData fontData = this.findSuitableFont();
        if (fontData != null) {
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sourceFont", (FontData[])new FontData[]{fontData});
        }
        store.setDefault("emitMessages", false);
        store.setDefault("emitBuilderDiagnostics", false);
        store.setDefault("tabWidth", 8);
        store.setDefault("spacesForTabs", false);
        store.setDefault("dumpTokens", false);
        store.setDefault("matchingBrackets", true);
        store.setDefault("tabWidth", 4);
        store.setDefault("spacesForTabs", false);
        String colorKey = "org.eclipse.imp.runtime.matchingBracketsColor";
        ColorRegistry registry = null;
        if (PlatformUI.isWorkbenchRunning()) {
            registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        }
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"matchingBracketsColor", (RGB)PreferenceInitializer.findRGB(registry, colorKey, new RGB(192, 192, 192)));
    }

    private FontData findSuitableFont() {
        FontData fontData = null;
        Display display = this.getDisplay();
        FontData[] scalableFonts = display.getFontList(null, true);
        fontData = this.searchFontList(scalableFonts, true);
        if (fontData == null) {
            FontData[] fixedWidthFonts = display.getFontList(null, false);
            fontData = this.searchFontList(fixedWidthFonts, false);
        }
        return fontData;
    }

    private FontData searchFontList(FontData[] fonts, boolean scalable) {
        FontData fontData = null;
        for (String fn : sSourceFontNames) {
            for (FontData fd : fonts) {
                if (!fd.getName().equals(fn) || fd.getStyle() != 0 || fd.getHeight() != DEFAULT_SOURCE_FONT_HEIGHT && !scalable) continue;
                fontData = new FontData(fd.getName(), DEFAULT_SOURCE_FONT_HEIGHT, fd.getStyle());
                break;
            }
            if (fontData != null) break;
        }
        return fontData;
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        return display;
    }

    private static RGB findRGB(ColorRegistry registry, String key, RGB defaultRGB) {
        if (registry == null) {
            return defaultRGB;
        }
        RGB rgb = registry.getRGB(key);
        if (rgb != null) {
            return rgb;
        }
        return defaultRGB;
    }
}

