/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lpg.runtime.IPrsStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.imp.builder.BuilderBase;
import org.eclipse.imp.builder.MarkerCreator;
import org.eclipse.imp.builder.ProblemLimit;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.SimpleLPGParseController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerCreatorWithBatching
extends MarkerCreator {
    protected String page = null;
    protected Map<Integer, List<Map<String, Object>>> entries = null;
    protected ProblemLimit problemLimit = null;
    protected BuilderBase builder = null;
    public String BUILDER_ID;
    public String PROBLEM_MARKER_ID;
    public Map<Integer, Integer> severityMap = new HashMap<Integer, Integer>();

    public MarkerCreatorWithBatching(IFile file, IParseController parseController, String problemType) {
        super(file, parseController, problemType);
        this.severityMap.put(2, 2);
        this.severityMap.put(0, 0);
        this.severityMap.put(1, 1);
        this.PROBLEM_MARKER_ID = problemType;
    }

    public MarkerCreatorWithBatching(IFile file, IParseController parseController, BuilderBase builder) {
        super(file, parseController, builder.getErrorMarkerID());
        this.severityMap.put(2, 2);
        this.severityMap.put(0, 0);
        this.severityMap.put(1, 1);
        this.builder = builder;
        this.initializeBuidlerID(builder);
        this.initializeProblemMarkerID(builder);
    }

    protected void initializeBuidlerID(BuilderBase builder) {
        this.BUILDER_ID = builder != null ? builder.getBuilderID() : this.parseController.getLanguage().getName() + ".builder";
    }

    protected void initializeProblemMarkerID(BuilderBase builder) {
        this.PROBLEM_MARKER_ID = builder != null ? builder.getErrorMarkerID() : this.parseController.getLanguage().getName() + ".builder";
    }

    public void setSeverityMap(Map<Integer, Integer> mapOfSeverities) {
        this.severityMap = mapOfSeverities;
    }

    public Map<Integer, Integer> getSeverityMap() {
        return this.severityMap;
    }

    public void addMarker(int severity, String message, int lineNumber, int charStart, int charEnd) throws ProblemLimit.LimitExceededException {
        List<Map<String, Object>> lineEntries;
        String adjustedMessage = message;
        if (this.problemLimit != null && (adjustedMessage = this.problemLimit.check(severity, message)) == null) {
            return;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("message", adjustedMessage);
        attributes.put("severity", severity);
        if (lineNumber == -1) {
            lineNumber = 1;
        }
        Integer lineKey = lineNumber;
        attributes.put("lineNumber", lineKey);
        if (charStart <= charEnd) {
            attributes.put("charStart", charStart);
            attributes.put("charEnd", charEnd);
        }
        if (this.builder != null) {
            attributes.put(this.BUILDER_ID, this.builder.getBuilderID());
        }
        if (this.entries == null) {
            this.entries = new HashMap<Integer, List<Map<String, Object>>>();
        }
        if ((lineEntries = this.entries.get(lineKey)) == null) {
            lineEntries = new ArrayList<Map<String, Object>>();
            this.entries.put(lineKey, lineEntries);
        }
        lineEntries.add(attributes);
        if (adjustedMessage != message) {
            throw new ProblemLimit.LimitExceededException(adjustedMessage);
        }
    }

    @Override
    public void clearMessages() {
    }

    @Override
    public void endMessageGroup() {
    }

    public void flush(IProgressMonitor monitor) {
        if (this.file.exists()) {
            IWorkspaceRunnable action = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    String markerId = MarkerCreatorWithBatching.this.PROBLEM_MARKER_ID;
                    if (MarkerCreatorWithBatching.this.entries != null) {
                        IMarker[] oldMarkers;
                        for (IMarker oldMarker : oldMarkers = MarkerCreatorWithBatching.this.file.findMarkers(markerId, false, 0)) {
                            Map oldAttributes = oldMarker.getAttributes();
                            List<Map<String, Object>> lineEntries = MarkerCreatorWithBatching.this.entries.get(oldAttributes.get("lineNumber"));
                            if (lineEntries != null) {
                                for (Map<String, Object> newAttributes : lineEntries) {
                                    if (!MarkerCreatorWithBatching.this.isSameMarker(oldAttributes, newAttributes)) continue;
                                    lineEntries.remove(newAttributes);
                                    oldMarker = null;
                                    break;
                                }
                            }
                            if (oldMarker == null) continue;
                            oldMarker.delete();
                        }
                        for (List<Map<String, Object>> lineEntries : MarkerCreatorWithBatching.this.entries.values()) {
                            for (Map<String, Object> entry : lineEntries) {
                                IMarker marker = MarkerCreatorWithBatching.this.file.createMarker(markerId);
                                marker.setAttributes(entry);
                            }
                        }
                    } else {
                        MarkerCreatorWithBatching.this.file.deleteMarkers(markerId, false, 0);
                    }
                }
            };
            try {
                NullProgressMonitor progressMonitor = new NullProgressMonitor();
                this.file.getWorkspace().run(action, (ISchedulingRule)this.file, 1, (IProgressMonitor)progressMonitor);
            }
            catch (CoreException e) {
                ErrorHandler.logError("Failed to update file markers", e);
            }
        }
    }

    public void handleProblem(int problemSeverity, String contextPrefix, String problemMessage, String processingContext, int startOffset, int endOffset) throws ProblemLimit.LimitExceededException {
        Integer severity;
        int leftToken;
        int line = -1;
        if (startOffset >= 0 && (leftToken = Math.abs(this.getParseStream().getTokenIndexAtCharacter(startOffset))) >= 0) {
            line = this.getParseStream().getLine(leftToken);
        }
        this.addMarker((severity = this.severityMap.get(problemSeverity)) != null ? severity : 2, contextPrefix + ": " + problemMessage, line, startOffset, endOffset + 1);
    }

    @Override
    public void handleSimpleMessage(String msg, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine) {
        try {
            this.addMarker(2, msg, startLine, startOffset, endOffset + 1);
        }
        catch (ProblemLimit.LimitExceededException e) {
            e.printStackTrace();
        }
    }

    public boolean isSameMarker(Map<?, ?> oldAttributes, Map<String, Object> newAttributes) {
        Set<?> oldKeys = oldAttributes.keySet();
        Set<String> newKeys = newAttributes.keySet();
        if (oldKeys.size() != newKeys.size()) {
            return false;
        }
        for (String key : newKeys) {
            Object newValue;
            if (!oldAttributes.containsKey(key)) {
                return false;
            }
            Object oldValue = oldAttributes.get(key);
            if (oldValue == (newValue = newAttributes.get(key))) continue;
            if (oldValue == null) {
                return false;
            }
            if (newValue == null) {
                return false;
            }
            if (oldValue.equals(newValue)) continue;
            return false;
        }
        return true;
    }

    public void setProblemLimit(ProblemLimit problemLimit) {
        this.problemLimit = problemLimit;
    }

    public void setPage(String page) {
        this.page = page;
    }

    @Override
    public void startMessageGroup(String groupName) {
    }

    protected IPrsStream getParseStream() {
        return ((SimpleLPGParseController)this.parseController).getParser().getIPrsStream();
    }
}

