/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.editor.HyperlinkDetector;
import org.eclipse.imp.editor.OutlineLabelProvider;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.preferences.PreferenceCache;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.IAutoEditStrategy;
import org.eclipse.imp.services.IContentProposer;
import org.eclipse.imp.services.IDocumentationProvider;
import org.eclipse.imp.services.IFoldingUpdater;
import org.eclipse.imp.services.IHelpService;
import org.eclipse.imp.services.IHoverHelper;
import org.eclipse.imp.services.ILanguageActionsContributor;
import org.eclipse.imp.services.IOccurrenceMarker;
import org.eclipse.imp.services.IRefactoringContributor;
import org.eclipse.imp.services.IReferenceResolver;
import org.eclipse.imp.services.ISourceFormatter;
import org.eclipse.imp.services.ISourceHyperlinkDetector;
import org.eclipse.imp.services.IToggleBreakpointsHandler;
import org.eclipse.imp.services.ITokenColorer;
import org.eclipse.imp.services.base.TreeModelBuilderBase;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageServiceManager {
    private Language fLanguage;
    private ServiceFactory fServiceFactory = ServiceFactory.getInstance();
    private IParseController fParseController;
    private ITokenColorer fTokenColorer;
    private IReferenceResolver fResolver;
    private IAnnotationHover fAnnotationHover;
    private IHoverHelper fHoverHelper;
    private ILabelProvider fLabelProvider;
    private OutlineLabelProvider.IElementImageProvider fImageProvider;
    private TreeModelBuilderBase fModelBuilder;
    private IOccurrenceMarker fOccurrenceMarker;
    private ISourceHyperlinkDetector fHyperLinkDetector;
    private IFoldingUpdater fFoldingUpdater;
    private ISourceFormatter fFormattingStrategy;
    private Set<IAutoEditStrategy> fAutoEditStrategies;
    private IContentProposer fContentProposer;
    private Set<IRefactoringContributor> fRefactoringContributors;
    private Set<ILanguageActionsContributor> fActionContributors;
    private IDocumentationProvider fDocProvider;
    private Set<IModelListener> fEditorServices;
    private IHelpService fContextHelper;
    private IToggleBreakpointsHandler fToggleBreakpointsHandler;
    private static HashMap<IEditorPart, LanguageServiceManager> editorServiceMap = new HashMap();

    public LanguageServiceManager(Language lang) {
        this.fLanguage = lang;
    }

    public void initialize(IEditorPart part) {
        LanguageServiceManager.saveMyServiceManager(part, this);
        if (PreferenceCache.emitMessages) {
            RuntimePlugin.getInstance().writeInfoMsg("Instantiating language service extensions for " + this.fLanguage.getName());
        }
        this.fActionContributors = this.fServiceFactory.getLanguageActionsContributors(this.fLanguage);
        this.fAnnotationHover = this.fServiceFactory.getAnnotationHover(this.fLanguage);
        this.fAutoEditStrategies = this.fServiceFactory.getAutoEditStrategies(this.fLanguage);
        this.fContentProposer = this.fServiceFactory.getContentProposer(this.fLanguage);
        this.fContextHelper = this.fServiceFactory.getContextHelper(this.fLanguage);
        this.fDocProvider = this.fServiceFactory.getDocumentationProvider(this.fLanguage);
        this.fEditorServices = this.fServiceFactory.getEditorServices(this.fLanguage);
        this.fFoldingUpdater = this.fServiceFactory.getFoldingUpdater(this.fLanguage);
        this.fFormattingStrategy = this.fServiceFactory.getSourceFormatter(this.fLanguage);
        this.fHyperLinkDetector = this.fServiceFactory.getSourceHyperlinkDetector(this.fLanguage);
        this.fImageProvider = this.fServiceFactory.getElementImageProvider(this.fLanguage);
        this.fModelBuilder = this.fServiceFactory.getTreeModelBuilder(this.fLanguage);
        this.fLabelProvider = this.fServiceFactory.getLabelProvider(this.fLanguage);
        this.fOccurrenceMarker = this.fServiceFactory.getOccurrenceMarker(this.fLanguage);
        this.fParseController = this.fServiceFactory.getParseController(this.fLanguage);
        this.fRefactoringContributors = this.fServiceFactory.getRefactoringContributors(this.fLanguage);
        this.fResolver = this.fServiceFactory.getReferenceResolver(this.fLanguage);
        this.fToggleBreakpointsHandler = this.fServiceFactory.getToggleBreakpointsHandler(this.fLanguage);
        this.fTokenColorer = this.fServiceFactory.getTokenColorer(this.fLanguage);
        if (this.fHyperLinkDetector == null) {
            this.fHyperLinkDetector = new HyperlinkDetector(this.fLanguage);
        }
        if (this.fParseController == null) {
            ErrorHandler.reportError("Unable to instantiate parser for language '" + this.fLanguage.getName() + "'; parser-related services will be disabled.", true, true);
        }
    }

    public Language getLanguage() {
        return this.fLanguage;
    }

    public Set<ILanguageActionsContributor> getActionContributors() {
        return this.fActionContributors;
    }

    public IAnnotationHover getAnnotationHover() {
        return this.fAnnotationHover;
    }

    public Set<IAutoEditStrategy> getAutoEditStrategies() {
        return this.fAutoEditStrategies;
    }

    public IContentProposer getContentProposer() {
        return this.fContentProposer;
    }

    public IHelpService getContextHelp() {
        return this.fContextHelper;
    }

    public IDocumentationProvider getDocProvider() {
        return this.fDocProvider;
    }

    public Set<IModelListener> getEditorServices() {
        return this.fEditorServices;
    }

    public IFoldingUpdater getFoldingUpdater() {
        return this.fFoldingUpdater;
    }

    public ISourceFormatter getFormattingStrategy() {
        return this.fFormattingStrategy;
    }

    public IHoverHelper getHoverHelper() {
        return this.fHoverHelper;
    }

    public ISourceHyperlinkDetector getHyperLinkDetector() {
        return this.fHyperLinkDetector;
    }

    public OutlineLabelProvider.IElementImageProvider getImageProvider() {
        return this.fImageProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    public TreeModelBuilderBase getModelBuilder() {
        return this.fModelBuilder;
    }

    public IOccurrenceMarker getOccurrenceMarker() {
        return this.fOccurrenceMarker;
    }

    public IParseController getParseController() {
        return this.fParseController;
    }

    public Set<IRefactoringContributor> getRefactoringContributors() {
        return this.fRefactoringContributors;
    }

    public IReferenceResolver getResolver() {
        return this.fResolver;
    }

    public IToggleBreakpointsHandler getToggleBreakpointsHandler() {
        return this.fToggleBreakpointsHandler;
    }

    public ITokenColorer getTokenColorer() {
        return this.fTokenColorer;
    }

    public static void saveMyServiceManager(IEditorPart part, LanguageServiceManager manager) {
        LanguageServiceManager.clearDeadEntries();
        editorServiceMap.put(part, manager);
    }

    public static LanguageServiceManager getMyServiceManager(IEditorPart part) {
        LanguageServiceManager.clearDeadEntries();
        return editorServiceMap.get(part);
    }

    private static void clearDeadEntries() {
        ArrayList<IWorkbenchPart> deadEditors = new ArrayList<IWorkbenchPart>();
        for (IEditorPart ed : editorServiceMap.keySet()) {
            IEditorSite edSite = ed.getEditorSite();
            IWorkbenchPart wbPart = edSite.getPart();
            if (wbPart != null) continue;
            deadEditors.add(wbPart);
        }
        for (IWorkbenchPart wbPart : deadEditors) {
            editorServiceMap.remove(wbPart);
        }
    }
}

