/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.IToggleBreakpointsHandler;
import org.eclipse.imp.smapi.LineMapBuilder;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleBreakpointsAdapter
implements IToggleBreakpointsTarget,
IBreakpointListener {
    private final IToggleBreakpointsHandler fHandler;

    public ToggleBreakpointsAdapter(UniversalEditor editor, IToggleBreakpointsHandler handler) {
        this.fHandler = handler;
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (selection instanceof ITextSelection) {
            ITextSelection textSel = (ITextSelection)selection;
            IEditorPart editorPart = (IEditorPart)part.getAdapter(IEditorPart.class);
            IFileEditorInput fileInput = (IFileEditorInput)editorPart.getEditorInput();
            final IFile origSrcFile = fileInput.getFile();
            final int lineNumber = textSel.getStartLine() + 1;
            IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker marker = ToggleBreakpointsAdapter.this.findBreakpointMarker(origSrcFile, lineNumber);
                    if (marker != null) {
                        ToggleBreakpointsAdapter.this.fHandler.clearLineBreakpoint(origSrcFile, lineNumber);
                    } else {
                        ToggleBreakpointsAdapter.this.fHandler.setLineBreakpoint(origSrcFile, lineNumber);
                    }
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(wr, null);
            }
            catch (CoreException e) {
                throw new DebugException(e.getStatus());
            }
        }
    }

    public static boolean validateLineNumber(IFile origSrcFile, Integer origSrcLineNumber) {
        LineMapBuilder lmb = new LineMapBuilder(origSrcFile.getRawLocation().removeFileExtension().toString());
        Map lineMap = lmb.getLineMap();
        return lineMap.containsKey(origSrcLineNumber);
    }

    private IMarker findBreakpointMarker(IFile srcFile, int lineNumber) throws CoreException {
        IMarker[] markers = srcFile.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 2);
        for (int k = 0; k < markers.length; ++k) {
            if ((Integer)markers[k].getAttribute("lineNumber") != lineNumber) continue;
            return markers[k];
        }
        return null;
    }

    public static IFile javaFileForRootSourceFile(IFile rootSrcFile) {
        IProject project = rootSrcFile.getProject();
        String rootSrcName = rootSrcFile.getName();
        return project.getFile(rootSrcFile.getProjectRelativePath().removeLastSegments(1).append(rootSrcName.substring(0, rootSrcName.lastIndexOf(46)) + ".java"));
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public static String getTypeName(IFile origSrcFile) {
        String temp;
        IProject project = origSrcFile.getProject();
        IJavaProject javaProj = JavaCore.create((IProject)project);
        String pathPrefix = project.getWorkspace().getRoot().getRawLocation() + project.getFullPath().toString();
        IPath projPath = project.getFullPath();
        try {
            boolean projectIsSrcBin;
            boolean bl = projectIsSrcBin = javaProj.getOutputLocation().matchingFirstSegments(projPath) == projPath.segmentCount() && javaProj.getOutputLocation().segmentCount() == projPath.segmentCount();
            if (!projectIsSrcBin) {
                temp = origSrcFile.getRawLocation().toString().substring(pathPrefix.length()).substring(1);
                pathPrefix = pathPrefix + "/" + temp.substring(0, temp.indexOf("/"));
            }
        }
        catch (JavaModelException e) {
            RuntimePlugin.getInstance().logException("Error determining path of file " + origSrcFile.getFullPath(), e);
        }
        temp = origSrcFile.getRawLocation().toString().substring(pathPrefix.length()).replaceAll("/", ".");
        return temp.substring(1, temp.lastIndexOf("."));
    }
}

